/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyConnectionListener;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnectionFactory;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyAddressImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyState;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class AESocksProxyConnectionImpl
implements AESocksProxyConnection,
AEProxyConnectionListener {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final boolean TRACE = false;
    protected AESocksProxyImpl proxy;
    protected AEProxyConnection connection;
    protected boolean disable_dns_lookups;
    protected SocketChannel source_channel;
    protected int socks_version;
    protected AESocksProxyPlugableConnection plugable_connection;

    protected AESocksProxyConnectionImpl(AESocksProxyImpl aESocksProxyImpl, AESocksProxyPlugableConnectionFactory aESocksProxyPlugableConnectionFactory, AEProxyConnection aEProxyConnection) throws IOException {
        this.proxy = aESocksProxyImpl;
        this.connection = aEProxyConnection;
        this.connection.addListener(this);
        this.source_channel = this.connection.getSourceChannel();
        try {
            this.plugable_connection = aESocksProxyPlugableConnectionFactory.create(this);
        }
        catch (AEProxyException aEProxyException) {
            throw new IOException(aEProxyException.getMessage());
        }
    }

    @Override
    public AESocksProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setDelegate(AESocksProxyPlugableConnection aESocksProxyPlugableConnection) {
        this.plugable_connection = aESocksProxyPlugableConnection;
    }

    protected String getName() {
        String string = this.connection.getName() + ", ver = " + this.socks_version;
        string = string + this.plugable_connection.getName();
        return string;
    }

    protected AEProxyState getInitialState() {
        return new proxyStateVersion();
    }

    @Override
    public void connectionClosed(AEProxyConnection aEProxyConnection) {
        try {
            if (this.plugable_connection != null) {
                this.plugable_connection.close();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    @Override
    public AEProxyConnection getConnection() {
        return this.connection;
    }

    @Override
    public void disableDNSLookups() {
        this.disable_dns_lookups = true;
    }

    @Override
    public void enableDNSLookups() {
        this.disable_dns_lookups = false;
    }

    @Override
    public void close() throws IOException {
        new proxyStateClose();
    }

    @Override
    public void connected() throws IOException {
        if (this.socks_version == 4) {
            new proxyStateV4Reply();
        } else {
            new proxyStateV5Reply();
        }
    }

    protected class proxyStateClose
    extends AESocksProxyState {
        protected proxyStateClose() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.close();
            AESocksProxyConnectionImpl.this.connection.setReadState(null);
            AESocksProxyConnectionImpl.this.connection.setWriteState(null);
            AESocksProxyConnectionImpl.this.connection.setConnectState(null);
        }
    }

    protected class proxyStateV5Reply
    extends AESocksProxyState {
        protected proxyStateV5Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] byArray = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int n = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            this.buffer = ByteBuffer.wrap(new byte[]{5, 0, 0, 1, byArray[0], byArray[1], byArray[2], byArray[3], (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        @Override
        protected boolean writeSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(socketChannel);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
            return n > 0;
        }
    }

    protected class proxyStateV5RequestPort
    extends AESocksProxyState {
        protected String unresolved_address;
        protected InetAddress address;

        protected proxyStateV5RequestPort(String string, InetAddress inetAddress) {
            super(AESocksProxyConnectionImpl.this);
            this.unresolved_address = string;
            this.address = inetAddress;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(2);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            int n2 = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
            AESocksProxyConnectionImpl.this.socks_version = 5;
            AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.unresolved_address, this.address, n2));
            return true;
        }
    }

    protected class proxyStateV5RequestDNS
    extends AESocksProxyState {
        boolean got_length;

        protected proxyStateV5RequestDNS() {
            super(AESocksProxyConnectionImpl.this);
            this.got_length = false;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        @Override
        protected boolean readSupport(final SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (!this.got_length) {
                int n2 = this.buffer.get() & 0xFF;
                this.buffer = ByteBuffer.allocate(n2);
                this.got_length = true;
            } else {
                String string = "";
                while (this.buffer.hasRemaining()) {
                    string = string + (char)this.buffer.get();
                }
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    new proxyStateV5RequestPort(string, null);
                } else {
                    final String string2 = string;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(socketChannel);
                    HostNameToIPResolver.addResolverRequest(string, new HostNameToIPResolverListener(){

                        @Override
                        public void hostNameResolutionComplete(InetAddress inetAddress) {
                            new proxyStateV5RequestPort(string2, inetAddress);
                            AESocksProxyConnectionImpl.this.connection.requestReadSelect(socketChannel);
                        }
                    });
                }
            }
            return true;
        }
    }

    protected class proxyStateV5RequestIP
    extends AESocksProxyState {
        protected proxyStateV5RequestIP() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte[] byArray = new byte[4];
            this.buffer.get(byArray);
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            new proxyStateV5RequestPort("", inetAddress);
            return true;
        }
    }

    protected class proxyStateV5Request
    extends AESocksProxyState {
        protected proxyStateV5Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            this.buffer.get();
            byte by = this.buffer.get();
            this.buffer.get();
            byte by2 = this.buffer.get();
            if (by != 1) {
                throw new IOException("V5: Only connect supported");
            }
            if (by2 == 1) {
                new proxyStateV5RequestIP();
            } else if (by2 == 3) {
                new proxyStateV5RequestDNS();
            } else {
                throw new IOException("V5: Unsupported address type");
            }
            return true;
        }
    }

    protected class proxyStateV5MethodsReply
    extends AESocksProxyState {
        protected proxyStateV5MethodsReply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            new proxyStateV5Request();
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            this.buffer = ByteBuffer.wrap(new byte[]{5, 0});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        @Override
        protected boolean writeSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(socketChannel);
            }
            return n > 0;
        }
    }

    protected class proxyStateV5Methods
    extends AESocksProxyState {
        protected proxyStateV5Methods(int n) {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(n);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            new proxyStateV5MethodsReply();
            return true;
        }
    }

    protected class proxyStateV5MethodNumber
    extends AESocksProxyState {
        protected proxyStateV5MethodNumber() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            new proxyStateV5Methods(by);
            return true;
        }
    }

    protected class proxyStateV4Reply
    extends AESocksProxyState {
        protected proxyStateV4Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] byArray = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int n = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            this.buffer = ByteBuffer.wrap(new byte[]{0, 90, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), byArray[0], byArray[1], byArray[2], byArray[3]});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        @Override
        protected boolean writeSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(socketChannel);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
            return n > 0;
        }
    }

    protected class proxyStateV4aRequest
    extends AESocksProxyState {
        protected String dns_address;
        protected int port;

        protected proxyStateV4aRequest(int n) {
            super(AESocksProxyConnectionImpl.this);
            this.port = n;
            this.dns_address = "";
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        @Override
        protected boolean readSupport(final SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            if (by == 0) {
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    AESocksProxyConnectionImpl.this.socks_version = 4;
                    AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.dns_address, null, this.port));
                } else {
                    final String string = this.dns_address;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(socketChannel);
                    HostNameToIPResolver.addResolverRequest(this.dns_address, new HostNameToIPResolverListener(){

                        @Override
                        public void hostNameResolutionComplete(InetAddress inetAddress) {
                            try {
                                AESocksProxyConnectionImpl.this.socks_version = 4;
                                AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(string, inetAddress, proxyStateV4aRequest.this.port));
                                AESocksProxyConnectionImpl.this.connection.requestReadSelect(socketChannel);
                            }
                            catch (IOException iOException) {
                                AESocksProxyConnectionImpl.this.connection.failed(iOException);
                            }
                        }
                    });
                }
            } else {
                this.dns_address = this.dns_address + (char)by;
                if (this.dns_address.length() > 4096) {
                    throw new IOException("DNS name too long");
                }
                this.buffer.flip();
            }
            return true;
        }
    }

    protected class proxyStateV4Request
    extends AESocksProxyState {
        boolean got_header;
        protected int port;
        protected byte[] address;

        protected proxyStateV4Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(7);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (this.got_header) {
                if (this.buffer.get() == 0) {
                    if (this.address[0] == 0 && this.address[1] == 0 && this.address[2] == 0 && this.address[3] != 0) {
                        new proxyStateV4aRequest(this.port);
                    } else {
                        AESocksProxyConnectionImpl.this.socks_version = 4;
                        AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl("", InetAddress.getByAddress(this.address), this.port));
                    }
                } else {
                    this.buffer.flip();
                }
            } else {
                this.got_header = true;
                byte by = this.buffer.get();
                if (by != 1) {
                    throw new IOException("SocksV4: only CONNECT supported");
                }
                this.port = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
                this.address = new byte[4];
                for (int i = 0; i < this.address.length; ++i) {
                    this.address[i] = this.buffer.get();
                }
                this.buffer = ByteBuffer.allocate(1);
            }
            return true;
        }
    }

    protected class proxyStateVersion
    extends AESocksProxyState {
        protected proxyStateVersion() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            int n = socketChannel.read(this.buffer);
            if (n == 0) {
                return false;
            }
            if (n == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            if (by == 5) {
                new proxyStateV5MethodNumber();
            } else if (by == 4) {
                new proxyStateV4Request();
            } else {
                throw new IOException("Unsupported version " + by);
            }
            return true;
        }
    }
}

