/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingBTPieceMessageHandler {
    private final PEPeer peer;
    private final OutgoingMessageQueue outgoing_message_queue;
    private byte piece_version;
    private final LinkedList<DiskManagerReadRequest> requests = new LinkedList();
    private final ArrayList<DiskManagerReadRequest> loading_messages = new ArrayList();
    private final HashMap<BTPiece, DiskManagerReadRequest> queued_messages = new HashMap();
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private int request_read_ahead = 2;
    private OutgoingBTPieceMessageHandlerAdapter adapter;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(diskManagerReadRequest) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    directByteBuffer.returnToPool();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(diskManagerReadRequest);
                BTPiece bTPiece = new BTPiece(diskManagerReadRequest.getPieceNumber(), diskManagerReadRequest.getOffset(), directByteBuffer, OutgoingBTPieceMessageHandler.this.piece_version);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(bTPiece, diskManagerReadRequest);
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(bTPiece, true);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(diskManagerReadRequest) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(diskManagerReadRequest);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.peer.sendRejectRequest(diskManagerReadRequest);
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public void requestExecuted(long l) {
            OutgoingBTPieceMessageHandler.this.adapter.diskRequestCompleted(l);
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        @Override
        public boolean messageAdded(Message message) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
                OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
            }
        }

        @Override
        public void messageQueued(Message message) {
        }

        @Override
        public void messageRemoved(Message message) {
        }

        @Override
        public void protocolBytesSent(int n) {
        }

        @Override
        public void dataBytesSent(int n) {
        }

        @Override
        public void flush() {
        }
    };

    public OutgoingBTPieceMessageHandler(PEPeer pEPeer, OutgoingMessageQueue outgoingMessageQueue, OutgoingBTPieceMessageHandlerAdapter outgoingBTPieceMessageHandlerAdapter, byte by) {
        this.peer = pEPeer;
        this.outgoing_message_queue = outgoingMessageQueue;
        this.adapter = outgoingBTPieceMessageHandlerAdapter;
        this.piece_version = by;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    public void setPieceVersion(byte by) {
        this.piece_version = by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPieceRequest(int n, int n2, int n3) {
        if (this.destroyed) {
            return false;
        }
        DiskManagerReadRequest diskManagerReadRequest = this.peer.getManager().getDiskManager().createReadRequest(n, n2, n3);
        try {
            this.lock_mon.enter();
            this.requests.addLast(diskManagerReadRequest);
        }
        finally {
            this.lock_mon.exit();
        }
        this.doReadAheadLoads();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePieceRequest(int n, int n2, int n3) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest diskManagerReadRequest = this.peer.getManager().getDiskManager().createReadRequest(n, n2, n3);
        boolean bl = false;
        try {
            this.lock_mon.enter();
            if (this.requests.contains(diskManagerReadRequest)) {
                this.requests.remove(diskManagerReadRequest);
                bl = true;
                return;
            }
            if (this.loading_messages.contains(diskManagerReadRequest)) {
                this.loading_messages.remove(diskManagerReadRequest);
                bl = true;
                return;
            }
            Iterator<Map.Entry<BTPiece, DiskManagerReadRequest>> iterator = this.queued_messages.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BTPiece, DiskManagerReadRequest> entry = iterator.next();
                if (!((Object)entry.getValue()).equals(diskManagerReadRequest)) continue;
                BTPiece bTPiece = entry.getKey();
                if (this.outgoing_message_queue.removeMessage(bTPiece, true)) {
                    bl = true;
                    iterator.remove();
                }
                break;
            }
        }
        finally {
            this.lock_mon.exit();
            if (bl) {
                this.peer.sendRejectRequest(diskManagerReadRequest);
            }
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPieceRequests() {
        if (this.destroyed) {
            return;
        }
        ArrayList<DiskManagerReadRequest> arrayList = new ArrayList<DiskManagerReadRequest>();
        try {
            this.lock_mon.enter();
            for (BTPiece object : this.queued_messages.keySet()) {
                if (!this.outgoing_message_queue.removeMessage(object, true)) continue;
                arrayList.add(this.queued_messages.get(object));
            }
            this.queued_messages.clear();
            arrayList.addAll(this.requests);
            this.requests.clear();
            arrayList.addAll(this.loading_messages);
            this.loading_messages.clear();
        }
        finally {
            this.lock_mon.exit();
        }
        for (DiskManagerReadRequest diskManagerReadRequest : arrayList) {
            this.peer.sendRejectRequest(diskManagerReadRequest);
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void setRequestReadAhead(int n) {
        this.request_read_ahead = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lock_mon.enter();
            this.removeAllPieceRequests();
            this.queued_messages.clear();
            this.destroyed = true;
            this.outgoing_message_queue.cancelQueueListener(this.sent_message_listener);
        }
        finally {
            this.lock_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadAheadLoads() {
        ArrayList<DiskManagerReadRequest> arrayList = null;
        try {
            this.lock_mon.enter();
            while (this.loading_messages.size() + this.queued_messages.size() < this.request_read_ahead && !this.requests.isEmpty() && !this.destroyed) {
                DiskManagerReadRequest diskManagerReadRequest = this.requests.removeFirst();
                this.loading_messages.add(diskManagerReadRequest);
                if (arrayList == null) {
                    arrayList = new ArrayList<DiskManagerReadRequest>();
                }
                arrayList.add(diskManagerReadRequest);
            }
        }
        finally {
            this.lock_mon.exit();
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.peer.getManager().getAdapter().enqueueReadRequest(this.peer, (DiskManagerReadRequest)arrayList.get(i), this.read_req_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRequestedPieceNumbers() {
        int[] nArray;
        if (this.destroyed) {
            return new int[0];
        }
        int n = -1;
        int n2 = 0;
        try {
            this.lock_mon.enter();
            nArray = new int[this.queued_messages.size() + this.loading_messages.size() + this.requests.size()];
            for (BTPiece object : this.queued_messages.keySet()) {
                if (n == object.getPieceNumber()) continue;
                n = object.getPieceNumber();
                nArray[n2++] = n;
            }
            for (DiskManagerReadRequest diskManagerReadRequest : this.loading_messages) {
                if (n == diskManagerReadRequest.getPieceNumber()) continue;
                n = diskManagerReadRequest.getPieceNumber();
                nArray[n2++] = n;
            }
            for (DiskManagerReadRequest diskManagerReadRequest : this.requests) {
                if (n == diskManagerReadRequest.getPieceNumber()) continue;
                n = diskManagerReadRequest.getPieceNumber();
                nArray[n2++] = n;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        Object object = new int[n2];
        System.arraycopy(nArray, 0, object, 0, n2);
        return object;
    }

    public int getRequestCount() {
        return this.queued_messages.size() + this.loading_messages.size() + this.requests.size();
    }

    public boolean isStalledPendingLoad() {
        return this.queued_messages.size() == 0 && this.loading_messages.size() > 0;
    }
}

