/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTRejectRequest
implements BTMessage {
    private byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int hashcode;

    public BTRejectRequest(int n, int n2, int n3, byte by) {
        this.piece_number = n;
        this.piece_offset = n2;
        this.length = n3;
        this.version = by;
        this.hashcode = n + n2 + n3;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getID() {
        return "BT_REJECT_REQUEST";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_REJECT_REQUEST_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 16;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_REJECT_REQUEST piece #" + this.piece_number + ":" + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)31, 12);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.putInt((byte)11, this.piece_offset);
            this.buffer.putInt((byte)11, this.length);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) != 12) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + directByteBuffer.remaining((byte)11) + "] != 12");
        }
        int n = directByteBuffer.getInt((byte)11);
        if (n < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: num < 0");
        }
        int n2 = directByteBuffer.getInt((byte)11);
        if (n2 < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: offset < 0");
        }
        int n3 = directByteBuffer.getInt((byte)11);
        if (n3 < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: length < 0");
        }
        directByteBuffer.returnToPool();
        return new BTRejectRequest(n, n2, n3, by);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof BTRejectRequest) {
            BTRejectRequest bTRejectRequest = (BTRejectRequest)object;
            if (bTRejectRequest.piece_number == this.piece_number && bTRejectRequest.piece_offset == this.piece_offset && bTRejectRequest.length == this.length) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

