/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerBasic;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerPrioritised;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public abstract class PeerControlSchedulerImpl
implements PeerControlScheduler,
AzureusCoreStatsProvider,
ParameterListener {
    private static final PeerControlSchedulerImpl[] singletons;
    protected boolean useWeights = true;
    protected long schedule_count;
    protected long wait_count;
    protected long yield_count;
    protected long total_wait_time;

    @Override
    public void parameterChanged(String string) {
        this.useWeights = COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities");
    }

    public static PeerControlScheduler getSingleton(int n) {
        return singletons[n % singletons.length];
    }

    public static void overrideAllWeightedPriorities(boolean bl) {
        for (PeerControlSchedulerImpl peerControlSchedulerImpl : singletons) {
            peerControlSchedulerImpl.overrideWeightedPriorities(bl);
        }
    }

    public static void updateAllScheduleOrdering() {
        for (PeerControlSchedulerImpl peerControlSchedulerImpl : singletons) {
            peerControlSchedulerImpl.updateScheduleOrdering();
        }
    }

    protected PeerControlSchedulerImpl() {
        COConfigurationManager.addAndFireParameterListener("Use Request Limiting Priorities", this);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("peer.control.schedule.count");
        hashSet.add("peer.control.loop.count");
        hashSet.add("peer.control.yield.count");
        hashSet.add("peer.control.wait.count");
        hashSet.add("peer.control.wait.time");
        AzureusCoreStats.registerProvider(hashSet, this);
    }

    protected void start() {
        new AEThread2("PeerControlScheduler", true){

            @Override
            public void run() {
                PeerControlSchedulerImpl.this.schedule();
            }
        }.start();
    }

    public void updateStats(Set set, Map map) {
        if (set.contains("peer.control.schedule.count")) {
            map.put("peer.control.schedule.count", new Long(this.schedule_count));
        }
        if (set.contains("peer.control.loop.count")) {
            map.put("peer.control.loop.count", new Long(this.wait_count + this.yield_count));
        }
        if (set.contains("peer.control.yield.count")) {
            map.put("peer.control.yield.count", new Long(this.yield_count));
        }
        if (set.contains("peer.control.wait.count")) {
            map.put("peer.control.wait.count", new Long(this.wait_count));
        }
        if (set.contains("peer.control.wait.time")) {
            map.put("peer.control.wait.time", new Long(this.total_wait_time));
        }
    }

    protected abstract void schedule();

    @Override
    public void overrideWeightedPriorities(boolean bl) {
        if (bl) {
            this.useWeights = false;
        } else {
            this.parameterChanged(null);
        }
    }

    static {
        int n = COConfigurationManager.getIntParameter("peercontrol.scheduler.parallelism", 1);
        if (n < 1) {
            n = 1;
        } else if (n > 1) {
            if (COConfigurationManager.getBooleanParameter("peercontrol.scheduler.use.priorities")) {
                Debug.out("Multiple peer schedulers not supported for prioritised scheduling");
                n = 1;
            } else {
                System.out.println("Peer control scheduler parallelism=" + n);
            }
        }
        singletons = new PeerControlSchedulerImpl[n];
        for (n = 0; n < singletons.length; ++n) {
            PeerControlSchedulerImpl peerControlSchedulerImpl = COConfigurationManager.getBooleanParameter("peercontrol.scheduler.use.priorities") ? new PeerControlSchedulerPrioritised() : new PeerControlSchedulerBasic();
            PeerControlSchedulerImpl.singletons[n] = peerControlSchedulerImpl;
            peerControlSchedulerImpl.start();
        }
    }
}

