/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peer.cache;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.peer.cache.CacheDiscoverer;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemTime;

public class CacheDiscovery {
    private static final IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private static final CacheDiscoverer[] discoverers = new CacheDiscoverer[0];
    private static Set<String> cache_ips = Collections.synchronizedSet(new HashSet());

    public static void initialise(final DownloadManagerEnhancer downloadManagerEnhancer) {
        ip_filter.addListener(new IPFilterListener(){

            @Override
            public boolean canIPBeBanned(String string) {
                return CacheDiscovery.canBan(string);
            }

            @Override
            public void IPBanned(BannedIp bannedIp) {
            }

            @Override
            public void IPBlockedListChanged(IpFilter ipFilter) {
            }

            @Override
            public boolean canIPBeBlocked(String string, byte[] byArray) {
                EnhancedDownloadManager enhancedDownloadManager = downloadManagerEnhancer.getEnhancedDownload(byArray);
                if (enhancedDownloadManager == null) {
                    return true;
                }
                if (enhancedDownloadManager.isPlatform()) {
                    return CacheDiscovery.canBan(string);
                }
                return true;
            }
        });
        new AEThread2("CacheDiscovery:ban checker", true){

            @Override
            public void run() {
                BannedIp[] bannedIpArray = ip_filter.getBannedIps();
                for (int i = 0; i < bannedIpArray.length; ++i) {
                    String string = bannedIpArray[i].getIp();
                    if (CacheDiscovery.canBan(string)) continue;
                    ip_filter.unban(string);
                }
            }
        }.start();
    }

    private static boolean canBan(String string) {
        if (cache_ips.contains(string)) {
            return false;
        }
        try {
            InetAddress inetAddress = HostNameToIPResolver.syncResolve(string);
            final String string2 = inetAddress.getHostAddress();
            if (cache_ips.contains(string2)) {
                return false;
            }
            IPToHostNameResolver.addResolverRequest(string, new IPToHostNameResolverListener(){

                @Override
                public void IPResolutionComplete(String string, boolean bl) {
                    if (Constants.isAzureusDomain(string)) {
                        cache_ips.add(string2);
                        ip_filter.unban(string2, true);
                    }
                }
            });
            return true;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return true;
        }
    }

    public static CachePeer[] lookup(TOTorrent tOTorrent) {
        CachePeer[] cachePeerArray;
        if (discoverers.length == 0) {
            cachePeerArray = new CachePeer[]{};
        } else if (discoverers.length == 1) {
            cachePeerArray = discoverers[0].lookup(tOTorrent);
        } else {
            ArrayList<CachePeer> arrayList = new ArrayList<CachePeer>();
            for (int i = 0; i < discoverers.length; ++i) {
                CachePeer[] cachePeerArray2 = discoverers[i].lookup(tOTorrent);
                for (int j = 0; j < cachePeerArray2.length; ++j) {
                    arrayList.add(cachePeerArray2[i]);
                }
            }
            cachePeerArray = arrayList.toArray(new CachePeer[arrayList.size()]);
        }
        for (int i = 0; i < cachePeerArray.length; ++i) {
            String string = cachePeerArray[i].getAddress().getHostAddress();
            cache_ips.add(string);
            ip_filter.unban(string);
        }
        return cachePeerArray;
    }

    public static CachePeer categorisePeer(byte[] byArray, InetAddress inetAddress, int n) {
        for (int i = 0; i < discoverers.length; ++i) {
            CachePeer cachePeer = discoverers[i].lookup(byArray, inetAddress, n);
            if (cachePeer == null) continue;
            return cachePeer;
        }
        return new CachePeerImpl(1, inetAddress, n);
    }

    public static class CachePeerImpl
    implements CachePeer {
        private int type;
        private InetAddress address;
        private int port;
        private long create_time;
        private long inject_time;
        private long speed_change_time;
        private boolean auto_reconnect = true;

        public CachePeerImpl(int n, InetAddress inetAddress, int n2) {
            this.type = n;
            this.address = inetAddress;
            this.port = n2;
            this.create_time = SystemTime.getCurrentTime();
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public InetAddress getAddress() {
            return this.address;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public long getCreateTime(long l) {
            if (this.create_time > l) {
                this.create_time = l;
            }
            return this.create_time;
        }

        @Override
        public long getInjectTime(long l) {
            if (this.inject_time > l) {
                this.inject_time = l;
            }
            return this.inject_time;
        }

        @Override
        public void setInjectTime(long l) {
            this.inject_time = l;
        }

        @Override
        public long getSpeedChangeTime(long l) {
            if (this.speed_change_time > l) {
                this.speed_change_time = l;
            }
            return this.speed_change_time;
        }

        @Override
        public void setSpeedChangeTime(long l) {
            this.speed_change_time = l;
        }

        @Override
        public boolean getAutoReconnect() {
            return this.auto_reconnect;
        }

        @Override
        public void setAutoReconnect(boolean bl) {
            this.auto_reconnect = bl;
        }

        @Override
        public boolean sameAs(CachePeer cachePeer) {
            return this.getType() == cachePeer.getType() && this.getAddress().getHostAddress().equals(cachePeer.getAddress().getHostAddress()) && this.getPort() == cachePeer.getPort();
        }

        @Override
        public String getString() {
            return "type=" + this.getType() + ",address=" + this.getAddress() + ",port=" + this.getPort();
        }
    }
}

