/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPNetworkManager {
    private static int WRITE_SELECT_LOOP_TIME = 25;
    private static int WRITE_SELECT_MIN_LOOP_TIME = 0;
    private static int READ_SELECT_LOOP_TIME = 25;
    private static int READ_SELECT_MIN_LOOP_TIME = 0;
    protected static int tcp_mss_size;
    private static final TCPNetworkManager instance;
    public static boolean TCP_INCOMING_ENABLED;
    public static boolean TCP_OUTGOING_ENABLED;
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector("TCP network manager", 1, true);
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector("TCP network manager", 4, true);
    private final TCPConnectionManager connect_disconnect_manager = new TCPConnectionManager();
    private final IncomingSocketChannelManager incoming_socketchannel_manager = new IncomingSocketChannelManager("TCP.Listen.Port", "TCP.Listen.Port.Enable");
    private long read_select_count;
    private long write_select_count;

    public static TCPNetworkManager getSingleton() {
        return instance;
    }

    public static int getTcpMssSize() {
        return tcp_mss_size;
    }

    public static void refreshRates(int n) {
        tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
        if (tcp_mss_size > n) {
            tcp_mss_size = n - 1;
        }
        if (tcp_mss_size < 512) {
            tcp_mss_size = 512;
        }
    }

    protected TCPNetworkManager() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.tcp.select.read.count");
        hashSet.add("net.tcp.select.write.count");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            public void updateStats(Set set, Map map) {
                if (set.contains("net.tcp.select.read.count")) {
                    map.put("net.tcp.select.read.count", new Long(TCPNetworkManager.this.read_select_count));
                }
                if (set.contains("net.tcp.select.write.count")) {
                    map.put("net.tcp.select.write.count", new Long(TCPNetworkManager.this.write_select_count));
                }
            }
        });
        AEThread2 aEThread2 = new AEThread2("ReadController:ReadSelector", true){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (READ_SELECT_MIN_LOOP_TIME > 0) {
                                long l = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                                long l2 = SystemTime.getHighPrecisionCounter() - l;
                                long l3 = (long)READ_SELECT_MIN_LOOP_TIME - (l2 /= 1000000L);
                                if (l3 > 0L) {
                                    try {
                                        Thread.sleep(l3);
                                    }
                                    catch (Throwable throwable) {}
                                }
                            } else {
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                            }
                            TCPNetworkManager.this.read_select_count++;
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.out("readSelectorLoop() EXCEPTION: ", throwable);
                        continue;
                    }
                    break;
                }
            }
        };
        aEThread2.setPriority(8);
        aEThread2.start();
        AEThread2 aEThread22 = new AEThread2("WriteController:WriteSelector", true){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            if (WRITE_SELECT_MIN_LOOP_TIME > 0) {
                                long l = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                                long l2 = SystemTime.getHighPrecisionCounter() - l;
                                long l3 = (long)WRITE_SELECT_MIN_LOOP_TIME - (l2 /= 1000000L);
                                if (l3 <= 0L) continue;
                                try {
                                    Thread.sleep(l3);
                                    continue block4;
                                }
                                catch (Throwable throwable) {
                                    continue;
                                }
                            }
                            TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                            TCPNetworkManager.this.write_select_count++;
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.out("writeSelectorLoop() EXCEPTION: ", throwable);
                        continue;
                    }
                    break;
                }
            }
        };
        aEThread22.setPriority(8);
        aEThread22.start();
    }

    public void setExplicitBindAddress(InetAddress inetAddress) {
        this.incoming_socketchannel_manager.setExplicitBindAddress(inetAddress);
    }

    public void clearExplicitBindAddress() {
        this.incoming_socketchannel_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress inetAddress) {
        return this.incoming_socketchannel_manager.isEffectiveBindAddress(inetAddress);
    }

    public TCPConnectionManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }

    public VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }

    public boolean isTCPListenerEnabled() {
        return this.incoming_socketchannel_manager.isEnabled();
    }

    public int getTCPListeningPortNumber() {
        return this.incoming_socketchannel_manager.getTCPListeningPortNumber();
    }

    public long getLastIncomingNonLocalConnectionTime() {
        return this.incoming_socketchannel_manager.getLastNonLocalConnectionTime();
    }

    static {
        instance = new TCPNetworkManager();
        COConfigurationManager.addAndFireParameterListener("TCP.Listen.Port.Enable", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                TCP_INCOMING_ENABLED = TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter(string);
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.read.select.time", "network.tcp.read.select.min.time", "network.tcp.write.select.time", "network.tcp.write.select.min.time"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                WRITE_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.time");
                WRITE_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.min.time");
                READ_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.time");
                READ_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.min.time");
            }
        });
    }
}

