/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerDownloader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerDownloader(NetworkConnectionBase networkConnectionBase, RateHandler rateHandler) {
        this.connection = networkConnectionBase;
        this.rate_handler = rateHandler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    @Override
    public boolean canProcess(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) != 0L) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    @Override
    public int doProcessing(EventWaiter eventWaiter, int n) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) != 0L) {
            return 0;
        }
        int n2 = this.rate_handler.getCurrentNumBytesAllowed();
        if (n2 < 1) {
            return 0;
        }
        if (n > 0 && n < n2) {
            n2 = n;
        }
        int n3 = 0;
        try {
            n3 = this.connection.getIncomingMessageQueue().receiveFromTransport(n2);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof IOException)) {
                Debug.printStackTrace(throwable);
            }
            this.connection.notifyOfException(throwable);
            return 0;
        }
        if (n3 < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(n3);
        return n3;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount() {
        return 1;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForRead(eventWaiter) == 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() {
        return "SPD: " + this.connection.getString();
    }
}

