/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import java.net.InetAddress;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkAdminASNImpl
implements NetworkAdminASN {
    private String as;
    private String asn;
    private String bgp_prefix;

    protected NetworkAdminASNImpl(String string, String string2, String string3) {
        this.as = string;
        this.asn = string2;
        this.bgp_prefix = string3;
    }

    @Override
    public String getAS() {
        return this.as == null ? "" : this.as;
    }

    @Override
    public String getASName() {
        return this.asn == null ? "" : this.asn;
    }

    protected void setASName(String string) {
        this.asn = string;
    }

    @Override
    public String getBGPPrefix() {
        return this.bgp_prefix == null ? "" : this.bgp_prefix;
    }

    @Override
    public InetAddress getBGPStartAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDRStartAddress();
        }
        catch (NetworkAdminException networkAdminException) {
            Debug.out(networkAdminException);
            return null;
        }
    }

    protected InetAddress getCIDRStartAddress() throws NetworkAdminException {
        int n = this.bgp_prefix.indexOf(47);
        try {
            return InetAddress.getByName(this.bgp_prefix.substring(0, n));
        }
        catch (Throwable throwable) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", throwable);
        }
    }

    protected InetAddress getCIDREndAddress() throws NetworkAdminException {
        int n = this.bgp_prefix.indexOf(47);
        try {
            InetAddress inetAddress = InetAddress.getByName(this.bgp_prefix.substring(0, n));
            int n2 = Integer.parseInt(this.bgp_prefix.substring(n + 1));
            int n3 = 0;
            for (int i = 0; i < 32 - n2; ++i) {
                n3 = n3 << 1 | 1;
            }
            byte[] byArray = inetAddress.getAddress();
            byArray[0] = (byte)(byArray[0] | n3 >> 24 & 0xFF);
            byArray[1] = (byte)(byArray[1] | n3 >> 16 & 0xFF);
            byArray[2] = (byte)(byArray[2] | n3 >> 8 & 0xFF);
            byArray[3] = (byte)(byArray[3] | n3 & 0xFF);
            return InetAddress.getByAddress(byArray);
        }
        catch (Throwable throwable) {
            throw new NetworkAdminException("Parse failure for '" + this.bgp_prefix + "'", throwable);
        }
    }

    @Override
    public boolean matchesCIDR(InetAddress inetAddress) {
        if (this.bgp_prefix == null || this.bgp_prefix.length() == 0) {
            return false;
        }
        try {
            InetAddress inetAddress2 = this.getCIDRStartAddress();
            InetAddress inetAddress3 = this.getCIDREndAddress();
            long l = PRHelpers.addressToLong(inetAddress2);
            long l2 = PRHelpers.addressToLong(inetAddress3);
            long l3 = PRHelpers.addressToLong(inetAddress);
            return l3 >= l && l3 <= l2;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return false;
        }
    }

    @Override
    public InetAddress getBGPEndAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return this.getCIDREndAddress();
        }
        catch (NetworkAdminException networkAdminException) {
            Debug.out(networkAdminException);
            return null;
        }
    }

    @Override
    public boolean sameAs(NetworkAdminASN networkAdminASN) {
        return this.getAS().equals(networkAdminASN.getAS());
    }

    @Override
    public String getString() {
        return "as=" + this.getAS() + ",asn=" + this.getASName() + ", bgp_prefx=" + this.getBGPPrefix() + "[" + this.getBGPStartAddress() + "-" + this.getBGPEndAddress() + "]";
    }
}

