/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.lws.LWSDiskManagerState;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;

public class LWSDiskManager
implements DiskManagerHelper {
    private static sePiece piece = new sePiece();
    private LightWeightSeed lws;
    private DiskAccessController disk_access_controller;
    private File save_file;
    private DMReader reader;
    private DMChecker checker_use_accessor;
    private DMPieceMapper piece_mapper;
    private DMPieceMap piece_map_use_accessor;
    private sePiece[] pieces;
    private DiskManagerFileInfoImpl[] files;
    private String internal_name;
    private DownloadManagerState download_state;
    private boolean started;
    private int state = 1;
    private String error_message = "";

    protected LWSDiskManager(LightWeightSeed lightWeightSeed, File file) {
        this.lws = lightWeightSeed;
        this.save_file = file;
        this.disk_access_controller = DiskManagerImpl.getDefaultDiskAccessController();
        this.download_state = new LWSDiskManagerState();
        TOTorrent tOTorrent = this.lws.getTOTorrent(false);
        this.pieces = new sePiece[tOTorrent.getNumberOfPieces()];
        for (int i = 0; i < this.pieces.length; ++i) {
            this.pieces[i] = piece;
        }
    }

    public String getName() {
        return this.lws.getName();
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    @Override
    public void start() {
        try {
            TOTorrent tOTorrent = this.lws.getTOTorrent(false);
            this.internal_name = ByteFormatter.nicePrint(tOTorrent.getHash(), true);
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
            this.piece_mapper = DMPieceMapperFactory.create(tOTorrent);
            this.piece_mapper.construct(localeUtilDecoder, this.save_file.getName());
            this.files = this.getFileInfo(this.piece_mapper.getFiles(), this.save_file);
            this.reader = DMAccessFactory.createReader(this);
            this.reader.start();
            if (this.state != 10) {
                this.started = true;
                this.state = 4;
            }
        }
        catch (Throwable throwable) {
            this.setFailed("start failed - " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerFileInfoImpl[] getFileInfo(DMPieceMapperFile[] dMPieceMapperFileArray, File file) {
        boolean bl = false;
        DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray = new DiskManagerFileInfoImpl[dMPieceMapperFileArray.length];
        try {
            TOTorrent tOTorrent = this.lws.getTOTorrent(false);
            if (tOTorrent.isSimpleTorrent()) {
                file = file.getParentFile();
            }
            for (int i = 0; i < dMPieceMapperFileArray.length; ++i) {
                DiskManagerFileInfoImpl diskManagerFileInfoImpl;
                DMPieceMapperFile dMPieceMapperFile = dMPieceMapperFileArray[i];
                File file2 = dMPieceMapperFile.getDataFile();
                long l = dMPieceMapperFile.getLength();
                diskManagerFileInfoImplArray[i] = diskManagerFileInfoImpl = new DiskManagerFileInfoImpl(this, new File(file, file2.toString()), i, dMPieceMapperFile.getTorrentFile(), 1);
                CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                File file3 = diskManagerFileInfoImpl.getFile(true);
                if (!cacheFile.exists()) {
                    throw new Exception("File '" + file3 + "' doesn't exist");
                }
                if (cacheFile.getLength() != l) {
                    throw new Exception("File '" + file3 + "' doesn't exist");
                }
                dMPieceMapperFile.setFileInfo(diskManagerFileInfoImpl);
            }
            bl = true;
            DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray2 = diskManagerFileInfoImplArray;
            return diskManagerFileInfoImplArray2;
        }
        catch (Throwable throwable) {
            this.setFailed("getFiles failed - " + Debug.getNestedExceptionMessage(throwable));
            DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray3 = null;
            return diskManagerFileInfoImplArray3;
        }
        finally {
            if (!bl) {
                for (int i = 0; i < diskManagerFileInfoImplArray.length; ++i) {
                    if (diskManagerFileInfoImplArray[i] == null) continue;
                    diskManagerFileInfoImplArray[i].close();
                }
            }
        }
    }

    @Override
    public void setPieceDone(DiskManagerPieceImpl diskManagerPieceImpl, boolean bl) {
    }

    @Override
    public boolean stop(boolean bl) {
        this.started = false;
        if (this.reader != null) {
            this.reader.stop();
            this.reader = null;
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public boolean filesExist() {
        throw new RuntimeException("filesExist not implemented");
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int n, int n2, DirectByteBuffer directByteBuffer, Object object) {
        throw new RuntimeException("createWriteRequest not implemented");
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest diskManagerWriteRequest, DiskManagerWriteRequestListener diskManagerWriteRequestListener) {
        throw new RuntimeException("enqueueWriteRequest not implemented");
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingWriteRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingReadRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int n) {
        throw new RuntimeException("hasOutstandingCheckRequestForPiece not implemented");
    }

    @Override
    public DirectByteBuffer readBlock(int n, int n2, int n3) {
        return this.reader.readBlock(n, n2, n3);
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int n, int n2, int n3) {
        return this.reader.createReadRequest(n, n2, n3);
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        this.reader.readBlock(diskManagerReadRequest, diskManagerReadRequestListener);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int n, Object object) {
        DMChecker dMChecker = this.getChecker();
        return dMChecker.createCheckRequest(n, object);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        DMChecker dMChecker = this.getChecker();
        dMChecker.enqueueCheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        throw new RuntimeException("enqueueCompleteRecheckRequest not implemented");
    }

    @Override
    public void setPieceCheckingEnabled(boolean bl) {
    }

    @Override
    public void saveResumeData(boolean bl) {
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public DiskManagerPiece getPiece(int n) {
        return this.pieces[n];
    }

    @Override
    public boolean isInteresting(int n) {
        return false;
    }

    @Override
    public boolean isDone(int n) {
        return false;
    }

    @Override
    public int getNbPieces() {
        return this.pieces.length;
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        throw new RuntimeException("getFileSet not implemented");
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public long getTotalLength() {
        return this.piece_mapper.getTotalLength();
    }

    @Override
    public int getPieceLength() {
        return this.piece_mapper.getPieceLength();
    }

    @Override
    public int getPieceLength(int n) {
        if (n == this.pieces.length - 1) {
            return this.piece_mapper.getLastPieceLength();
        }
        return this.piece_mapper.getPieceLength();
    }

    public int getLastPieceLength() {
        return this.piece_mapper.getLastPieceLength();
    }

    @Override
    public long getRemaining() {
        return 0L;
    }

    @Override
    public long getRemainingExcludingDND() {
        return 0L;
    }

    @Override
    public int getPercentDone() {
        return 100;
    }

    @Override
    public String getErrorMessage() {
        return this.error_message;
    }

    @Override
    public void downloadEnded() {
    }

    public void moveDataFiles(File file) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    @Override
    public void moveDataFiles(File file, String string) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    @Override
    public int getCompleteRecheckStatus() {
        return -1;
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String string, int n, int n2, DirectByteBuffer directByteBuffer) {
        long l = n * this.piece_mapper.getPieceLength() + n2 + directByteBuffer.remaining((byte)1);
        return l <= this.piece_mapper.getTotalLength();
    }

    @Override
    public boolean checkBlockConsistencyForRead(String string, boolean bl, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, string, bl, n, n2, n3);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String string, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, string, n, n2, n3);
    }

    @Override
    public void addListener(DiskManagerListener diskManagerListener) {
    }

    @Override
    public void removeListener(DiskManagerListener diskManagerListener) {
    }

    @Override
    public boolean hasListener(DiskManagerListener diskManagerListener) {
        return false;
    }

    @Override
    public void saveState() {
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return this.disk_access_controller;
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap dMPieceMap = this.piece_map_use_accessor;
        if (dMPieceMap == null) {
            this.piece_map_use_accessor = dMPieceMap = this.piece_mapper.getPieceMap();
        }
        return dMPieceMap;
    }

    @Override
    public DMPieceList getPieceList(int n) {
        DMPieceMap dMPieceMap = this.getPieceMap();
        return dMPieceMap.getPieceList(n);
    }

    protected DMChecker getChecker() {
        DMChecker dMChecker = this.checker_use_accessor;
        if (dMChecker == null) {
            dMChecker = this.checker_use_accessor = DMAccessFactory.createChecker(this);
        }
        return dMChecker;
    }

    @Override
    public byte[] getPieceHash(int n) throws TOTorrentException {
        return this.lws.getTorrent().getPieces()[n];
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        throw new RuntimeException("getPieceHash not implemented");
    }

    @Override
    public void downloadRemoved() {
    }

    @Override
    public void setFailed(String string) {
        this.started = false;
        this.state = 10;
        this.error_message = string;
    }

    @Override
    public void setFailed(DiskManagerFileInfo diskManagerFileInfo, String string) {
        this.started = false;
        this.state = 10;
        this.error_message = string;
    }

    @Override
    public long getAllocated() {
        return 0L;
    }

    @Override
    public void setAllocated(long l) {
    }

    @Override
    public void setPercentDone(int n) {
    }

    @Override
    public TOTorrent getTorrent() {
        return this.lws.getTOTorrent(false);
    }

    @Override
    public String[] getStorageTypes() {
        throw new RuntimeException("getStorageTypes not implemented");
    }

    @Override
    public String getStorageType(int n) {
        throw new RuntimeException("getStorageType not implemented");
    }

    @Override
    public void accessModeChanged(DiskManagerFileInfoImpl diskManagerFileInfoImpl, int n, int n2) {
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo diskManagerFileInfo) {
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
    }

    @Override
    public File getSaveLocation() {
        return this.save_file;
    }

    @Override
    public String getInternalName() {
        return this.internal_name;
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_state;
    }

    @Override
    public void generateEvidence(IndentWriter indentWriter) {
    }

    protected static class sePiece
    implements DiskManagerPiece {
        protected sePiece() {
        }

        public void clearChecking() {
            throw new RuntimeException("clearChecking not implemented");
        }

        @Override
        public boolean isNeedsCheck() {
            throw new RuntimeException("isNeedsCheck not implemented");
        }

        @Override
        public int getLength() {
            throw new RuntimeException("getLength not implemented");
        }

        @Override
        public int getNbBlocks() {
            throw new RuntimeException("getNbBlocks not implemented");
        }

        @Override
        public int getPieceNumber() {
            throw new RuntimeException("getPieceNumber not implemented");
        }

        @Override
        public int getBlockSize(int n) {
            throw new RuntimeException("getBlockSize not implemented");
        }

        @Override
        public boolean isWritten() {
            throw new RuntimeException("isWritten not implemented");
        }

        @Override
        public int getNbWritten() {
            throw new RuntimeException("getNbWritten not implemented");
        }

        @Override
        public boolean[] getWritten() {
            throw new RuntimeException("getWritten not implemented");
        }

        @Override
        public void reDownloadBlock(int n) {
            throw new RuntimeException("reDownloadBlock not implemented");
        }

        @Override
        public void reset() {
            throw new RuntimeException("reset not implemented");
        }

        @Override
        public boolean isDownloadable() {
            return false;
        }

        @Override
        public void setDownloadable() {
            throw new RuntimeException("setRequestable not implemented");
        }

        @Override
        public DiskManager getManager() {
            throw new RuntimeException("getManager not implemented");
        }

        @Override
        public boolean calcNeeded() {
            throw new RuntimeException("calcNeeded not implemented");
        }

        @Override
        public void clearNeeded() {
            throw new RuntimeException("clearNeeded not implemented");
        }

        @Override
        public boolean isNeeded() {
            throw new RuntimeException("isNeeded not implemented");
        }

        @Override
        public void setNeeded() {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setNeeded(boolean bl) {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setWritten(int n) {
            throw new RuntimeException("setWritten not implemented");
        }

        @Override
        public boolean isWritten(int n) {
            throw new RuntimeException("isWritten not implemented");
        }

        public boolean calcChecking() {
            throw new RuntimeException("calcChecking not implemented");
        }

        @Override
        public boolean isChecking() {
            return false;
        }

        @Override
        public void setChecking() {
            throw new RuntimeException("setChecking not implemented");
        }

        public void setChecking(boolean bl) {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public boolean calcDone() {
            throw new RuntimeException("calcDone not implemented");
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isInteresting() {
            return false;
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public String getString() {
            return "";
        }

        @Override
        public short getReadCount() {
            return 0;
        }

        @Override
        public void setReadCount(short s) {
        }

        @Override
        public void setDone(boolean bl) {
            if (!bl) {
                Debug.out("Piece failed recheck");
            }
        }
    }
}

