/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerAdapter;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.instancemanager.impl.AZMyInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZOtherInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZPortClashHandler;
import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupException;
import com.aelitis.net.udp.mc.MCGroupFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AZInstanceManagerImpl
implements AZInstanceManager,
MCGroupAdapter {
    private static final boolean DISABLE_LAN_LOCAL_STUFF = false;
    private static final LogIDs LOGID = LogIDs.NET;
    private String MC_GROUP_ADDRESS = "239.255.067.250";
    private int MC_GROUP_PORT = 16680;
    private int MC_CONTROL_PORT = 0;
    private static final int MT_VERSION = 1;
    private static final int MT_ALIVE = 1;
    private static final int MT_BYE = 2;
    private static final int MT_REQUEST = 3;
    private static final int MT_REPLY = 4;
    private static final int MT_REQUEST_SEARCH = 1;
    private static final int MT_REQUEST_TRACK = 2;
    private static final long ALIVE_PERIOD = 1800000L;
    private static AZInstanceManagerImpl singleton;
    private List listeners = new ArrayList();
    private static AEMonitor class_mon;
    private static String socks_proxy;
    private AZInstanceManagerAdapter adapter;
    private MCGroup mc_group;
    private long search_id_next;
    private List requests = new ArrayList();
    private AZMyInstanceImpl my_instance;
    private Map other_instances = new HashMap();
    private volatile boolean initialised;
    private volatile Map tcp_lan_to_ext = new HashMap();
    private volatile Map udp_lan_to_ext = new HashMap();
    private volatile Map udp2_lan_to_ext = new HashMap();
    private volatile Map tcp_ext_to_lan = new HashMap();
    private volatile Map udp_ext_to_lan = new HashMap();
    private volatile Map udp2_ext_to_lan = new HashMap();
    private volatile Set lan_addresses = new HashSet();
    private volatile Set ext_addresses = new HashSet();
    private volatile List lan_subnets = new ArrayList();
    private volatile List explicit_peers = new ArrayList();
    private volatile boolean include_well_known_lans = true;
    private AESemaphore initial_search_sem = new AESemaphore("AZInstanceManager:initialSearch");
    private boolean init_wait_abandoned;
    private AEMonitor this_mon = new AEMonitor("AZInstanceManager");
    private boolean closing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AZInstanceManager getSingleton(AZInstanceManagerAdapter aZInstanceManagerAdapter) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new AZInstanceManagerImpl(aZInstanceManagerAdapter);
            }
        }
        finally {
            class_mon.exit();
        }
        return singleton;
    }

    protected AZInstanceManagerImpl(AZInstanceManagerAdapter aZInstanceManagerAdapter) {
        this.adapter = aZInstanceManagerAdapter;
        this.my_instance = new AZMyInstanceImpl(this.adapter, this);
        new AZPortClashHandler(this);
    }

    @Override
    public void initialize() {
        try {
            this.initialised = true;
            boolean bl = System.getProperty("az.instance.manager.enable", "1").equals("1");
            this.mc_group = bl ? MCGroupFactory.getSingleton(this, this.MC_GROUP_ADDRESS, this.MC_GROUP_PORT, this.MC_CONTROL_PORT, null) : this.getDummyMCGroup();
            this.adapter.addListener(new AZInstanceManagerAdapter.StateListener(){

                @Override
                public void started() {
                }

                @Override
                public void stopped() {
                    AZInstanceManagerImpl.this.closing = true;
                    AZInstanceManagerImpl.this.sendByeBye();
                }
            });
            SimpleTimer.addPeriodicEvent("InstManager:timeouts", 1800000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent timerEvent2) {
                    AZInstanceManagerImpl.this.checkTimeouts();
                    AZInstanceManagerImpl.this.sendAlive();
                }
            });
        }
        catch (Throwable throwable) {
            if (this.mc_group == null) {
                this.mc_group = this.getDummyMCGroup();
            }
            this.initial_search_sem.releaseForever();
            Debug.printStackTrace(throwable);
        }
        new AEThread2("AZInstanceManager:initialSearch", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AZInstanceManagerImpl.this.search();
                    AZInstanceManagerImpl.this.addAddresses(AZInstanceManagerImpl.this.my_instance);
                }
                finally {
                    AZInstanceManagerImpl.this.initial_search_sem.releaseForever();
                }
            }
        }.start();
    }

    private MCGroup getDummyMCGroup() {
        return new MCGroup(){

            @Override
            public int getControlPort() {
                return AZInstanceManagerImpl.this.MC_CONTROL_PORT;
            }

            @Override
            public void sendToGroup(byte[] byArray) {
            }

            @Override
            public void sendToGroup(String string) {
            }

            @Override
            public void sendToMember(InetSocketAddress inetSocketAddress, byte[] byArray) throws MCGroupException {
            }
        };
    }

    @Override
    public long getClockSkew() {
        try {
            DHTPlugin dHTPlugin = this.adapter.getDHTPlugin();
            if (dHTPlugin != null) {
                return dHTPlugin.getClockSkew();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return 0L;
    }

    @Override
    public void trace(String string) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, string));
        }
    }

    @Override
    public void log(Throwable throwable) {
        Debug.printStackTrace(throwable);
    }

    @Override
    public boolean isInitialized() {
        return this.initial_search_sem.isReleasedForever();
    }

    @Override
    public void updateNow() {
        this.sendAlive();
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void sendAlive() {
        this.sendMessage(1);
    }

    protected void sendAlive(InetSocketAddress inetSocketAddress) {
        this.sendMessage(1, inetSocketAddress);
    }

    protected void sendByeBye() {
        this.sendMessage(2);
    }

    protected void sendByeBye(InetSocketAddress inetSocketAddress) {
        this.sendMessage(2, inetSocketAddress);
    }

    protected void sendMessage(int n) {
        this.sendMessage(n, (Map)null);
    }

    protected void sendMessage(int n, InetSocketAddress inetSocketAddress) {
        this.sendMessage(n, null, inetSocketAddress);
    }

    protected void sendMessage(int n, Map map) {
        this.sendMessage(n, map, null);
    }

    protected void sendMessage(int n, Map map, InetSocketAddress inetSocketAddress) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ver", new Long(1L));
        hashMap.put("type", new Long(n));
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("orig", hashMap2);
        this.my_instance.encode(hashMap2);
        if (map != null) {
            hashMap.put("body", map);
        }
        try {
            if (inetSocketAddress == null) {
                byte[] byArray = BEncoder.encode(hashMap);
                this.mc_group.sendToGroup(byArray);
                if (this.explicit_peers.size() > 0) {
                    hashMap.put("explicit", new Long(1L));
                    byte[] byArray2 = BEncoder.encode(hashMap);
                    Iterator iterator = this.explicit_peers.iterator();
                    while (iterator.hasNext()) {
                        this.mc_group.sendToMember((InetSocketAddress)iterator.next(), byArray2);
                    }
                }
            } else {
                if (this.explicit_peers.contains(inetSocketAddress)) {
                    hashMap.put("explicit", new Long(1L));
                }
                byte[] byArray = BEncoder.encode(hashMap);
                this.mc_group.sendToMember(inetSocketAddress, byArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(NetworkInterface networkInterface2, InetAddress inetAddress, InetSocketAddress inetSocketAddress, byte[] byArray, int n) {
        block11: {
            try {
                String string;
                AZOtherInstanceImpl aZOtherInstanceImpl;
                Map map = BDecoder.decode(byArray, 0, n);
                long l = (Long)map.get("ver");
                long l2 = (Long)map.get("type");
                InetAddress inetAddress2 = inetSocketAddress.getAddress();
                if (map.get("explicit") != null) {
                    this.addInstanceSupport(inetAddress2, false);
                }
                if ((aZOtherInstanceImpl = AZOtherInstanceImpl.decode(inetAddress2, (Map)map.get("orig"))) == null) break block11;
                if (l2 == 1L) {
                    this.checkAdd(aZOtherInstanceImpl);
                    break block11;
                }
                if (l2 == 2L) {
                    this.checkRemove(aZOtherInstanceImpl);
                    break block11;
                }
                this.checkAdd(aZOtherInstanceImpl);
                Map map2 = (Map)map.get("body");
                if (l2 == 3L) {
                    Map map3;
                    String string2 = aZOtherInstanceImpl.getID();
                    if (!string2.equals(this.my_instance.getID()) && (map3 = this.requestReceived(aZOtherInstanceImpl, map2)) != null) {
                        map3.put("oid", string2.getBytes());
                        map3.put("rid", map2.get("rid"));
                        this.sendMessage(4, map3, inetSocketAddress);
                    }
                    break block11;
                }
                if (l2 != 4L || !(string = new String((byte[])map2.get("oid"))).equals(this.my_instance.getID())) break block11;
                long l3 = (Long)map2.get("rid");
                try {
                    this.this_mon.enter();
                    for (int i = 0; i < this.requests.size(); ++i) {
                        request request2 = (request)this.requests.get(i);
                        if (request2.getID() != l3) continue;
                        request2.addReply(aZOtherInstanceImpl, map2);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable throwable) {
                Debug.out("Invalid packet received from " + inetSocketAddress, throwable);
            }
        }
    }

    protected Map requestReceived(AZInstance aZInstance, Map map) {
        long l = (Long)map.get("type");
        if (l == 1L) {
            return new HashMap();
        }
        if (l == 2L) {
            byte[] byArray = (byte[])map.get("hash");
            boolean bl = ((Long)map.get("seed")).intValue() == 1;
            AZInstanceTracked.TrackTarget trackTarget = this.adapter.track(byArray);
            if (trackTarget != null) {
                try {
                    this.informTracked(new trackedInstance(aZInstance, trackTarget, bl));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("seed", new Long(trackTarget.isSeed() ? 1L : 0L));
                return hashMap;
            }
            return null;
        }
        return null;
    }

    @Override
    public void interfaceChanged(NetworkInterface networkInterface2) {
        this.sendAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AZOtherInstanceImpl checkAdd(AZOtherInstanceImpl aZOtherInstanceImpl) {
        if (aZOtherInstanceImpl.getID().equals(this.my_instance.getID())) {
            return aZOtherInstanceImpl;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.this_mon.enter();
            AZOtherInstanceImpl aZOtherInstanceImpl2 = (AZOtherInstanceImpl)this.other_instances.get(aZOtherInstanceImpl.getID());
            if (aZOtherInstanceImpl2 == null) {
                bl = true;
                this.other_instances.put(aZOtherInstanceImpl.getID(), aZOtherInstanceImpl);
            } else {
                bl2 = aZOtherInstanceImpl2.update(aZOtherInstanceImpl);
                aZOtherInstanceImpl = aZOtherInstanceImpl2;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (bl) {
            this.informAdded(aZOtherInstanceImpl);
        } else if (bl2) {
            this.informChanged(aZOtherInstanceImpl);
        }
        return aZOtherInstanceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRemove(AZOtherInstanceImpl aZOtherInstanceImpl) {
        if (aZOtherInstanceImpl.getID().equals(this.my_instance.getID())) {
            return;
        }
        boolean bl = false;
        try {
            this.this_mon.enter();
            bl = this.other_instances.remove(aZOtherInstanceImpl.getID()) != null;
        }
        finally {
            this.this_mon.exit();
        }
        if (bl) {
            this.informRemoved(aZOtherInstanceImpl);
        }
    }

    @Override
    public AZInstance getMyInstance() {
        return this.my_instance;
    }

    protected void search() {
        this.sendRequest(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOtherInstanceCount() {
        this.waitForInit();
        try {
            this.this_mon.enter();
            int n = this.other_instances.size();
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AZInstance[] getOtherInstances() {
        this.waitForInit();
        try {
            this.this_mon.enter();
            AZInstance[] aZInstanceArray = this.other_instances.values().toArray(new AZInstance[this.other_instances.size()]);
            return aZInstanceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void waitForInit() {
        if (this.init_wait_abandoned) {
            return;
        }
        if (!this.initial_search_sem.reserve(2500L)) {
            Debug.out("Instance manager - timeout waiting for initial search");
            this.init_wait_abandoned = true;
        }
    }

    protected void addAddresses(AZInstance aZInstance) {
        InetAddress inetAddress = aZInstance.getInternalAddress();
        InetAddress inetAddress2 = aZInstance.getExternalAddress();
        int n = aZInstance.getTCPListenPort();
        int n2 = aZInstance.getUDPListenPort();
        int n3 = aZInstance.getUDPNonDataListenPort();
        this.modifyAddresses(inetAddress, inetAddress2, n, n2, n3, true);
    }

    protected void removeAddresses(AZOtherInstanceImpl aZOtherInstanceImpl) {
        List list = aZOtherInstanceImpl.getInternalAddresses();
        InetAddress inetAddress = aZOtherInstanceImpl.getExternalAddress();
        int n = aZOtherInstanceImpl.getTCPListenPort();
        int n2 = aZOtherInstanceImpl.getUDPListenPort();
        int n3 = aZOtherInstanceImpl.getUDPNonDataListenPort();
        for (int i = 0; i < list.size(); ++i) {
            this.modifyAddresses((InetAddress)list.get(i), inetAddress, n, n2, n3, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyAddresses(InetAddress inetAddress, InetAddress inetAddress2, int n, int n2, int n3, boolean bl) {
        if (inetAddress.isAnyLocalAddress()) {
            try {
                inetAddress = NetUtils.getLocalHost();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        try {
            HashSet<InetAddress> hashSet;
            this.this_mon.enter();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(inetAddress2, n);
            InetSocketAddress inetSocketAddress3 = new InetSocketAddress(inetAddress, n2);
            InetSocketAddress inetSocketAddress4 = new InetSocketAddress(inetAddress2, n2);
            InetSocketAddress inetSocketAddress5 = new InetSocketAddress(inetAddress, n3);
            InetSocketAddress inetSocketAddress6 = new InetSocketAddress(inetAddress2, n3);
            this.tcp_ext_to_lan = this.modifyAddress(this.tcp_ext_to_lan, inetSocketAddress2, inetSocketAddress, bl);
            this.tcp_lan_to_ext = this.modifyAddress(this.tcp_lan_to_ext, inetSocketAddress, inetSocketAddress2, bl);
            this.udp_ext_to_lan = this.modifyAddress(this.udp_ext_to_lan, inetSocketAddress4, inetSocketAddress3, bl);
            this.udp_lan_to_ext = this.modifyAddress(this.udp_lan_to_ext, inetSocketAddress3, inetSocketAddress4, bl);
            this.udp2_ext_to_lan = this.modifyAddress(this.udp2_ext_to_lan, inetSocketAddress6, inetSocketAddress5, bl);
            this.udp2_lan_to_ext = this.modifyAddress(this.udp2_lan_to_ext, inetSocketAddress5, inetSocketAddress6, bl);
            if (!this.lan_addresses.contains(inetAddress)) {
                hashSet = new HashSet<InetAddress>(this.lan_addresses);
                hashSet.add(inetAddress);
                this.lan_addresses = hashSet;
            }
            if (!this.ext_addresses.contains(inetAddress2)) {
                hashSet = new HashSet(this.ext_addresses);
                hashSet.add(inetAddress2);
                this.ext_addresses = hashSet;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected Map modifyAddress(Map hashMap, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl) {
        InetSocketAddress inetSocketAddress3 = (InetSocketAddress)hashMap.get(inetSocketAddress);
        boolean bl2 = inetSocketAddress3 != null && inetSocketAddress3.equals(inetSocketAddress2);
        HashMap<InetSocketAddress, InetSocketAddress> hashMap2 = hashMap;
        if (bl) {
            if (!bl2) {
                hashMap2 = new HashMap<InetSocketAddress, InetSocketAddress>(hashMap);
                hashMap2.put(inetSocketAddress, inetSocketAddress2);
            }
        } else if (bl2) {
            hashMap2 = new HashMap(hashMap);
            hashMap2.remove(inetSocketAddress);
        }
        return hashMap2;
    }

    @Override
    public InetSocketAddress getLANAddress(InetSocketAddress inetSocketAddress, int n) {
        Map map = n == 1 ? this.tcp_ext_to_lan : (n == 2 ? this.udp_ext_to_lan : this.udp2_ext_to_lan);
        if (map.size() == 0) {
            return null;
        }
        return (InetSocketAddress)map.get(inetSocketAddress);
    }

    @Override
    public InetSocketAddress getExternalAddress(InetSocketAddress inetSocketAddress, int n) {
        Map map = n == 1 ? this.tcp_lan_to_ext : (n == 2 ? this.udp_lan_to_ext : this.udp2_lan_to_ext);
        if (map.size() == 0) {
            return null;
        }
        return (InetSocketAddress)map.get(inetSocketAddress);
    }

    @Override
    public boolean isLANAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        String string = socks_proxy;
        if (string != null && string.equals(inetAddress.getHostAddress())) {
            return false;
        }
        if (this.include_well_known_lans && (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress())) {
            return true;
        }
        String string2 = inetAddress.getHostAddress();
        for (int i = 0; i < this.lan_subnets.size(); ++i) {
            Pattern pattern = (Pattern)this.lan_subnets.get(i);
            if (!pattern.matcher(string2).matches()) continue;
            return true;
        }
        if (this.lan_addresses.contains(inetAddress)) {
            return true;
        }
        if (this.explicit_peers.size() > 0) {
            Iterator iterator = this.explicit_peers.iterator();
            while (iterator.hasNext()) {
                if (!((InetSocketAddress)iterator.next()).getAddress().equals(inetAddress)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLANSubnet(String string) throws PatternSyntaxException {
        int n;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            string2 = n == 42 ? string2 + ".*?" : (n == 46 ? string2 + "\\." : string2 + (char)n);
        }
        Pattern pattern = Pattern.compile(string2);
        for (n = 0; n < this.lan_subnets.size(); ++n) {
            if (!pattern.pattern().equals(((Pattern)this.lan_subnets.get(n)).pattern())) continue;
            return false;
        }
        try {
            this.this_mon.enter();
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>(this.lan_subnets);
            arrayList.add(pattern);
            this.lan_subnets = arrayList;
        }
        finally {
            this.this_mon.exit();
        }
        return true;
    }

    @Override
    public void setIncludeWellKnownLANs(boolean bl) {
        this.include_well_known_lans = bl;
    }

    @Override
    public boolean getIncludeWellKnownLANs() {
        return this.include_well_known_lans;
    }

    @Override
    public boolean addInstance(InetAddress inetAddress) {
        return this.addInstanceSupport(inetAddress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addInstanceSupport(InetAddress inetAddress, boolean bl) {
        final InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.MC_GROUP_PORT);
        boolean bl2 = false;
        if (!this.explicit_peers.contains(inetSocketAddress)) {
            try {
                this.this_mon.enter();
                ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(this.explicit_peers);
                arrayList.add(inetSocketAddress);
                this.explicit_peers = arrayList;
            }
            finally {
                this.this_mon.exit();
            }
            bl2 = true;
        }
        if ((bl || bl2) && this.initialised) {
            new DelayedEvent("AZInstanceManagerImpl:delaySendAlive", 0L, new AERunnable(){

                @Override
                public void runSupport() {
                    AZInstanceManagerImpl.this.sendAlive(inetSocketAddress);
                }
            });
        }
        return bl2;
    }

    @Override
    public boolean isExternalAddress(InetAddress inetAddress) {
        return this.ext_addresses.contains(inetAddress);
    }

    @Override
    public AZInstanceTracked[] track(byte[] byArray, AZInstanceTracked.TrackTarget trackTarget) {
        if (this.mc_group == null || this.getOtherInstances().length == 0) {
            return new AZInstanceTracked[0];
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hash", byArray);
        hashMap.put("seed", new Long(trackTarget.isSeed() ? 1L : 0L));
        Map map = this.sendRequest(2, hashMap);
        AZInstanceTracked[] aZInstanceTrackedArray = new AZInstanceTracked[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AZInstance aZInstance = (AZInstance)entry.getKey();
            Map map2 = (Map)entry.getValue();
            boolean bl = ((Long)map2.get("seed")).intValue() == 1;
            aZInstanceTrackedArray[n++] = new trackedInstance(aZInstance, trackTarget, bl);
        }
        return aZInstanceTrackedArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        AZOtherInstanceImpl aZOtherInstanceImpl;
        long l = SystemTime.getCurrentTime();
        ArrayList<AZOtherInstanceImpl> arrayList = new ArrayList<AZOtherInstanceImpl>();
        try {
            this.this_mon.enter();
            Iterator iterator = this.other_instances.values().iterator();
            while (iterator.hasNext()) {
                aZOtherInstanceImpl = (AZOtherInstanceImpl)iterator.next();
                if (!((double)(l - aZOtherInstanceImpl.getAliveTime()) > 4500000.0)) continue;
                arrayList.add(aZOtherInstanceImpl);
                iterator.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            aZOtherInstanceImpl = (AZOtherInstanceImpl)arrayList.get(i);
            this.informRemoved(aZOtherInstanceImpl);
        }
    }

    protected void informRemoved(AZOtherInstanceImpl aZOtherInstanceImpl) {
        this.removeAddresses(aZOtherInstanceImpl);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceLost(aZOtherInstanceImpl);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void informAdded(AZInstance aZInstance) {
        this.addAddresses(aZInstance);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceFound(aZInstance);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void informChanged(AZInstance aZInstance) {
        this.addAddresses(aZInstance);
        if (aZInstance == this.my_instance) {
            this.sendAlive();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceChanged(aZInstance);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void informTracked(AZInstanceTracked aZInstanceTracked) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceTracked(aZInstanceTracked);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected Map sendRequest(int n) {
        return new request(n, new HashMap()).getReplies();
    }

    protected Map sendRequest(int n, Map map) {
        return new request(n, map).getReplies();
    }

    @Override
    public void addListener(AZInstanceManagerListener aZInstanceManagerListener) {
        this.listeners.add(aZInstanceManagerListener);
    }

    @Override
    public void removeListener(AZInstanceManagerListener aZInstanceManagerListener) {
        this.listeners.remove(aZInstanceManagerListener);
    }

    static {
        class_mon = new AEMonitor("AZInstanceManager:class");
        socks_proxy = null;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Data.Enable", "Proxy.Host", "Proxy.Data.Same", "Proxy.Data.Host"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                if (!COConfigurationManager.getBooleanParameter("Proxy.Data.Enable")) {
                    socks_proxy = null;
                    return;
                }
                if (COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
                    socks_proxy = COConfigurationManager.getStringParameter("Proxy.Host");
                } else {
                    socks_proxy = COConfigurationManager.getStringParameter("Proxy.Data.Host");
                }
                if (socks_proxy != null) {
                    socks_proxy = socks_proxy.trim();
                }
            }
        });
    }

    protected static class trackedInstance
    implements AZInstanceTracked {
        private AZInstance instance;
        private AZInstanceTracked.TrackTarget target;
        private boolean seed;

        protected trackedInstance(AZInstance aZInstance, AZInstanceTracked.TrackTarget trackTarget, boolean bl) {
            this.instance = aZInstance;
            this.target = trackTarget;
            this.seed = bl;
        }

        @Override
        public AZInstance getInstance() {
            return this.instance;
        }

        @Override
        public AZInstanceTracked.TrackTarget getTarget() {
            return this.target;
        }

        @Override
        public boolean isSeed() {
            return this.seed;
        }
    }

    protected class request {
        private long id;
        private Set reply_instances = new HashSet();
        private Map replies = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected request(int n, Map map) {
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                this.id = AZInstanceManagerImpl.this.search_id_next++;
                AZInstanceManagerImpl.this.requests.add(this);
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
            map.put("type", new Long(n));
            map.put("rid", new Long(this.id));
            AZInstanceManagerImpl.this.sendMessage(3, map);
        }

        protected long getID() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReply(AZInstance aZInstance, Map map) {
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                if (!this.reply_instances.contains(aZInstance.getID())) {
                    this.reply_instances.add(aZInstance.getID());
                    this.replies.put(aZInstance, map);
                }
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map getReplies() {
            try {
                Thread.sleep(2500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                AZInstanceManagerImpl.this.requests.remove(this);
                Map map = this.replies;
                return map;
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
        }
    }
}

