/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerRequest;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPPacketHandler {
    private DHTUDPPacketHandlerFactory factory;
    private int network;
    private PRUDPPacketHandler packet_handler;
    private DHTUDPRequestHandler request_handler;
    private DHTUDPPacketHandlerStats stats;
    private boolean test_network_alive = true;
    private int BLOOM_FILTER_SIZE = 10000;
    private static final int BLOOM_ROTATION_PERIOD = 180000;
    private BloomFilter bloom1;
    private BloomFilter bloom2;
    private long last_bloom_rotation_time;

    protected DHTUDPPacketHandler(DHTUDPPacketHandlerFactory dHTUDPPacketHandlerFactory, int n, PRUDPPacketHandler pRUDPPacketHandler, DHTUDPRequestHandler dHTUDPRequestHandler) {
        this.factory = dHTUDPPacketHandlerFactory;
        this.network = n;
        this.packet_handler = pRUDPPacketHandler;
        this.request_handler = dHTUDPRequestHandler;
        this.bloom1 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
        this.bloom2 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
        this.stats = new DHTUDPPacketHandlerStats(this.packet_handler);
    }

    public void testNetworkAlive(boolean bl) {
        this.test_network_alive = bl;
    }

    protected DHTUDPRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    protected PRUDPPacketHandler getPacketHandler() {
        return this.packet_handler;
    }

    protected int getNetwork() {
        return this.network;
    }

    protected void updateBloom(InetSocketAddress inetSocketAddress) {
        long l = SystemTime.getCurrentTime() - this.last_bloom_rotation_time;
        if (l < 0L || l > 180000L) {
            this.bloom1 = this.bloom2;
            this.bloom2 = BloomFilterFactory.createAddOnly(this.BLOOM_FILTER_SIZE);
            this.last_bloom_rotation_time = SystemTime.getCurrentTime();
        }
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        this.bloom1.add(byArray);
        this.bloom2.add(byArray);
    }

    public void sendAndReceive(DHTUDPPacketRequest dHTUDPPacketRequest, InetSocketAddress inetSocketAddress, final DHTUDPPacketReceiver dHTUDPPacketReceiver, long l, int n) throws DHTUDPPacketHandlerException {
        inetSocketAddress = AddressUtils.adjustDHTAddress(inetSocketAddress, true);
        try {
            dHTUDPPacketRequest.setNetwork(this.network);
            if (this.test_network_alive) {
                this.updateBloom(inetSocketAddress);
                this.packet_handler.sendAndReceive(dHTUDPPacketRequest, inetSocketAddress, new PRUDPPacketReceiver(){

                    @Override
                    public void packetReceived(PRUDPPacketHandlerRequest pRUDPPacketHandlerRequest, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) {
                        DHTUDPPacketReply dHTUDPPacketReply = (DHTUDPPacketReply)pRUDPPacket;
                        DHTUDPPacketHandler.this.stats.packetReceived(dHTUDPPacketReply.getSerialisedSize());
                        if (dHTUDPPacketReply.getNetwork() == DHTUDPPacketHandler.this.network) {
                            dHTUDPPacketReceiver.packetReceived(dHTUDPPacketReply, inetSocketAddress, pRUDPPacketHandlerRequest.getElapsedTime());
                        } else {
                            Debug.out("Non-matching network reply received");
                            dHTUDPPacketReceiver.error(new DHTUDPPacketHandlerException(new Exception("Non-matching network reply received")));
                        }
                    }

                    @Override
                    public void error(PRUDPPacketHandlerException pRUDPPacketHandlerException) {
                        dHTUDPPacketReceiver.error(new DHTUDPPacketHandlerException(pRUDPPacketHandlerException));
                    }
                }, l, n);
            } else {
                dHTUDPPacketReceiver.error(new DHTUDPPacketHandlerException(new Exception("Test network disabled")));
            }
        }
        catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
            throw new DHTUDPPacketHandlerException(pRUDPPacketHandlerException);
        }
        finally {
            this.stats.packetSent(dHTUDPPacketRequest.getSerialisedSize());
        }
    }

    public void send(DHTUDPPacketRequest dHTUDPPacketRequest, InetSocketAddress inetSocketAddress) throws DHTUDPPacketHandlerException {
        inetSocketAddress = AddressUtils.adjustDHTAddress(inetSocketAddress, true);
        this.updateBloom(inetSocketAddress);
        try {
            dHTUDPPacketRequest.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(dHTUDPPacketRequest, inetSocketAddress);
            }
        }
        catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
            throw new DHTUDPPacketHandlerException(pRUDPPacketHandlerException);
        }
        finally {
            this.stats.packetSent(dHTUDPPacketRequest.getSerialisedSize());
        }
    }

    public void send(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress) throws DHTUDPPacketHandlerException {
        inetSocketAddress = AddressUtils.adjustDHTAddress(inetSocketAddress, true);
        try {
            dHTUDPPacketReply.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(dHTUDPPacketReply, inetSocketAddress);
            }
        }
        catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
            throw new DHTUDPPacketHandlerException(pRUDPPacketHandlerException);
        }
        finally {
            this.stats.packetSent(dHTUDPPacketReply.getSerialisedSize());
        }
    }

    protected void receive(DHTUDPPacketRequest dHTUDPPacketRequest) {
        if (this.test_network_alive) {
            boolean bl;
            dHTUDPPacketRequest.setAddress(AddressUtils.adjustDHTAddress(dHTUDPPacketRequest.getAddress(), false));
            byte[] byArray = dHTUDPPacketRequest.getAddress().getAddress().getAddress();
            boolean bl2 = bl = !this.bloom1.contains(byArray);
            if (bl) {
                this.bloom1.add(byArray);
                this.bloom2.add(byArray);
            }
            this.stats.packetReceived(dHTUDPPacketRequest.getSerialisedSize());
            this.request_handler.process(dHTUDPPacketRequest, bl);
        }
    }

    public void setDelays(int n, int n2, int n3) {
        this.packet_handler.setDelays(n, n2, n3);
    }

    public void destroy() {
        this.factory.destroy(this);
    }

    public DHTUDPPacketHandlerStats getStats() {
        return this.stats;
    }
}

