/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterContactImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTRouterNodeImpl {
    private DHTRouterImpl router;
    private int depth;
    private boolean contains_router_node_id;
    private List buckets;
    private List replacements;
    private DHTRouterNodeImpl left;
    private DHTRouterNodeImpl right;
    private long last_lookup_time;

    protected DHTRouterNodeImpl(DHTRouterImpl dHTRouterImpl, int n, boolean bl, List list) {
        this.router = dHTRouterImpl;
        this.depth = n;
        this.contains_router_node_id = bl;
        this.buckets = list;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected boolean containsRouterNodeID() {
        return this.contains_router_node_id;
    }

    protected DHTRouterNodeImpl getLeft() {
        return this.left;
    }

    protected DHTRouterNodeImpl getRight() {
        return this.right;
    }

    protected void split(DHTRouterNodeImpl dHTRouterNodeImpl, DHTRouterNodeImpl dHTRouterNodeImpl2) {
        this.buckets = null;
        if (this.replacements != null) {
            Debug.out("DHTRouterNode: inconsistenct - splitting a node with replacements");
        }
        this.left = dHTRouterNodeImpl;
        this.right = dHTRouterNodeImpl2;
    }

    protected List getBuckets() {
        return this.buckets;
    }

    protected List getReplacements() {
        return this.replacements;
    }

    protected void addNode(DHTRouterContactImpl dHTRouterContactImpl) {
        dHTRouterContactImpl.setBucketEntry();
        this.router.notifyAdded(dHTRouterContactImpl);
        this.buckets.add(dHTRouterContactImpl);
        this.requestNodeAdd(dHTRouterContactImpl, false);
    }

    protected DHTRouterContact addReplacement(DHTRouterContactImpl dHTRouterContactImpl, int n) {
        DHTRouterContactImpl dHTRouterContactImpl2;
        int n2;
        if (n == 0) {
            return null;
        }
        boolean bl = false;
        if (this.replacements == null) {
            bl = true;
            this.replacements = new ArrayList();
        } else if (this.replacements.size() == n) {
            if (dHTRouterContactImpl.hasBeenAlive()) {
                for (n2 = 0; n2 < this.replacements.size(); ++n2) {
                    dHTRouterContactImpl2 = (DHTRouterContactImpl)this.replacements.get(n2);
                    if (dHTRouterContactImpl2.hasBeenAlive()) continue;
                    bl = true;
                    this.router.notifyRemoved(dHTRouterContactImpl2);
                    this.replacements.remove(n2);
                    break;
                }
                if (this.replacements.size() == n) {
                    DHTRouterContactImpl dHTRouterContactImpl3 = (DHTRouterContactImpl)this.replacements.remove(0);
                    this.router.notifyRemoved(dHTRouterContactImpl3);
                }
            } else {
                for (int i = 0; i < this.replacements.size(); ++i) {
                    dHTRouterContactImpl2 = (DHTRouterContactImpl)this.replacements.get(i);
                    if (dHTRouterContactImpl2.hasBeenAlive()) continue;
                    this.router.notifyRemoved(dHTRouterContactImpl2);
                    this.replacements.remove(i);
                    break;
                }
            }
        } else {
            bl = true;
        }
        if (this.replacements.size() == n) {
            return null;
        }
        dHTRouterContactImpl.setReplacement();
        this.router.notifyAdded(dHTRouterContactImpl);
        this.replacements.add(dHTRouterContactImpl);
        if (bl) {
            for (n2 = 0; n2 < this.buckets.size(); ++n2) {
                dHTRouterContactImpl2 = (DHTRouterContactImpl)this.buckets.get(n2);
                if (this.router.isID(dHTRouterContactImpl2.getID()) || dHTRouterContactImpl2.getPingOutstanding()) continue;
                dHTRouterContactImpl2.setPingOutstanding(true);
                this.router.requestPing(dHTRouterContactImpl2);
                break;
            }
        }
        return dHTRouterContactImpl;
    }

    protected DHTRouterContactImpl updateExistingNode(byte[] byArray, DHTRouterContactAttachment dHTRouterContactAttachment, boolean bl) {
        DHTRouterContactImpl dHTRouterContactImpl;
        int n;
        for (n = 0; n < this.buckets.size(); ++n) {
            int n2;
            int n3;
            dHTRouterContactImpl = (DHTRouterContactImpl)this.buckets.get(n);
            if (!Arrays.equals(byArray, dHTRouterContactImpl.getID())) continue;
            if (bl) {
                this.alive(dHTRouterContactImpl);
            }
            if ((n3 = dHTRouterContactAttachment.getInstanceID()) != 0 && (n2 = dHTRouterContactImpl.getAttachment().getInstanceID()) != n3) {
                DHTLog.log("Instance ID changed for " + DHTLog.getString(dHTRouterContactImpl.getID()) + ": old = " + n2 + ", new = " + n3);
                dHTRouterContactImpl.setAttachment(dHTRouterContactAttachment);
                this.requestNodeAdd(dHTRouterContactImpl, n2 != 0);
            }
            return dHTRouterContactImpl;
        }
        if (this.replacements != null) {
            for (n = 0; n < this.replacements.size(); ++n) {
                dHTRouterContactImpl = (DHTRouterContactImpl)this.replacements.get(n);
                if (!Arrays.equals(byArray, dHTRouterContactImpl.getID())) continue;
                if (bl) {
                    this.alive(dHTRouterContactImpl);
                }
                return dHTRouterContactImpl;
            }
        }
        return null;
    }

    protected void alive(DHTRouterContactImpl dHTRouterContactImpl) {
        dHTRouterContactImpl.setPingOutstanding(false);
        boolean bl = dHTRouterContactImpl.isAlive();
        if (this.buckets.remove(dHTRouterContactImpl)) {
            dHTRouterContactImpl.setAlive();
            if (!bl) {
                this.router.notifyNowAlive(dHTRouterContactImpl);
            }
            this.buckets.add(dHTRouterContactImpl);
        } else if (this.replacements.remove(dHTRouterContactImpl)) {
            long l = dHTRouterContactImpl.getFirstFailOrLastAliveTime();
            dHTRouterContactImpl.setAlive();
            if (!bl) {
                this.router.notifyNowAlive(dHTRouterContactImpl);
            }
            if (dHTRouterContactImpl.getLastAliveTime() - l > 30000L) {
                for (int i = 0; i < this.buckets.size(); ++i) {
                    DHTRouterContactImpl dHTRouterContactImpl2 = (DHTRouterContactImpl)this.buckets.get(i);
                    if (this.router.isID(dHTRouterContactImpl2.getID()) || dHTRouterContactImpl2.getPingOutstanding()) continue;
                    dHTRouterContactImpl2.setPingOutstanding(true);
                    this.router.requestPing(dHTRouterContactImpl2);
                    break;
                }
            }
            this.replacements.add(dHTRouterContactImpl);
        }
    }

    protected void dead(DHTRouterContactImpl dHTRouterContactImpl, boolean bl) {
        dHTRouterContactImpl.setPingOutstanding(false);
        boolean bl2 = dHTRouterContactImpl.isFailing();
        if (dHTRouterContactImpl.setFailed() || bl) {
            if (this.buckets.remove(dHTRouterContactImpl)) {
                if (!bl2) {
                    this.router.notifyNowFailing(dHTRouterContactImpl);
                }
                this.router.notifyRemoved(dHTRouterContactImpl);
                if (this.replacements != null && this.replacements.size() > 0) {
                    boolean bl3 = false;
                    for (int i = this.replacements.size() - 1; i >= 0; --i) {
                        DHTRouterContactImpl dHTRouterContactImpl2 = (DHTRouterContactImpl)this.replacements.get(i);
                        if (!dHTRouterContactImpl2.hasBeenAlive()) continue;
                        DHTLog.log(DHTLog.getString(dHTRouterContactImpl.getID()) + ": using live replacement " + DHTLog.getString(dHTRouterContactImpl2.getID()));
                        dHTRouterContactImpl2.setBucketEntry();
                        this.router.notifyLocationChanged(dHTRouterContactImpl2);
                        this.replacements.remove(dHTRouterContactImpl2);
                        this.buckets.add(dHTRouterContactImpl2);
                        bl3 = true;
                        this.requestNodeAdd(dHTRouterContactImpl2, false);
                        break;
                    }
                    if (!bl3) {
                        DHTRouterContactImpl dHTRouterContactImpl3 = (DHTRouterContactImpl)this.replacements.remove(this.replacements.size() - 1);
                        DHTLog.log(DHTLog.getString(dHTRouterContactImpl.getID()) + ": using unknown replacement " + DHTLog.getString(dHTRouterContactImpl3.getID()));
                        dHTRouterContactImpl3.setBucketEntry();
                        this.router.notifyLocationChanged(dHTRouterContactImpl3);
                        this.buckets.add(dHTRouterContactImpl3);
                        this.requestNodeAdd(dHTRouterContactImpl3, false);
                    }
                }
            } else {
                if (!bl2) {
                    this.router.notifyNowFailing(dHTRouterContactImpl);
                }
                this.router.notifyRemoved(dHTRouterContactImpl);
                this.replacements.remove(dHTRouterContactImpl);
            }
        }
    }

    protected void requestNodeAdd(DHTRouterContactImpl dHTRouterContactImpl, boolean bl) {
        long l = SystemTime.getCurrentTime();
        if (l - dHTRouterContactImpl.getLastAddedTime() > 10000L) {
            dHTRouterContactImpl.setLastAddedTime(l);
            this.router.requestNodeAdd(dHTRouterContactImpl);
        } else if (bl) {
            this.router.log("requestNodeAdd for " + dHTRouterContactImpl.getString() + " denied as too soon after previous ");
        }
    }

    protected long getTimeSinceLastLookup() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_lookup_time) {
            return Long.MAX_VALUE;
        }
        return l - this.last_lookup_time;
    }

    protected void setLastLookupTime() {
        this.last_lookup_time = SystemTime.getCurrentTime();
    }

    public void print(String string, String string2) {
        if (this.left == null) {
            this.router.log(string + string2 + ": buckets = " + this.buckets.size() + this.contactsToString(this.buckets) + ", replacements = " + (this.replacements == null ? "null" : this.replacements.size() + this.contactsToString(this.replacements)) + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : "") + " tsll=" + this.getTimeSinceLastLookup());
        } else {
            this.router.log(string + string2 + ":" + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : ""));
            this.left.print(string + "  ", string2 + "1");
            this.right.print(string + "  ", string2 + "0");
        }
    }

    protected String contactsToString(List list) {
        String string = "{";
        for (int i = 0; i < list.size(); ++i) {
            string = string + (i == 0 ? "" : ", ") + ((DHTRouterContactImpl)list.get(i)).getString();
        }
        return string + "}";
    }
}

