/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DHTLog {
    public static final boolean GLOBAL_BLOOM_TRACE = false;
    public static final boolean LOCAL_BLOOM_TRACE = false;
    public static final boolean CONTACT_VERIFY_TRACE = false;
    public static final boolean TRACE_VERSIONS = false;
    public static boolean logging_on = false;
    private static DHTLogger logger;

    protected static void setLogging(boolean bl) {
        logging_on = bl;
    }

    public static boolean isOn() {
        return logging_on;
    }

    public static void log(String string) {
        if (logging_on) {
            if (logger != null) {
                logger.log(string);
            } else {
                System.out.println(string);
            }
        }
    }

    public static void setLogger(DHTLogger dHTLogger) {
        logger = dHTLogger;
    }

    public static String getString(byte[] byArray) {
        if (logging_on) {
            return DHTLog.getString2(byArray);
        }
        return "";
    }

    public static String getString2(byte[] byArray) {
        String string = ByteFormatter.nicePrint(byArray);
        if (string.length() > 8) {
            string = string.substring(0, 8) + "...";
        }
        return string;
    }

    public static String getFullString(byte[] byArray) {
        return ByteFormatter.nicePrint(byArray);
    }

    public static String getString(HashWrapper hashWrapper) {
        if (logging_on) {
            return DHTLog.getString(hashWrapper.getHash());
        }
        return "";
    }

    public static String getString(DHTTransportContact[] dHTTransportContactArray) {
        if (logging_on) {
            String string = "{";
            for (int i = 0; i < dHTTransportContactArray.length; ++i) {
                string = string + (i == 0 ? "" : ",") + DHTLog.getString(dHTTransportContactArray[i].getID());
            }
            return string + "}";
        }
        return "";
    }

    public static String getString(DHTTransportContact dHTTransportContact) {
        if (logging_on) {
            return dHTTransportContact.getString();
        }
        return "";
    }

    public static String getString(List list) {
        if (logging_on) {
            String string = "{";
            for (int i = 0; i < list.size(); ++i) {
                string = string + (i == 0 ? "" : ",") + DHTLog.getString((DHTTransportContact)list.get(i));
            }
            return string + "}";
        }
        return "";
    }

    public static String getString(Set set) {
        if (logging_on) {
            String string = "{";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = string + (string.length() == 1 ? "" : ",") + DHTLog.getString((DHTTransportContact)iterator.next());
            }
            return string + "}";
        }
        return "";
    }

    public static String getString(Map map) {
        if (logging_on) {
            String string = "{";
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string = string + (string.length() == 1 ? "" : ",") + DHTLog.getString((HashWrapper)iterator.next());
            }
            return string + "}";
        }
        return "";
    }

    public static String getString(DHTTransportValue[] dHTTransportValueArray) {
        if (logging_on) {
            if (dHTTransportValueArray == null) {
                return "<null>";
            }
            String string = "";
            for (int i = 0; i < dHTTransportValueArray.length; ++i) {
                string = string + (i == 0 ? "" : ",") + DHTLog.getString(dHTTransportValueArray[i]);
            }
            return string;
        }
        return "";
    }

    public static String getString(DHTTransportValue dHTTransportValue) {
        if (logging_on) {
            if (dHTTransportValue == null) {
                return "<null>";
            }
            return DHTLog.getString(dHTTransportValue.getValue()) + " <" + (dHTTransportValue.isLocal() ? "loc" : "rem") + ",flag=" + Integer.toHexString(dHTTransportValue.getFlags()) + ",life=" + dHTTransportValue.getLifeTimeHours() + ",rep=" + Integer.toHexString(dHTTransportValue.getReplicationControl()) + ",orig=" + dHTTransportValue.getOriginator().getExternalAddress() + ">";
        }
        return "";
    }
}

