/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import java.io.File;
import java.util.Map;

public class TranscodeProfileImpl
implements TranscodeProfile {
    private TranscodeProvider provider;
    private String uid;
    private String name;
    private Map<String, String> properties;

    protected TranscodeProfileImpl(TranscodeProvider transcodeProvider, String string, String string2, Map<String, String> map) {
        this.provider = transcodeProvider;
        this.uid = string;
        this.name = string2;
        this.properties = map;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TranscodeProvider getProvider() {
        return this.provider;
    }

    @Override
    public boolean isStreamable() {
        String string = this.properties.get("streamable");
        return string != null && string.equalsIgnoreCase("yes");
    }

    @Override
    public String getFileExtension() {
        return this.properties.get("file-ext");
    }

    @Override
    public String getDeviceClassification() {
        return this.properties.get("device");
    }

    @Override
    public String getDescription() {
        String string = this.properties.get("desc");
        return string == null ? "" : string;
    }

    @Override
    public String getIconURL() {
        return this.properties.get("icon-url");
    }

    @Override
    public int getIconIndex() {
        String string = this.properties.get("icon-index");
        if (string instanceof Number) {
            return ((Number)((Object)string)).intValue();
        }
        return 0;
    }

    @Override
    public File getAssetDirectory() {
        return this.provider.getAssetDirectory();
    }
}

