/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.download.DiskManagerFileInfoFile;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

class TranscodeFileImpl
implements TranscodeFile {
    protected static final String KEY_FILE = "file";
    private static final String KEY_PROFILE_NAME = "pn";
    private static final String KEY_SOURCE_FILE_HASH = "sf_hash";
    private static final String KEY_SOURCE_FILE_INDEX = "sf_index";
    private static final String KEY_SOURCE_FILE_LINK = "sf_link";
    private static final String KEY_NO_XCODE = "no_xcode";
    private static final String KEY_FOR_JOB = "fj";
    private static final String KEY_DURATION = "at_dur";
    private static final String KEY_VIDEO_WIDTH = "at_vw";
    private static final String KEY_VIDEO_HEIGHT = "at_vh";
    private static final String KEY_XCODE_SIZE = "at_xs";
    private static final String KEY_DATE = "at_dt";
    private static final String KEY_CATEGORIES = "cat";
    private static final String KEY_COPY_TO_OVERRIDE = "ct_over";
    private DeviceImpl device;
    private String key;
    private Map<String, Map<String, ?>> files_map;

    protected TranscodeFileImpl(DeviceImpl deviceImpl, String string, String string2, Map<String, Map<String, ?>> map, File file, boolean bl) {
        this.device = deviceImpl;
        this.key = string;
        this.files_map = map;
        this.getMap(true);
        this.setString(KEY_FILE, file.getAbsolutePath());
        this.setString(KEY_PROFILE_NAME, string2);
        this.setLong(KEY_DATE, SystemTime.getCurrentTime());
        this.setBoolean(KEY_FOR_JOB, bl);
    }

    protected TranscodeFileImpl(DeviceImpl deviceImpl, String string, Map<String, Map<String, ?>> map) throws IOException {
        this.device = deviceImpl;
        this.key = string;
        this.files_map = map;
        Map<String, ?> map2 = this.getMap();
        if (map2 == null || !map2.containsKey(KEY_FILE)) {
            throw new IOException("File has been deleted");
        }
    }

    protected String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        String string;
        TranscodeJobImpl transcodeJobImpl = this.getJob();
        if (transcodeJobImpl == null) {
            try {
                DiskManagerFileInfo diskManagerFileInfo = this.getSourceFile();
                try {
                    Download download = diskManagerFileInfo.getDownload();
                    if (download == null) {
                        string = diskManagerFileInfo.getFile().getName();
                    } else {
                        string = download.getName();
                        DiskManagerFileInfo[] diskManagerFileInfoArray = download.getDiskManagerFileInfo();
                        if (diskManagerFileInfoArray.length > 1) {
                            string = string + ": " + diskManagerFileInfo.getFile().getName();
                        }
                    }
                }
                catch (DownloadException downloadException) {
                    string = diskManagerFileInfo.getFile().getName();
                }
            }
            catch (Throwable throwable) {
                string = "";
            }
        } else {
            string = transcodeJobImpl.getName();
        }
        return string;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public TranscodeJobImpl getJob() {
        if (this.isComplete()) {
            return null;
        }
        return this.device.getManager().getTranscodeManager().getQueue().getJob(this);
    }

    public File getCacheFile() throws TranscodeException {
        String string = this.getString(KEY_FILE);
        if (string == null) {
            throw new TranscodeException("File has been deleted");
        }
        return new File(string);
    }

    protected void setCacheFile(File file) {
        this.setString(KEY_FILE, file.getAbsolutePath());
    }

    protected void checkDeleted() throws TranscodeException {
        if (this.isDeleted()) {
            throw new TranscodeException("File has been deleted");
        }
    }

    @Override
    public DiskManagerFileInfo getSourceFile() throws TranscodeException {
        File file;
        Object object;
        this.checkDeleted();
        String string = this.getString(KEY_SOURCE_FILE_HASH);
        if (string != null) {
            try {
                object = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(Base32.decode(string));
                if (object != null) {
                    int n = (int)this.getLong(KEY_SOURCE_FILE_INDEX);
                    return object.getDiskManagerFileInfo(n);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((object = this.getString(KEY_SOURCE_FILE_LINK)) != null && ((file = new File((String)object)).exists() || this.getBoolean(KEY_NO_XCODE))) {
            return new DiskManagerFileInfoFile(file);
        }
        return new DiskManagerFileInfoFile(this.getCacheFile());
    }

    protected void setSourceFile(DiskManagerFileInfo diskManagerFileInfo) {
        try {
            Download download = diskManagerFileInfo.getDownload();
            if (download != null && download.getTorrent() != null) {
                this.setString(KEY_SOURCE_FILE_HASH, Base32.encode(download.getTorrent().getHash()));
                this.setLong(KEY_SOURCE_FILE_INDEX, diskManagerFileInfo.getIndex());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setString(KEY_SOURCE_FILE_LINK, diskManagerFileInfo.getFile().getAbsolutePath());
    }

    @Override
    public DiskManagerFileInfo getTargetFile() throws TranscodeException {
        File file = this.getCacheFile();
        if (file.exists() && file.length() > 0L) {
            return new DiskManagerFileInfoFile(file);
        }
        if (this.getBoolean(KEY_NO_XCODE)) {
            return this.getSourceFile();
        }
        return new DiskManagerFileInfoFile(file);
    }

    protected void setTranscodeRequired(boolean bl) throws TranscodeException {
        this.setBoolean(KEY_NO_XCODE, !bl);
        if (!bl) {
            this.device.revertFileName(this);
        }
    }

    @Override
    public boolean getTranscodeRequired() {
        return !this.getBoolean(KEY_NO_XCODE);
    }

    protected void setComplete(boolean bl) {
        this.setBoolean("comp", bl);
    }

    @Override
    public boolean isComplete() {
        return this.getBoolean("comp");
    }

    @Override
    public boolean isTemplate() {
        return !this.getBoolean(KEY_FOR_JOB);
    }

    protected void setCopiedToDevice(boolean bl) {
        this.setBoolean("copied", bl);
        this.setLong("copy_fail", 0L);
    }

    protected void setCopyToDeviceFailed() {
        this.setLong("copy_fail", this.getLong("copy_fail") + 1L);
    }

    @Override
    public long getCopyToDeviceFails() {
        return this.getLong("copy_fail");
    }

    @Override
    public boolean isCopiedToDevice() {
        return this.getBoolean("copied");
    }

    @Override
    public void retryCopyToDevice() {
        if (this.isCopiedToDevice()) {
            this.setCopiedToDevice(false);
        } else {
            this.setLong("copy_fail", 0L);
        }
    }

    protected void setProfileName(String string) {
        this.setString(KEY_PROFILE_NAME, string);
    }

    @Override
    public String getProfileName() {
        String string = this.getString(KEY_PROFILE_NAME);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    protected void setCopyToFolderOverride(String string) {
        this.setString(KEY_COPY_TO_OVERRIDE, string);
    }

    public String getCopyToFolderOverride() {
        return this.getString(KEY_COPY_TO_OVERRIDE);
    }

    protected void update(TranscodeProviderAnalysis transcodeProviderAnalysis) throws TranscodeException {
        this.checkDeleted();
        long l = transcodeProviderAnalysis.getLongProperty(2);
        long l2 = transcodeProviderAnalysis.getLongProperty(3);
        long l3 = transcodeProviderAnalysis.getLongProperty(4);
        long l4 = transcodeProviderAnalysis.getLongProperty(7);
        if (l > 0L) {
            this.setLong(KEY_DURATION, l);
        }
        if (l2 > 0L && l3 > 0L) {
            this.setLong(KEY_VIDEO_WIDTH, l2);
            this.setLong(KEY_VIDEO_HEIGHT, l3);
        }
        if (l4 > 0L) {
            this.setLong(KEY_XCODE_SIZE, l4);
        }
    }

    protected void setResolution(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.setLong(KEY_VIDEO_WIDTH, n);
            this.setLong(KEY_VIDEO_HEIGHT, n2);
        }
    }

    @Override
    public long getDurationMillis() {
        return this.getLong(KEY_DURATION);
    }

    @Override
    public long getVideoWidth() {
        return this.getLong(KEY_VIDEO_WIDTH);
    }

    @Override
    public long getVideoHeight() {
        return this.getLong(KEY_VIDEO_HEIGHT);
    }

    @Override
    public long getEstimatedTranscodeSize() {
        return this.getLong(KEY_XCODE_SIZE);
    }

    @Override
    public String[] getCategories() {
        String string = this.getString(KEY_CATEGORIES);
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        return string.split(",");
    }

    @Override
    public void setCategories(String[] stringArray) {
        String[] stringArray2 = this.getCategories();
        if (stringArray2.length == 0 && stringArray2.length == stringArray.length) {
            return;
        }
        String string = "";
        for (String string2 : stringArray) {
            if ((string2 = string2.replaceAll(",", "").trim()).length() <= 0) continue;
            string = string + (string.length() == 0 ? "" : ",") + string2;
        }
        this.setString(KEY_CATEGORIES, string);
    }

    @Override
    public long getCreationDateMillis() {
        return this.getLong(KEY_DATE);
    }

    @Override
    public File getCacheFileIfExists() {
        try {
            return this.getCacheFile();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public URL getStreamURL() {
        return this.device.getStreamURL(this, null);
    }

    @Override
    public URL getStreamURL(String string) {
        return this.device.getStreamURL(this, string);
    }

    public String getMimeType() {
        return this.device.getMimeType(this);
    }

    @Override
    public void delete(boolean bl) throws TranscodeException {
        this.device.deleteFile(this, bl, true);
    }

    protected void deleteCacheFile() throws TranscodeException {
        this.device.deleteFile(this, true, false);
    }

    @Override
    public boolean isDeleted() {
        return this.getMap() == null;
    }

    private Map<String, ?> getMap() {
        return this.getMap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> getMap(boolean bl) {
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            Map<String, ?> map2 = this.files_map.get(this.key);
            if (map2 == null && bl) {
                map2 = new HashMap();
                this.files_map.put(this.key, map2);
            }
            return map2;
        }
    }

    protected boolean getBoolean(String string) {
        return this.getLong(string) == 1L;
    }

    protected void setBoolean(String string, boolean bl) {
        this.setLong(string, bl ? 1L : 0L);
    }

    protected long getLong(String string) {
        try {
            Map<String, ?> map = this.getMap();
            return ImportExportUtils.importLong(map, string, 0L);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLong(String string, long l) {
        if (this.getLong(string) == l) {
            return;
        }
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            try {
                Map<String, ?> map2 = this.getMap();
                ImportExportUtils.exportLong(map2, string, l);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        this.device.fileDirty(this, 1, string);
    }

    protected String getString(String string) {
        try {
            Map<String, ?> map = this.getMap();
            return ImportExportUtils.importString(map, string);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setString(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null && string2 == null) {
            return;
        }
        if (string3 != null && string2 != null && string3.equals(string2)) {
            return;
        }
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            Map<String, ?> map2 = this.getMap();
            try {
                ImportExportUtils.exportString(map2, string, string2);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        this.device.fileDirty(this, 1, string);
    }

    @Override
    public void setTransientProperty(Object object, Object object2) {
        this.device.setTransientProperty(this.key, object, object2);
    }

    @Override
    public Object getTransientProperty(Object object) {
        return this.device.getTransientProperty(this.key, object);
    }

    public boolean equals(Object object) {
        if (object instanceof TranscodeFileImpl) {
            return this.key.equals(((TranscodeFileImpl)object).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    protected String getString() {
        Map<String, ?> map = this.getMap();
        if (map == null) {
            return this.key + ": deleted";
        }
        return this.key + ": " + map;
    }
}

