/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class DeviceiTunes
extends DeviceMediaRendererImpl
implements DeviceMediaRenderer {
    private static final String UID = "a5d7869e-1ab9-6098-fef9-88476d988455";
    private static final Object ERRROR_KEY_ITUNES = new Object();
    private static final int INSTALL_CHECK_PERIOD = 60000;
    private static final int RUNNING_CHECK_PERIOD = 30000;
    private static final int DEVICE_CHECK_PERIOD = 10000;
    private static final int INSTALL_CHECK_TICKS = 12;
    private static final int RUNNING_CHECK_TICKS = 6;
    private static final int DEVICE_CHECK_TICKS = 2;
    private static final Object COPY_ERROR_KEY = new Object();
    private PluginInterface itunes;
    private volatile boolean is_installed;
    private volatile boolean is_running;
    private boolean copy_outstanding;
    private boolean copy_outstanding_set;
    private AEThread2 copy_thread;
    private AESemaphore copy_sem = new AESemaphore("Device:copy");
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);
    private long last_update_fail;
    private int consec_fails;

    protected DeviceiTunes(DeviceManagerImpl deviceManagerImpl, PluginInterface pluginInterface) {
        super(deviceManagerImpl, UID, "iTunes", true);
        this.itunes = pluginInterface;
    }

    protected DeviceiTunes(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (!super.updateFrom(deviceImpl, bl)) {
            return false;
        }
        if (!(deviceImpl instanceof DeviceiTunes)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceiTunes deviceiTunes = (DeviceiTunes)deviceImpl;
        this.itunes = deviceiTunes.itunes;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
        if (this.getPersistentBooleanProperty("copy_outstanding", false)) {
            this.setCopyOutstanding();
        }
        this.addListener(new TranscodeTargetListener(){

            @Override
            public void fileAdded(TranscodeFile transcodeFile) {
                if (transcodeFile.isComplete() && !transcodeFile.isCopiedToDevice()) {
                    DeviceiTunes.this.setCopyOutstanding();
                }
            }

            @Override
            public void fileChanged(TranscodeFile transcodeFile, int n, Object object) {
                if (transcodeFile.isComplete() && !transcodeFile.isCopiedToDevice()) {
                    DeviceiTunes.this.setCopyOutstanding();
                }
            }

            @Override
            public void fileRemoved(TranscodeFile transcodeFile) {
                DeviceiTunes.this.copy_sem.release();
            }
        });
    }

    @Override
    protected String getDeviceClassification() {
        return "apple.";
    }

    @Override
    public int getRendererSpecies() {
        return 3;
    }

    @Override
    public InetAddress getAddress() {
        return null;
    }

    @Override
    public boolean canRemove() {
        return false;
    }

    @Override
    public boolean isLivenessDetectable() {
        return true;
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    @Override
    protected void updateStatus(int n) {
        super.updateStatus(n);
        this.updateStatusSupport(n);
        if (this.is_installed && this.is_running) {
            this.alive();
        } else {
            this.dead();
        }
    }

    protected void updateStatusSupport(int n) {
        if (this.itunes == null) {
            return;
        }
        if (!this.is_installed && n % 12 == 0) {
            this.updateiTunesStatus();
            return;
        }
        if (!this.is_running && n % 6 == 0) {
            this.updateiTunesStatus();
            return;
        }
        if (n % 2 == 0) {
            this.updateiTunesStatus();
        }
    }

    protected void updateiTunesStatus() {
        if (this.getManager().isClosing()) {
            return;
        }
        IPCInterface iPCInterface = this.itunes.getIPC();
        try {
            Map map = (Map)iPCInterface.invoke("getProperties", new Object[0]);
            this.is_installed = (Boolean)map.get("installed");
            boolean bl = this.is_running;
            this.is_running = (Boolean)map.get("running");
            if (this.is_running && !bl) {
                this.copy_sem.release();
            }
            if (!this.is_installed && !this.is_running) {
                this.last_update_fail = 0L;
            }
            String string = null;
            if (this.getCopyToDevicePending() > 0) {
                if (!this.is_installed) {
                    string = MessageText.getString("device.itunes.install");
                } else if (!this.is_running && !this.getAutoStartDevice()) {
                    string = MessageText.getString("device.itunes.start");
                }
            }
            this.setInfo(ERRROR_KEY_ITUNES, string);
            Throwable throwable = (Throwable)map.get("error");
            if (throwable != null) {
                throw throwable;
            }
            this.last_update_fail = 0L;
            this.consec_fails = 0;
            this.setError(ERRROR_KEY_ITUNES, null);
        }
        catch (Throwable throwable) {
            long l = SystemTime.getMonotonousTime();
            ++this.consec_fails;
            if (this.last_update_fail == 0L) {
                this.last_update_fail = l;
            } else if (l - this.last_update_fail > 60000L && this.consec_fails >= 3) {
                this.setError(ERRROR_KEY_ITUNES, MessageText.getString("device.itunes.install_problem"));
            }
            this.log("iTunes IPC failed", throwable);
        }
    }

    @Override
    public boolean canCopyToDevice() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCopyToDevicePending() {
        TranscodeFileImpl[] transcodeFileImplArray = this;
        synchronized (this) {
            if (!this.copy_outstanding) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            transcodeFileImplArray = this.getFiles();
            int n = 0;
            for (TranscodeFileImpl transcodeFileImpl : transcodeFileImplArray) {
                if (!transcodeFileImpl.isComplete() || transcodeFileImpl.isCopiedToDevice()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCopyOutstanding() {
        DeviceiTunes deviceiTunes = this;
        synchronized (deviceiTunes) {
            this.copy_outstanding_set = true;
            if (this.copy_thread == null) {
                this.copy_thread = new AEThread2("Device:copier", true){

                    @Override
                    public void run() {
                        DeviceiTunes.this.performCopy();
                    }
                };
                this.copy_thread.start();
            }
            this.copy_sem.release();
        }
    }

    @Override
    public boolean canAutoStartDevice() {
        return true;
    }

    @Override
    public boolean getAutoStartDevice() {
        return this.getPersistentBooleanProperty("auto_start", true);
    }

    @Override
    public void setAutoStartDevice(boolean bl) {
        this.setPersistentBooleanProperty("auto_start", bl);
        if (bl) {
            this.copy_sem.release();
        }
    }

    @Override
    public boolean canAssociate() {
        return false;
    }

    @Override
    public void associate(DeviceManager.UnassociatedDevice unassociatedDevice) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void performCopy() {
        var1_1 = this;
        // MONITORENTER : this
        this.copy_outstanding = true;
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                DeviceiTunes.this.setPersistentBooleanProperty("copy_outstanding", true);
            }
        });
        // MONITOREXIT : var1_1
        block10: while (true) {
            if (this.copy_sem.reserve(60000L)) {
                while (this.copy_sem.reserveIfAvailable()) {
                }
            }
            var1_2 = this.getAutoStartDevice();
            var2_3 = this;
            // MONITORENTER : this
            if (!(this.itunes != null && (this.is_running || var1_2 && this.is_installed))) {
                if (!this.copy_outstanding && !this.copy_outstanding_set) {
                    this.copy_thread = null;
                    // MONITOREXIT : var2_3
                    return;
                }
                // MONITOREXIT : var2_3
                continue;
            }
            this.copy_outstanding_set = false;
            // MONITOREXIT : var2_3
            var2_3 = this.getFiles();
            var3_4 = new ArrayList<TranscodeFileImpl>();
            var4_5 = false;
            for (TranscodeFileImpl var8_13 : var2_3) {
                if (!var8_13.isComplete() || var8_13.isCopiedToDevice()) continue;
                if (var8_13.getCopyToDeviceFails() < 3L) {
                    var3_4.add(var8_13);
                    continue;
                }
                var4_5 = true;
            }
            if (var4_5) {
                this.setError(DeviceiTunes.COPY_ERROR_KEY, MessageText.getString("device.error.copyfail2"));
            }
            var5_6 = this;
            // MONITORENTER : this
            if (var3_4.size() == 0 && !this.copy_outstanding_set && !var4_5) {
                this.copy_outstanding = false;
                this.async_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        DeviceiTunes.this.setError(COPY_ERROR_KEY, null);
                        DeviceiTunes.this.setPersistentBooleanProperty("copy_outstanding", false);
                    }
                });
                this.copy_thread = null;
                // MONITOREXIT : var5_6
                return;
            }
            // MONITOREXIT : var5_6
            var5_6 = var3_4.iterator();
            while (true) {
                if (var5_6.hasNext()) ** break;
                continue block10;
                var6_8 = (TranscodeFileImpl)var5_6.next();
                try {
                    var7_10 = var6_8.getTargetFile().getFile();
                    try {
                        var8_14 = this.itunes.getIPC();
                        if (!this.is_running) {
                            this.log("Auto-starting iTunes");
                        }
                        if ((var10_18 = (Throwable)(var9_17 = (Map)var8_14.invoke("addFileToLibrary", new Object[]{var7_10})).get("error")) != null) {
                            throw var10_18;
                        }
                        this.is_running = true;
                        this.log("Added file '" + var7_10 + ": " + var9_17);
                        var6_8.setCopiedToDevice(true);
                    }
                    catch (Throwable var8_15) {
                        var6_8.setCopyToDeviceFailed();
                        this.log("Failed to copy file " + var7_10, var8_15);
                    }
                }
                catch (TranscodeException var7_11) {
                }
            }
            break;
        }
    }

    @Override
    public boolean isBrowsable() {
        return false;
    }

    @Override
    public Device.browseLocation[] getBrowseLocations() {
        return null;
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        if (this.itunes == null) {
            this.addDP(list, "devices.comp.missing", "<null>");
        } else {
            this.updateiTunesStatus();
            this.addDP(list, "devices.installed", this.is_installed);
            this.addDP(list, "MyTrackerView.status.started", this.is_running);
            this.addDP(list, "devices.copy.pending", this.copy_outstanding);
            this.addDP(list, "devices.auto.start", this.getAutoStartDevice());
        }
    }

    @Override
    public String getStatus() {
        if (this.is_running) {
            return MessageText.getString("device.itunes.status.running");
        }
        if (this.is_installed) {
            return MessageText.getString("device.itunes.status.notrunning");
        }
        return MessageText.getString("device.itunes.status.notinstalled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        super.generate(indentWriter);
        try {
            indentWriter.indent();
            indentWriter.println("itunes=" + this.itunes + ", installed=" + this.is_installed + ", running=" + this.is_running + ", auto_start=" + this.getAutoStartDevice());
            indentWriter.println("copy_os=" + this.copy_outstanding + ", last_fail=" + new SimpleDateFormat().format(new Date(this.last_update_fail)));
        }
        finally {
            indentWriter.exdent();
        }
    }
}

