/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivo;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class DeviceTivoManager {
    private static final String LF = "\n";
    private static final int CONTROL_PORT = 2190;
    private DeviceManagerImpl device_manager;
    private PluginInterface plugin_interface;
    private boolean is_enabled;
    private String uid;
    private String server_name = "Vuze";
    private Searcher current_search;
    private volatile boolean manager_destroyed;

    protected DeviceTivoManager(DeviceManagerImpl deviceManagerImpl) {
        this.device_manager = deviceManagerImpl;
    }

    protected void startUp() {
        Object object;
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.is_enabled = COConfigurationManager.getStringParameter("ui").equals("az2") ? false : COConfigurationManager.getBooleanParameter("devices.tivo.enabled", true);
        this.uid = COConfigurationManager.getStringParameter("devices.tivo.uid", null);
        if (this.uid == null) {
            object = new byte[8];
            RandomUtils.nextBytes((byte[])object);
            this.uid = Base32.encode((byte[])object);
            COConfigurationManager.setParameter("devices.tivo.uid", this.uid);
        }
        try {
            object = PlatformManagerFactory.getPlatformManager().getComputerName();
            if (object != null && ((String)object).length() > 0) {
                this.server_name = this.server_name + " on " + (String)object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.server_name = (String)this.device_manager.getUPnPManager().getUPnPAVIPC().invoke("getServiceName", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = false;
        for (DeviceImpl deviceImpl : this.device_manager.getDevices()) {
            if (!(deviceImpl instanceof DeviceTivo)) continue;
            bl = true;
            break;
        }
        if (bl || this.device_manager.getAutoSearch()) {
            this.search(bl, false);
        }
    }

    protected boolean isEnabled() {
        return this.is_enabled;
    }

    protected void setEnabled(boolean bl) {
        COConfigurationManager.setParameter("devices.tivo.enabled", bl);
        if (bl) {
            this.search(false, true);
        } else {
            for (DeviceImpl deviceImpl : this.device_manager.getDevices()) {
                if (!(deviceImpl instanceof DeviceTivo)) continue;
                deviceImpl.remove();
            }
        }
    }

    protected void search() {
        this.search(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(boolean bl, boolean bl2) {
        try {
            DeviceTivoManager deviceTivoManager = this;
            synchronized (deviceTivoManager) {
                if (this.current_search == null) {
                    this.current_search = new Searcher(bl, bl2);
                } else if (!this.current_search.wakeup()) {
                    this.current_search = new Searcher(bl, bl2);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    protected byte[] encodeBeacon(boolean bl, int n) throws IOException {
        String string = "tivoconnect=1\nswversion=1\nmethod=" + (bl ? "broadcast" : "connected") + LF + "identity=" + this.uid + LF + "machine=" + this.server_name + LF + "platform=pc" + LF + "services=TiVoMediaServer:" + n + "/http";
        return string.getBytes("ISO-8859-1");
    }

    protected Map<String, String> decodeBeacon(byte[] byArray, int n) throws IOException {
        String string = new String(byArray, 0, n, "ISO-8859-1");
        String[] stringArray = string.split(LF);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n2 = string2.indexOf(61);
            if (n2 <= 0) continue;
            hashMap.put(string2.substring(0, n2).trim().toLowerCase(), string2.substring(n2 + 1).trim());
        }
        return hashMap;
    }

    protected boolean receiveBeacon(InetAddress inetAddress, byte[] byArray, int n) {
        if (this.is_enabled) {
            try {
                Map<String, String> map = this.decodeBeacon(byArray, n);
                String string = map.get("identity");
                if (string == null || string.equals(this.uid)) {
                    return false;
                }
                String string2 = map.get("platform");
                if (string2 != null && string2.toLowerCase().startsWith("tcd/")) {
                    String string3 = "tivo." + string2.substring(4).toLowerCase();
                    this.foundTiVo(inetAddress, string, string3, map.get("machine"));
                    return true;
                }
            }
            catch (Throwable throwable) {
                this.log("Failed to decode beacon", throwable);
            }
        }
        return false;
    }

    protected DeviceTivo foundTiVo(InetAddress inetAddress, String string, String string2, String string3) {
        string = "tivo:" + string;
        DeviceImpl[] deviceImplArray = this.device_manager.getDevices();
        for (DeviceImpl deviceImpl : deviceImplArray) {
            if (!(deviceImpl instanceof DeviceTivo)) continue;
            DeviceTivo deviceTivo = (DeviceTivo)deviceImpl;
            if (!deviceImpl.getID().equals(string)) continue;
            deviceTivo.found(this, inetAddress, this.server_name, string3);
            return deviceTivo;
        }
        DeviceTivo deviceTivo = new DeviceTivo(this.device_manager, string, string2);
        DeviceTivo deviceTivo2 = (DeviceTivo)this.device_manager.addDevice(deviceTivo);
        if (deviceTivo2 == deviceTivo) {
            deviceTivo.found(this, inetAddress, this.server_name, string3);
        }
        return deviceTivo2;
    }

    protected void log(String string) {
        if (this.device_manager == null) {
            System.out.println(string);
        } else {
            this.device_manager.log("TiVo: " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (this.device_manager == null) {
            System.out.println(string);
            throwable.printStackTrace();
        } else {
            this.device_manager.log("TiVo: " + string, throwable);
        }
    }

    protected class Searcher {
        private static final int LIFE_MILLIS = 10000;
        private long start = SystemTime.getMonotonousTime();
        private int tcp_port;
        private DatagramSocket control_socket;
        private TrackerWebContext twc;
        private TimerEventPeriodic timer_event;
        private volatile boolean persistent;
        private volatile boolean search_destroyed;

        protected Searcher(boolean bl, boolean bl2) throws DeviceManagerException {
            try {
                Object object;
                int n = COConfigurationManager.getIntParameter("devices.tivo.net.tcp.port", 0);
                if (n > 0) {
                    try {
                        object = new ServerSocket(n);
                        ((ServerSocket)object).setReuseAddress(true);
                        ((ServerSocket)object).close();
                    }
                    catch (Throwable throwable) {
                        n = 0;
                    }
                }
                this.twc = DeviceTivoManager.this.plugin_interface.getTracker().createWebContext(n, 1);
                this.tcp_port = this.twc.getURLs()[0].getPort();
                COConfigurationManager.setParameter("devices.tivo.net.tcp.port", this.tcp_port);
                this.twc.addPageGenerator(new TrackerWebPageGenerator(){

                    @Override
                    public boolean generate(TrackerWebPageRequest trackerWebPageRequest, TrackerWebPageResponse trackerWebPageResponse) throws IOException {
                        String string = (String)trackerWebPageRequest.getHeaders().get("tsn");
                        if (string == null) {
                            string = (String)trackerWebPageRequest.getHeaders().get("tivo_tcd_id");
                        }
                        if (string != null && DeviceTivoManager.this.is_enabled) {
                            Searcher.this.persistent = true;
                            DeviceTivo deviceTivo = DeviceTivoManager.this.foundTiVo(trackerWebPageRequest.getClientAddress2().getAddress(), string, "tivo.series3", null);
                            return deviceTivo.generate(trackerWebPageRequest, trackerWebPageResponse);
                        }
                        return false;
                    }
                });
                this.control_socket = new DatagramSocket(null);
                this.control_socket.setReuseAddress(true);
                try {
                    this.control_socket.setSoTimeout(60000);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                this.control_socket.bind(new InetSocketAddress((InetAddress)object, 2190));
                this.timer_event = SimpleTimer.addPeriodicEvent("Tivo:Beacon", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent timerEvent2) {
                        if (!DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            Searcher.this.sendBeacon();
                        }
                        if (!Searcher.this.persistent) {
                            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
                            synchronized (deviceTivoManager) {
                                if (SystemTime.getMonotonousTime() - Searcher.this.start >= 10000L) {
                                    DeviceTivoManager.this.log("Terminating search, no devices found");
                                    DeviceTivoManager.this.current_search = null;
                                    Searcher.this.destroy();
                                }
                            }
                        }
                    }
                });
                final AESemaphore aESemaphore = new AESemaphore("TiVo:CtrlListener");
                new AEThread2("TiVo:CtrlListener", true){

                    @Override
                    public void run() {
                        aESemaphore.release();
                        long l = 0L;
                        long l2 = 0L;
                        while (!DeviceTivoManager.this.manager_destroyed && !Searcher.this.search_destroyed) {
                            try {
                                byte[] byArray = new byte[8192];
                                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                                Searcher.this.control_socket.receive(datagramPacket);
                                ++l;
                                l2 = 0L;
                                if (!DeviceTivoManager.this.receiveBeacon(datagramPacket.getAddress(), datagramPacket.getData(), datagramPacket.getLength())) continue;
                                Searcher.this.persistent = true;
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                            }
                            catch (Throwable throwable) {
                                if (Searcher.this.control_socket != null && !Searcher.this.search_destroyed && !DeviceTivoManager.this.manager_destroyed) {
                                    ++l2;
                                    DeviceTivoManager.this.log("UDP receive on port 2190 failed", throwable);
                                }
                                if ((l2 <= 100L || l != 0L) && l2 <= 1000L) continue;
                                DeviceTivoManager.this.log("    too many failures, abandoning");
                                break;
                            }
                        }
                    }
                }.start();
                if (bl2) {
                    new DelayedEvent("search:delay", 5000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            Searcher.this.sendBeacon();
                        }
                    });
                } else {
                    aESemaphore.reserve(5000L);
                    this.sendBeacon();
                }
                DeviceTivoManager.this.log("Initiated device search");
            }
            catch (Throwable throwable) {
                DeviceTivoManager.this.log("Failed to initialise search", throwable);
                this.destroy();
                throw new DeviceManagerException("Creation failed", throwable);
            }
        }

        protected void sendBeacon() {
            if (DeviceTivoManager.this.is_enabled) {
                try {
                    byte[] byArray = DeviceTivoManager.this.encodeBeacon(true, this.tcp_port);
                    this.control_socket.send(new DatagramPacket(byArray, byArray.length, InetAddress.getByName("255.255.255.255"), 2190));
                }
                catch (Throwable throwable) {
                    DeviceTivoManager.this.log("Failed to send beacon", throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wakeup() {
            DeviceTivoManager deviceTivoManager = DeviceTivoManager.this;
            synchronized (deviceTivoManager) {
                if (this.search_destroyed) {
                    return false;
                }
                this.start = SystemTime.getMonotonousTime();
            }
            this.sendBeacon();
            return true;
        }

        protected void destroy() {
            this.search_destroyed = true;
            if (this.twc != null) {
                this.twc.destroy();
                this.twc = null;
            }
            if (this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
            if (this.control_socket != null) {
                try {
                    this.control_socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.control_socket = null;
            }
        }
    }
}

