/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceMediaRendererTemplate;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class DeviceMediaRendererTemplateImpl
implements DeviceMediaRendererTemplate {
    private List<TranscodeProfile> profiles = new ArrayList<TranscodeProfile>();
    private final DeviceManagerImpl manager;
    private final String classification;
    private final String name;
    private final String manufacturer;
    private final boolean auto;

    protected DeviceMediaRendererTemplateImpl(DeviceManagerImpl deviceManagerImpl, String string, boolean bl) {
        this.manager = deviceManagerImpl;
        this.classification = string;
        this.auto = bl;
        int n = this.classification.indexOf(46);
        this.manufacturer = n == -1 ? this.classification : this.classification.substring(0, n);
        n = this.classification.lastIndexOf(46);
        this.name = n == -1 ? this.classification : this.classification.substring(n + 1);
    }

    protected void addProfile(TranscodeProfile transcodeProfile) {
        this.profiles.add(transcodeProfile);
    }

    @Override
    public TranscodeProfile[] getProfiles() {
        return this.profiles.toArray(new TranscodeProfile[this.profiles.size()]);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String getClassification() {
        return this.classification;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public int getRendererSpecies() {
        return 6;
    }

    @Override
    public boolean isAuto() {
        return this.auto;
    }

    @Override
    public Device createInstance(String string) throws DeviceManagerException {
        if (this.auto) {
            throw new DeviceManagerException("Device can't be added manually");
        }
        Device device = this.manager.createDevice(3, null, this.classification, string);
        return device;
    }
}

