/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.DeviceInternetGateway;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;

public class DeviceInternetGatewayImpl
extends DeviceUPnPImpl
implements DeviceInternetGateway {
    private static final int CHECK_MAPPINGS_PERIOD = 30000;
    private static final int CHECK_MAPPINGS_TICK_COUNT = 6;
    private static UPnPPlugin upnp_plugin;
    private static List<DeviceInternetGatewayImpl> igds;
    private boolean mapper_enabled;
    private UPnPPluginService[] current_services;
    private UPnPMapping[] current_mappings;

    protected DeviceInternetGatewayImpl(DeviceManagerImpl deviceManagerImpl, UPnPDevice uPnPDevice, List<UPnPWANConnection> list) {
        super(deviceManagerImpl, uPnPDevice, 1);
        this.updateStatus(0);
    }

    protected DeviceInternetGatewayImpl(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        super(deviceManagerImpl, map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (!super.updateFrom(deviceImpl, bl)) {
            return false;
        }
        if (!(deviceImpl instanceof DeviceInternetGatewayImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceInternetGatewayImpl deviceInternetGatewayImpl = (DeviceInternetGatewayImpl)deviceImpl;
        return true;
    }

    @Override
    protected void updateStatus(int n) {
        super.updateStatus(n);
        if (n % 6 != 0) {
            return;
        }
        this.mapper_enabled = upnp_plugin != null && upnp_plugin.isEnabled();
        UPnPDevice uPnPDevice = this.getUPnPDevice();
        if (this.mapper_enabled && uPnPDevice != null) {
            this.current_services = upnp_plugin.getServices(uPnPDevice);
            this.current_mappings = upnp_plugin.getMappings();
        }
    }

    @Override
    protected URL getPresentationURL(UPnPDevice uPnPDevice) {
        URL uRL = super.getPresentationURL(uPnPDevice);
        if (uRL == null) {
            try {
                URL uRL2 = uPnPDevice.getRootDevice().getLocation();
                URL uRL3 = new URL(uRL2.getProtocol() + "://" + uRL2.getHost() + "/");
                uRL3.openConnection().connect();
                return uRL3;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return uRL;
    }

    protected Set<mapping> getRequiredMappings() {
        TreeSet<mapping> treeSet = new TreeSet<mapping>();
        UPnPMapping[] uPnPMappingArray = this.current_mappings;
        if (uPnPMappingArray != null) {
            for (UPnPMapping uPnPMapping : uPnPMappingArray) {
                if (!uPnPMapping.isEnabled()) continue;
                treeSet.add(new mapping(uPnPMapping));
            }
        }
        return treeSet;
    }

    protected Set<mapping> getActualMappings(UPnPPluginService uPnPPluginService) {
        UPnPPluginService.serviceMapping[] serviceMappingArray = uPnPPluginService.getMappings();
        TreeSet<mapping> treeSet = new TreeSet<mapping>();
        for (UPnPPluginService.serviceMapping serviceMapping2 : serviceMappingArray) {
            mapping mapping2 = new mapping(serviceMapping2);
            treeSet.add(mapping2);
        }
        return treeSet;
    }

    @Override
    protected void getDisplayProperties(List<String[]> list) {
        super.getDisplayProperties(list);
        this.addDP(list, "device.router.is_mapping", this.mapper_enabled);
        UPnPPluginService[] uPnPPluginServiceArray = this.current_services;
        String string = "";
        Set<mapping> set = this.getRequiredMappings();
        for (mapping mapping2 : set) {
            string = string + (string.length() == 0 ? "" : ",") + mapping2.getString();
        }
        this.addDP(list, "device.router.req_map", string);
        if (uPnPPluginServiceArray != null) {
            for (UPnPPluginService uPnPPluginService : uPnPPluginServiceArray) {
                Set<mapping> set2 = this.getActualMappings(uPnPPluginService);
                String string2 = "";
                for (mapping mapping3 : set2) {
                    if (!set.contains(mapping3)) continue;
                    string2 = string2 + (string2.length() == 0 ? "" : ",") + mapping3.getString();
                }
                String string3 = MessageText.getString("device.router.con_type", new String[]{uPnPPluginService.getService().getConnectionType()});
                this.addDP(list, "!    " + (String)string3 + "!", string2);
            }
        }
    }

    static {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore azureusCore) {
                try {
                    PluginInterface pluginInterface = azureusCore.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (pluginInterface != null) {
                        upnp_plugin = (UPnPPlugin)pluginInterface.getPlugin();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    protected static class mapping
    implements Comparable<mapping> {
        private boolean is_tcp;
        private int port;

        protected mapping(UPnPMapping uPnPMapping) {
            this.is_tcp = uPnPMapping.isTCP();
            this.port = uPnPMapping.getPort();
        }

        protected mapping(UPnPPluginService.serviceMapping serviceMapping2) {
            this.is_tcp = serviceMapping2.isTCP();
            this.port = serviceMapping2.getPort();
        }

        @Override
        public int compareTo(mapping mapping2) {
            int n = this.port - mapping2.port;
            if (n == 0) {
                n = (this.is_tcp ? 1 : 0) - (mapping2.is_tcp ? 1 : 0);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof mapping) {
                mapping mapping2 = (mapping)object;
                return this.is_tcp == mapping2.is_tcp && this.port == mapping2.port;
            }
            return false;
        }

        public int hashCode() {
            return (this.port << 16) + (this.is_tcp ? 1 : 0);
        }

        public String getString() {
            return (this.is_tcp ? "TCP" : "UDP") + " " + this.port;
        }
    }
}

