/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private ArrayList<TableFilter> filters = New.arrayList();
    private ArrayList<TableFilter> topFilters = New.arrayList();
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ArrayList<SelectOrderBy> orderList;
    private ArrayList<Expression> group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private HashMap<Expression, Object> currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isForUpdate;
    private boolean isForUpdateMvcc;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;
    private int currentGroupRowId;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter tableFilter, boolean bl) {
        this.filters.add(tableFilter);
        if (bl) {
            this.topFilters.add(tableFilter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> arrayList) {
        this.expressions = arrayList;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> arrayList) {
        this.group = arrayList;
    }

    public HashMap<Expression, Object> getCurrentGroup() {
        return this.currentGroup;
    }

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    public void addCondition(Expression expression) {
        this.condition = this.condition == null ? expression : new ConditionAndOr(0, expression, this.condition);
    }

    private void queryGroupSorted(int n, ResultTarget resultTarget) {
        int n2 = 0;
        this.setCurrentRowNumber(0);
        Object[] objectArray = null;
        while (this.topTableFilter.next()) {
            int n3;
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            Object[] objectArray2 = new Value[this.groupIndex.length];
            for (n3 = 0; n3 < this.groupIndex.length; ++n3) {
                int n4 = this.groupIndex[n3];
                Expression expression = this.expressions.get(n4);
                objectArray2[n3] = expression.getValue(this.session);
            }
            if (objectArray == null) {
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            } else if (!Arrays.equals(objectArray, objectArray2)) {
                this.addGroupSortedRow((Value[])objectArray, n, resultTarget);
                objectArray = objectArray2;
                this.currentGroup = New.hashMap();
            }
            ++this.currentGroupRowId;
            for (n3 = 0; n3 < n; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                Expression expression = this.expressions.get(n3);
                expression.updateAggregate(this.session);
            }
        }
        if (objectArray != null) {
            this.addGroupSortedRow((Value[])objectArray, n, resultTarget);
        }
    }

    private void addGroupSortedRow(Value[] valueArray, int n, ResultTarget resultTarget) {
        int n2;
        Value[] valueArray2 = new Value[n];
        for (n2 = 0; this.groupIndex != null && n2 < this.groupIndex.length; ++n2) {
            valueArray2[this.groupIndex[n2]] = valueArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.groupByExpression != null && this.groupByExpression[n2]) continue;
            Expression expression = this.expressions.get(n2);
            valueArray2[n2] = expression.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(valueArray2)) {
            return;
        }
        valueArray2 = this.keepOnlyDistinct(valueArray2, n);
        resultTarget.addRow(valueArray2);
    }

    private Value[] keepOnlyDistinct(Value[] valueArray, int n) {
        if (n == this.distinctColumnCount) {
            return valueArray;
        }
        Value[] valueArray2 = new Value[this.distinctColumnCount];
        System.arraycopy(valueArray, 0, valueArray2, 0, this.distinctColumnCount);
        return valueArray2;
    }

    private boolean isHavingNullOrFalse(Value[] valueArray) {
        if (this.havingIndex >= 0) {
            Value value = valueArray[this.havingIndex];
            if (value == ValueNull.INSTANCE) {
                return true;
            }
            if (!Boolean.TRUE.equals(value.getBoolean())) {
                return true;
            }
        }
        return false;
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> arrayList = this.topTableFilter.getTable().getIndexes();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Index index = arrayList.get(i);
                if (index.getIndexType().isScan() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int n;
        Column[] columnArray = index.getColumns();
        boolean[] blArray = new boolean[columnArray.length];
        int n2 = this.expressions.size();
        block0: for (n = 0; n < n2; ++n) {
            if (!this.groupByExpression[n]) continue;
            Expression expression = this.expressions.get(n).getNonAliasExpression();
            if (!(expression instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            for (int i = 0; i < columnArray.length; ++i) {
                if (tableFilter != expressionColumn.getTableFilter() || !columnArray[i].equals(expressionColumn.getColumn())) continue;
                blArray[i] = true;
                continue block0;
            }
            return false;
        }
        for (n = 1; n < blArray.length; ++n) {
            if (blArray[n - 1] || !blArray[n]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int n = 0;
        for (boolean bl : this.groupByExpression) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    private void queryGroup(int n, LocalResult localResult) {
        Object object;
        Object object2;
        Object object3;
        ValueHashMap valueHashMap = ValueHashMap.newInstance();
        int n2 = 0;
        this.setCurrentRowNumber(0);
        ValueArray valueArray = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            int n3;
            int n4;
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            if (this.groupIndex == null) {
                object3 = valueArray;
            } else {
                object2 = new Value[this.groupIndex.length];
                for (n4 = 0; n4 < this.groupIndex.length; ++n4) {
                    n3 = this.groupIndex[n4];
                    object = this.expressions.get(n3);
                    object2[n4] = ((Expression)object).getValue(this.session);
                }
                object3 = ValueArray.get(object2);
            }
            object2 = (HashMap)valueHashMap.get((Value)object3);
            if (object2 == null) {
                object2 = new HashMap();
                valueHashMap.put((Value)object3, object2);
            }
            this.currentGroup = object2;
            ++this.currentGroupRowId;
            n4 = n;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                object = this.expressions.get(n3);
                ((Expression)object).updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || n2 < this.sampleSize) continue;
            break;
        }
        if (this.groupIndex == null && valueHashMap.size() == 0) {
            valueHashMap.put(valueArray, new HashMap());
        }
        object3 = valueHashMap.keys();
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            int n5;
            Value value = object2.next();
            ValueArray valueArray2 = (ValueArray)value;
            this.currentGroup = (HashMap)valueHashMap.get(valueArray2);
            object = valueArray2.getList();
            Value[] valueArray3 = new Value[n];
            for (n5 = 0; this.groupIndex != null && n5 < this.groupIndex.length; ++n5) {
                valueArray3[this.groupIndex[n5]] = object[n5];
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (this.groupByExpression != null && this.groupByExpression[n5]) continue;
                Expression expression = this.expressions.get(n5);
                valueArray3[n5] = expression.getValue(this.session);
            }
            if (this.isHavingNullOrFalse(valueArray3)) continue;
            valueArray3 = this.keepOnlyDistinct(valueArray3, n);
            localResult.addRow(valueArray3);
        }
    }

    private Index getSortIndex() {
        Index index;
        Object object;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> arrayList = New.arrayList();
        for (int index2 : this.sort.getIndexes()) {
            if (index2 < 0 || index2 >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", index2 + 1);
            }
            Expression n = this.expressions.get(index2);
            if ((n = n.getNonAliasExpression()).isConstant()) continue;
            if (!(n instanceof ExpressionColumn)) {
                return null;
            }
            object = (ExpressionColumn)n;
            if (((ExpressionColumn)object).getTableFilter() != this.topTableFilter) {
                return null;
            }
            arrayList.add(((ExpressionColumn)object).getColumn());
        }
        Column[] columnArray = arrayList.toArray(new Column[arrayList.size()]);
        int[] nArray = this.sort.getSortTypes();
        if (columnArray.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> arrayList2 = this.topTableFilter.getTable().getIndexes();
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int index2 = 0; index2 < n; ++index2) {
                IndexColumn[] indexColumnArray;
                object = arrayList2.get(index2);
                if (object.getCreateSQL() == null || object.getIndexType().isHash() || (indexColumnArray = object.getIndexColumns()).length < columnArray.length) continue;
                boolean bl = true;
                for (int i = 0; i < columnArray.length; ++i) {
                    IndexColumn indexColumn = indexColumnArray[i];
                    Column column = columnArray[i];
                    if (indexColumn.column != column) {
                        bl = false;
                        break;
                    }
                    if (indexColumn.sortType == nArray[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return object;
            }
        }
        if (columnArray.length == 1 && columnArray[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    private void queryDistinct(ResultTarget resultTarget, long l) {
        int n;
        if (l > 0L && this.offsetExpr != null && (n = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            l += (long)n;
        }
        n = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow searchRow = null;
        int n2 = index.getColumns()[0].getColumnId();
        do {
            this.setCurrentRowNumber(n + 1);
            Cursor cursor = index.findNext(this.session, searchRow, null);
            if (!cursor.next()) break;
            SearchRow searchRow2 = cursor.getSearchRow();
            Value value = searchRow2.getValue(n2);
            if (searchRow == null) {
                searchRow = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            searchRow.setValue(n2, value);
            Value[] valueArray = new Value[]{value};
            resultTarget.addRow(valueArray);
        } while ((this.sort != null && !this.sortUsingIndex || l <= 0L || (long)(++n) < l) && (this.sampleSize <= 0 || n < this.sampleSize));
    }

    private void queryFlat(int n, ResultTarget resultTarget, long l) {
        int n2;
        if (l > 0L && this.offsetExpr != null && (n2 = this.offsetExpr.getValue(this.session).getInt()) > 0) {
            l += (long)n2;
        }
        n2 = 0;
        this.setCurrentRowNumber(0);
        ArrayList<Row> arrayList = null;
        if (this.isForUpdateMvcc) {
            arrayList = New.arrayList();
        }
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                Expression expression = this.expressions.get(i);
                valueArray[i] = expression.getValue(this.session);
            }
            if (this.isForUpdateMvcc) {
                this.topTableFilter.lockRowAdd(arrayList);
            }
            resultTarget.addRow(valueArray);
            if ((this.sort != null && !this.sortUsingIndex || l <= 0L || (long)resultTarget.getRowCount() < l) && (this.sampleSize <= 0 || ++n2 < this.sampleSize)) continue;
            break;
        }
        if (this.isForUpdateMvcc) {
            this.topTableFilter.lockRows(arrayList);
        }
    }

    private void queryQuick(int n, ResultTarget resultTarget) {
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions.get(i);
            valueArray[i] = expression.getValue(this.session);
        }
        resultTarget.addRow(valueArray);
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
        localResult.done();
        return localResult;
    }

    @Override
    protected LocalResult queryWithoutCache(int n, ResultTarget resultTarget) {
        ResultTarget resultTarget2;
        int n2;
        int n3 = n2 = n == 0 ? -1 : n;
        if (this.limitExpr != null) {
            int n4;
            Value value = this.limitExpr.getValue(this.session);
            int n5 = n4 = value == ValueNull.INSTANCE ? -1 : value.getInt();
            if (n2 < 0) {
                n2 = n4;
            } else if (n4 >= 0) {
                n2 = Math.min(n4, n2);
            }
        }
        int n6 = this.expressions.size();
        LocalResult localResult = null;
        if (resultTarget == null || !this.session.getDatabase().getSettings().optimizeInsertFromSelect) {
            localResult = this.createLocalResult(localResult);
        }
        if (this.sort != null && (!this.sortUsingIndex || this.distinct)) {
            localResult = this.createLocalResult(localResult);
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            localResult = this.createLocalResult(localResult);
            localResult.setDistinct();
        }
        if (this.randomAccessResult) {
            localResult = this.createLocalResult(localResult);
            localResult.setRandomAccess();
        }
        if (this.isGroupQuery && !this.isGroupSortedQuery) {
            localResult = this.createLocalResult(localResult);
        }
        if (n2 >= 0 || this.offsetExpr != null) {
            localResult = this.createLocalResult(localResult);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        boolean bl = this.isForUpdate && !this.isForUpdateMvcc;
        this.topTableFilter.lock(this.session, bl, bl);
        if (this.isForUpdateMvcc) {
            if (this.isGroupQuery) {
                throw DbException.getUnsupportedException("FOR UPDATE && GROUP");
            }
            if (this.distinct) {
                throw DbException.getUnsupportedException("FOR UPDATE && DISTINCT");
            }
            if (this.isQuickAggregateQuery) {
                throw DbException.getUnsupportedException("FOR UPDATE && AGGREGATE");
            }
            if (this.topTableFilter.getJoin() != null) {
                throw DbException.getUnsupportedException("FOR UPDATE && JOIN");
            }
            if (this.topTableFilter.getJoin() != null) {
                throw DbException.getUnsupportedException("FOR UPDATE && JOIN");
            }
        }
        ResultTarget resultTarget3 = resultTarget2 = localResult != null ? localResult : resultTarget;
        if (n2 != 0) {
            if (this.isQuickAggregateQuery) {
                this.queryQuick(n6, resultTarget2);
            } else if (this.isGroupQuery) {
                if (this.isGroupSortedQuery) {
                    this.queryGroupSorted(n6, resultTarget2);
                } else {
                    this.queryGroup(n6, localResult);
                }
            } else if (this.isDistinctQuery) {
                this.queryDistinct(resultTarget2, n2);
            } else {
                this.queryFlat(n6, resultTarget2, n2);
            }
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (n2 >= 0) {
            localResult.setLimit(n2);
        }
        if (localResult != null) {
            localResult.done();
            if (resultTarget != null) {
                while (localResult.next()) {
                    resultTarget.addRow(localResult.currentRow());
                }
                localResult.close();
                return null;
            }
            return localResult;
        }
        return null;
    }

    private LocalResult createLocalResult(LocalResult localResult) {
        return localResult != null ? localResult : new LocalResult(this.session, this.expressionArray, this.visibleColumnCount);
    }

    private void expandColumnList() {
        Database database = this.session.getDatabase();
        for (int i = 0; i < this.expressions.size(); ++i) {
            Object object;
            Expression expression = this.expressions.get(i);
            if (!expression.isWildcard()) continue;
            String string = expression.getSchemaName();
            String string2 = expression.getTableAlias();
            if (string2 == null) {
                int n = i;
                this.expressions.remove(i);
                for (TableFilter tableFilter : this.filters) {
                    object = new Wildcard(tableFilter.getTable().getSchema().getName(), tableFilter.getTableAlias());
                    this.expressions.add(i++, (Expression)object);
                }
                i = n - 1;
                continue;
            }
            TableFilter object3 = null;
            for (TableFilter tableFilter : this.filters) {
                if (!database.equalsIdentifiers(string2, tableFilter.getTableAlias()) || string != null && !database.equalsIdentifiers(string, tableFilter.getSchemaName())) continue;
                object3 = tableFilter;
                break;
            }
            if (object3 == null) {
                throw DbException.get(42102, string2);
            }
            Table table = object3.getTable();
            String string3 = object3.getTableAlias();
            this.expressions.remove(i);
            for (Column column : object = table.getColumns()) {
                if (object3.isNaturalJoinColumn(column)) continue;
                ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), null, string3, column.getName());
                this.expressions.add(i++, expressionColumn);
            }
            --i;
        }
    }

    @Override
    public void init() {
        ArrayList<String> arrayList;
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            arrayList = New.arrayList();
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                Expression expression = this.expressions.get(i);
                expression = expression.getNonAliasExpression();
                String string = expression.getSQL();
                arrayList.add(string);
            }
        } else {
            arrayList = null;
        }
        if (this.orderList != null) {
            Select.initOrder(this.session, this.expressions, arrayList, this.orderList, this.visibleColumnCount, this.distinct, this.filters);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        Database database = this.session.getDatabase();
        if (this.group != null) {
            Object object;
            int n = this.group.size();
            Object object2 = arrayList.size();
            this.groupIndex = new int[n];
            for (int i = 0; i < n; ++i) {
                Object object3;
                Object object4;
                Expression expression = this.group.get(i);
                String string = expression.getSQL();
                object = -1;
                for (object4 = 0; object4 < object2; ++object4) {
                    object3 = arrayList.get((int)object4);
                    if (!database.equalsIdentifiers((String)object3, string)) continue;
                    object = object4;
                    break;
                }
                if (object < 0) {
                    for (object4 = 0; object4 < object2; ++object4) {
                        object3 = this.expressions.get((int)object4);
                        if (!database.equalsIdentifiers(string, ((Expression)object3).getAlias())) continue;
                        object = object4;
                        break;
                    }
                }
                if (object < 0) {
                    this.groupIndex[i] = object4 = this.expressions.size();
                    this.expressions.add(expression);
                    continue;
                }
                this.groupIndex[i] = object;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            Object object5 = this.groupIndex;
            int n2 = ((Object)object5).length;
            for (int i = 0; i < n2; ++i) {
                object = object5[i];
                this.groupByExpression[object] = true;
            }
            this.group = null;
        }
        for (TableFilter tableFilter : this.filters) {
            for (Expression expression : this.expressions) {
                expression.mapColumns(tableFilter, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns(tableFilter, 0);
        }
        if (this.havingIndex >= 0) {
            Expression expression = this.expressions.get(this.havingIndex);
            SelectListColumnResolver selectListColumnResolver = new SelectListColumnResolver(this);
            expression.mapColumns(selectListColumnResolver, 0);
        }
        this.checkInit = true;
    }

    @Override
    public void prepare() {
        Index index;
        boolean bl;
        Object object;
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression object22 = this.expressions.get(i);
            this.expressions.set(i, object22.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (TableFilter tableFilter : this.filters) {
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, tableFilter);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            Table table = this.filters.get(0).getTable();
            ExpressionVisitor expressionVisitor = ExpressionVisitor.getOptimizableVisitor(table);
            this.isQuickAggregateQuery = this.isEverything(expressionVisitor);
        }
        this.cost = this.preparePlan();
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expression = this.expressions.get(0);
            if ((expression = expression.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expression).getColumn();
                int n = column.getSelectivity();
                object = this.topTableFilter.getTable().getIndexForColumn(column, true);
                if (object != null && n != 50 && n < 20) {
                    IndexType indexType;
                    bl = object.getIndexColumns()[0].sortType == 0;
                    Index index2 = this.topTableFilter.getIndex();
                    if (!(!object.canFindNext() || !bl || index2 != null && !index2.getIndexType().isScan() && object != index2 || (indexType = object.getIndexType()).isHash() || indexType.isUnique() && object.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex((Index)object);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery && (index = this.getSortIndex()) != null) {
            Index index3 = this.topTableFilter.getIndex();
            if (index3.getIndexType().isScan() || index3 == index) {
                this.topTableFilter.setIndex(index);
                if (!this.topTableFilter.hasInComparisons()) {
                    this.sortUsingIndex = true;
                }
            } else if (index.getIndexColumns().length >= index3.getIndexColumns().length) {
                IndexColumn[] indexColumnArray = index.getIndexColumns();
                object = index3.getIndexColumns();
                bl = false;
                for (int i = 0; i < ((IndexColumn[])object).length; ++i) {
                    if (indexColumnArray[i].column != object[i].column) {
                        bl = false;
                        break;
                    }
                    if (indexColumnArray[i].sortType == ((IndexColumn)object[i]).sortType) continue;
                    bl = true;
                }
                if (bl) {
                    this.topTableFilter.setIndex(index);
                    this.sortUsingIndex = true;
                }
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index index3 = this.getGroupSortedIndex();
            Index index4 = this.topTableFilter.getIndex();
            if (index3 != null && (index4.getIndexType().isScan() || index4 == index3)) {
                this.topTableFilter.setIndex(index3);
                this.isGroupSortedQuery = true;
            }
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
        this.isPrepared = true;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = New.hashSet();
        for (TableFilter tableFilter : this.filters) {
            hashSet.add(tableFilter.getTable());
        }
        return hashSet;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            TableFilter tableFilter = this.filters.get(i);
            tableFilter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan() {
        TableFilter[] tableFilterArray = this.topFilters.toArray(new TableFilter[this.topFilters.size()]);
        for (TableFilter tableFilter : tableFilterArray) {
            tableFilter.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(tableFilterArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double d = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        this.topTableFilter.prepare();
        return d;
    }

    private void setEvaluatableRecursive(TableFilter tableFilter) {
        while (tableFilter != null) {
            Expression expression;
            TableFilter tableFilter2;
            tableFilter.setEvaluatable(tableFilter, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(tableFilter, true);
            }
            if ((tableFilter2 = tableFilter.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(tableFilter2);
            }
            if ((expression = tableFilter.getJoinCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                if (this.session.getDatabase().getSettings().nestedJoins) {
                    expression = expression.optimize(this.session);
                    if (!tableFilter.isJoinOuter() && !tableFilter.isJoinOuterIndirect()) {
                        tableFilter.removeJoinCondition();
                        this.addCondition(expression);
                    }
                } else {
                    if (tableFilter.isJoinOuter()) {
                        expression = expression.optimize(this.session);
                        throw DbException.get(90136, expression.getSQL());
                    }
                    tableFilter.removeJoinCondition();
                    expression = expression.optimize(this.session);
                    this.addCondition(expression);
                }
            }
            if ((expression = tableFilter.getFilterCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                tableFilter.removeFilterCondition();
                this.addCondition(expression);
            }
            for (Expression expression2 : this.expressions) {
                expression2.setEvaluatable(tableFilter, true);
            }
            tableFilter = tableFilter.getJoin();
        }
    }

    @Override
    public String getPlanSQL() {
        int n;
        Expression[] expressionArray = this.expressions.toArray(new Expression[this.expressions.size()]);
        StatementBuilder statementBuilder = new StatementBuilder("SELECT");
        if (this.distinct) {
            statementBuilder.append(" DISTINCT");
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            statementBuilder.appendExceptFirst(",");
            statementBuilder.append('\n');
            statementBuilder.append(StringUtils.indent(expressionArray[i].getSQL(), 4, false));
        }
        statementBuilder.append("\nFROM ");
        TableFilter tableFilter = this.topTableFilter;
        if (tableFilter != null) {
            statementBuilder.resetCount();
            n = 0;
            do {
                statementBuilder.appendExceptFirst("\n");
                statementBuilder.append(tableFilter.getPlanSQL(n++ > 0));
            } while ((tableFilter = tableFilter.getJoin()) != null);
        } else {
            statementBuilder.resetCount();
            n = 0;
            for (TableFilter tableFilter2 : this.topFilters) {
                do {
                    statementBuilder.appendExceptFirst("\n");
                    statementBuilder.append(tableFilter2.getPlanSQL(n++ > 0));
                } while ((tableFilter2 = tableFilter2.getJoin()) != null);
            }
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (int n2 : this.groupIndex) {
                Expression expression = expressionArray[n2];
                expression = expression.getNonAliasExpression();
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.group != null) {
            statementBuilder.append("\nGROUP BY ");
            statementBuilder.resetCount();
            for (Expression expression : this.group) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(expression.getSQL()));
            }
        }
        if (this.having != null) {
            Expression expression = this.having;
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        } else if (this.havingIndex >= 0) {
            Expression expression = expressionArray[this.havingIndex];
            statementBuilder.append("\nHAVING ").append(StringUtils.unEnclose(expression.getSQL()));
        }
        if (this.sort != null) {
            statementBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, this.visibleColumnCount));
        }
        if (this.orderList != null) {
            statementBuilder.append("\nORDER BY ");
            statementBuilder.resetCount();
            for (SelectOrderBy selectOrderBy : this.orderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.unEnclose(selectOrderBy.getSQL()));
            }
        }
        if (this.limitExpr != null) {
            statementBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                statementBuilder.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSize != 0) {
            statementBuilder.append("\nSAMPLE_SIZE ").append(this.sampleSize);
        }
        if (this.isForUpdate) {
            statementBuilder.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            statementBuilder.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            statementBuilder.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            statementBuilder.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            statementBuilder.append("\n/* group sorted */");
        }
        return statementBuilder.toString();
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.isForUpdate = bl;
        if (this.session.getDatabase().getSettings().selectForUpdateMvcc && this.session.getDatabase().isMultiVersion()) {
            this.isForUpdateMvcc = bl;
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.expressions) {
            expression.mapColumns(columnResolver, n);
        }
        if (this.condition != null) {
            this.condition.mapColumns(columnResolver, n);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.expressions) {
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, bl);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        Expression expression = this.expressions.get(n);
        expression = expression.getNonAliasExpression();
        Expression expression2 = expression.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(this.session, n2, expression, parameter) : new Comparison(this.session, 16, parameter, parameter);
        expression2 = ((Expression)expression2).optimize(this.session);
        boolean bl = true;
        if (this.isGroupQuery) {
            bl = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.havingIndex >= 0) {
                    this.having = this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? expression2 : new ConditionAndOr(0, this.having, expression2);
            }
        }
        if (bl) {
            this.condition = this.condition == null ? expression2 : new ConditionAndOr(0, this.condition, expression2);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.expressions) {
            expression.updateAggregate(session);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session);
        }
        if (this.having != null) {
            this.having.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        int n;
        switch (expressionVisitor.getType()) {
            case 2: {
                TableFilter tableFilter;
                int n2;
                if (this.isForUpdate) {
                    return false;
                }
                n = this.filters.size();
                for (n2 = 0; n2 < n; ++n2) {
                    tableFilter = this.filters.get(n2);
                    if (tableFilter.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                TableFilter tableFilter;
                int n2;
                n = this.filters.size();
                for (n2 = 0; n2 < n; ++n2) {
                    tableFilter = this.filters.get(n2);
                    long l = tableFilter.getTable().getMaxDataModificationId();
                    expressionVisitor.addDataModificationId(l);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                TableFilter tableFilter;
                int n2;
                n = this.filters.size();
                for (n2 = 0; n2 < n; ++n2) {
                    tableFilter = this.filters.get(n2);
                    Table table = tableFilter.getTable();
                    expressionVisitor.addDependency(table);
                    table.addDependencies(expressionVisitor.getDependencies());
                }
                break;
            }
        }
        ExpressionVisitor expressionVisitor2 = expressionVisitor.incrementQueryLevel(1);
        n = 1;
        int n3 = this.expressions.size();
        for (int i = 0; i < n3; ++i) {
            Expression expression = this.expressions.get(i);
            if (expression.isEverything(expressionVisitor2)) continue;
            n = 0;
            break;
        }
        if (n != 0 && this.condition != null && !this.condition.isEverything(expressionVisitor2)) {
            n = 0;
        }
        if (n != 0 && this.having != null && !this.having.isEverything(expressionVisitor2)) {
            n = 0;
        }
        return n != 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public int getType() {
        return 66;
    }
}

