/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.File;
import java.io.FileFilter;
import org.jaudiotagger.audio.mp3.MP3File;

public class ExtractID3TagFromFile {
    public static final String IDENT = "$Id: ExtractID3TagFromFile.java 836 2009-11-12 15:44:07Z paultaylor $";

    public static void main(String[] stringArray) {
        ExtractID3TagFromFile extractID3TagFromFile = new ExtractID3TagFromFile();
        if (stringArray.length != 2) {
            System.err.println("usage ExtractID3TagFromFile Filename FilenameOut");
            System.err.println("      You must enter the file to extract the tag from and where to extract to");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (!file.isFile()) {
            System.err.println("usage ExtractID3TagFromFile Filename FilenameOut");
            System.err.println("      File " + stringArray[0] + " could not be found");
            System.exit(1);
        }
        try {
            MP3File mP3File = new MP3File(file);
            mP3File.extractID3v2TagDataIntoFile(file2);
        }
        catch (Exception exception) {
            System.err.println("Unable to extract tag");
            System.exit(1);
        }
    }

    final class MP3FileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final boolean allowDirectories;

        public MP3FileFilter() {
            this(false);
        }

        private MP3FileFilter(boolean bl) {
            this.allowDirectories = bl;
        }

        @Override
        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".mp3") || file.isDirectory() && this.allowDirectories;
        }

        @Override
        public final String getDescription() {
            return ".mp3 Files";
        }
    }
}

