/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.reference;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;

public enum MusicalKey {
    NOTE_A("A"),
    NOTE_B("B"),
    NOTE_C("C"),
    NOTE_D("D"),
    NOTE_E("E"),
    NOTE_F("F"),
    NOTE_G("G"),
    FLAT("b"),
    SHARP("#"),
    MINOR("m"),
    OFF_KEY("o");

    private String value;
    private static final int MAX_KEY_LENGTH = 3;
    private static final HashMap<String, MusicalKey> groundKeyMap;
    private static final HashMap<String, MusicalKey> halfKeyMap;

    private MusicalKey(String string2) {
        this.value = string2;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isValid(String string) {
        if (string == null || string.length() > 3 || string.length() == 0) {
            return false;
        }
        if (string.length() == 1 && string.equals(OFF_KEY.getValue())) {
            return true;
        }
        if (!groundKeyMap.containsKey(string.substring(0, 1))) {
            return false;
        }
        if (!(string.length() != 2 && string.length() != 3 || halfKeyMap.containsKey(string.substring(1, 2)))) {
            return false;
        }
        return string.length() != 3 || string.substring(2, 3).equals(MINOR.getValue());
    }

    static {
        EnumSet<MusicalKey[]> enumSet = EnumSet.of(NOTE_A, new MusicalKey[]{NOTE_B, NOTE_C, NOTE_D, NOTE_E, NOTE_F, NOTE_G});
        groundKeyMap = new HashMap(MusicalKey.values().length);
        for (MusicalKey object2 : enumSet) {
            groundKeyMap.put(object2.getValue(), object2);
        }
        EnumSet<MusicalKey> enumSet2 = EnumSet.of(FLAT, SHARP, MINOR);
        halfKeyMap = new HashMap(MusicalKey.values().length);
        Iterator iterator = enumSet2.iterator();
        while (iterator.hasNext()) {
            MusicalKey musicalKey = (MusicalKey)((Object)iterator.next());
            halfKeyMap.put(musicalKey.getValue(), musicalKey);
        }
    }
}

