/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.ID3v2LyricLine;
import org.jaudiotagger.tag.datatype.Lyrics3Line;
import org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;

public class FieldFrameBodyLYR
extends AbstractLyrics3v2FieldFrameBody {
    private ArrayList<Lyrics3Line> lines = new ArrayList();

    public FieldFrameBodyLYR() {
    }

    public FieldFrameBodyLYR(FieldFrameBodyLYR fieldFrameBodyLYR) {
        super(fieldFrameBodyLYR);
        for (int i = 0; i < fieldFrameBodyLYR.lines.size(); ++i) {
            Lyrics3Line lyrics3Line = fieldFrameBodyLYR.lines.get(i);
            this.lines.add(new Lyrics3Line(lyrics3Line));
        }
    }

    public FieldFrameBodyLYR(String string) {
        this.readString(string);
    }

    public FieldFrameBodyLYR(FrameBodySYLT frameBodySYLT) {
        this.addLyric(frameBodySYLT);
    }

    public FieldFrameBodyLYR(FrameBodyUSLT frameBodyUSLT) {
        this.addLyric(frameBodyUSLT);
    }

    public FieldFrameBodyLYR(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    @Override
    public String getIdentifier() {
        return "LYR";
    }

    public void setLyric(String string) {
        this.readString(string);
    }

    public String getLyric() {
        return this.writeString();
    }

    @Override
    public int getSize() {
        int n = 0;
        Iterator<Lyrics3Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Lyrics3Line lyrics3Line;
            Lyrics3Line lyrics3Line2 = lyrics3Line = iterator.next();
            n += lyrics3Line2.getSize() + 2;
        }
        return n;
    }

    @Override
    public boolean isSubsetOf(Object object) {
        if (!(object instanceof FieldFrameBodyLYR)) {
            return false;
        }
        ArrayList<Lyrics3Line> arrayList = ((FieldFrameBodyLYR)object).lines;
        for (Lyrics3Line lyrics3Line : this.lines) {
            if (arrayList.contains(lyrics3Line)) continue;
            return false;
        }
        return super.isSubsetOf(object);
    }

    public void addLyric(FrameBodySYLT frameBodySYLT) {
        Iterator iterator = frameBodySYLT.iterator();
        HashMap<String, Lyrics3Line> hashMap = new HashMap<String, Lyrics3Line>();
        while (iterator.hasNext()) {
            Lyrics3Line lyrics3Line;
            ID3v2LyricLine iD3v2LyricLine = (ID3v2LyricLine)iterator.next();
            iD3v2LyricLine = new ID3v2LyricLine(iD3v2LyricLine);
            Lyrics3TimeStamp lyrics3TimeStamp = new Lyrics3TimeStamp("Time Stamp", this);
            lyrics3TimeStamp.setTimeStamp(iD3v2LyricLine.getTimeStamp(), (byte)frameBodySYLT.getTimeStampFormat());
            if (hashMap.containsKey(iD3v2LyricLine.getText())) {
                lyrics3Line = (Lyrics3Line)hashMap.get(iD3v2LyricLine.getText());
                lyrics3Line.addTimeStamp(lyrics3TimeStamp);
                continue;
            }
            lyrics3Line = new Lyrics3Line("Lyric Line", this);
            lyrics3Line.setLyric(iD3v2LyricLine);
            lyrics3Line.setTimeStamp(lyrics3TimeStamp);
            hashMap.put(iD3v2LyricLine.getText(), lyrics3Line);
            this.lines.add(lyrics3Line);
        }
    }

    public void addLyric(FrameBodyUSLT frameBodyUSLT) {
        Lyrics3Line lyrics3Line = new Lyrics3Line("Lyric Line", this);
        lyrics3Line.setLyric(frameBodyUSLT.getLyric());
        this.lines.add(lyrics3Line);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldFrameBodyLYR)) {
            return false;
        }
        FieldFrameBodyLYR fieldFrameBodyLYR = (FieldFrameBodyLYR)object;
        return this.lines.equals(fieldFrameBodyLYR.lines) && super.equals(object);
    }

    public boolean hasTimeStamp() {
        boolean bl = false;
        for (Lyrics3Line lyrics3Line : this.lines) {
            if (!lyrics3Line.hasTimeStamp()) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<Lyrics3Line> iterator() {
        return this.lines.iterator();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte[] byArray = new byte[5];
        byteBuffer.get(byArray, 0, 5);
        int n = Integer.parseInt(new String(byArray, 0, 5));
        if (n == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        byArray = new byte[n];
        byteBuffer.get(byArray);
        String string = new String(byArray);
        this.readString(string);
    }

    @Override
    public String toString() {
        String string = this.getIdentifier() + " : ";
        for (Lyrics3Line lyrics3Line : this.lines) {
            string = string + ((Object)lyrics3Line).toString();
        }
        return string;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2 = 0;
        byte[] byArray = new byte[5];
        int n3 = this.getSize();
        String string = Integer.toString(n3);
        for (n = 0; n < 5 - string.length(); ++n) {
            byArray[n] = 48;
        }
        n2 += 5 - string.length();
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += string.length();
        randomAccessFile.write(byArray, 0, 5);
        if (n3 > 0) {
            string = this.writeString();
            byArray = new byte[string.length()];
            for (n = 0; n < string.length(); ++n) {
                byArray[n] = (byte)string.charAt(n);
            }
            randomAccessFile.write(byArray);
        }
    }

    private void readString(String string) {
        Lyrics3Line lyrics3Line;
        String string2;
        int n = 0;
        int n2 = string.indexOf(Lyrics3v2Fields.CRLF);
        this.lines = new ArrayList();
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            lyrics3Line = new Lyrics3Line("Lyric Line", this);
            lyrics3Line.setLyric(string2);
            this.lines.add(lyrics3Line);
            n = n2 + Lyrics3v2Fields.CRLF.length();
            n2 = string.indexOf(Lyrics3v2Fields.CRLF, n);
        }
        if (n < string.length()) {
            string2 = string.substring(n);
            lyrics3Line = new Lyrics3Line("Lyric Line", this);
            lyrics3Line.setLyric(string2);
            this.lines.add(lyrics3Line);
        }
    }

    private String writeString() {
        String string = "";
        Iterator<Lyrics3Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Lyrics3Line lyrics3Line;
            Lyrics3Line lyrics3Line2 = lyrics3Line = iterator.next();
            string = string + lyrics3Line2.writeString() + Lyrics3v2Fields.CRLF;
        }
        return string;
    }

    @Override
    protected void setupObjectList() {
    }
}

