/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyTIPL
extends AbstractID3v2FrameBody
implements ID3v24FrameBody {
    public static final String ENGINEER = "engineer";
    public static final String MIXER = "mix";
    public static final String DJMIXER = "DJ-mix";
    public static final String PRODUCER = "producer";
    public static final String ARRANGER = "arranger";

    public FrameBodyTIPL() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyTIPL(byte by, String string) {
        this.setObjectValue("TextEncoding", by);
        this.setText(string);
    }

    public FrameBodyTIPL(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    public FrameBodyTIPL(FrameBodyIPLS frameBodyIPLS) {
        this.setObjectValue("TextEncoding", frameBodyIPLS.getTextEncoding());
        this.setObjectValue("Text", frameBodyIPLS.getPairing());
    }

    @Override
    public String getIdentifier() {
        return "TIPL";
    }

    public void setText(String string) {
        PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            valuePairs.add(string2, stringTokenizer.nextToken());
        }
        this.setObjectValue("Text", valuePairs);
    }

    public void addPair(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        if (stringTokenizer.countTokens() == 2) {
            this.addPair(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
    }

    public void addPair(String string, String string2) {
        PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        valuePairs.add(string, string2);
    }

    public void resetPairs() {
        PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        valuePairs.getMapping().clear();
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public PairedTextEncodedStringNullTerminated.ValuePairs getPairing() {
        return (PairedTextEncodedStringNullTerminated.ValuePairs)this.getObject("Text").getValue();
    }

    public String getKeyAtIndex(int n) {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getMapping().get(n).getKey();
    }

    public String getValueAtIndex(int n) {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getMapping().get(n).getValue();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getNumberOfPairs();
    }

    public String getText() {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        for (Pair pair : pairedTextEncodedStringNullTerminated.getValue().getMapping()) {
            stringBuilder.append(pair.getKey() + '\u0000' + pair.getValue());
            if (n != this.getNumberOfPairs()) {
                stringBuilder.append('\u0000');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getText();
    }
}

