/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.ByteArraySizeTerminated;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringFixedLength;
import org.jaudiotagger.tag.datatype.StringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.ID3v22FrameBody;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class FrameBodyPIC
extends AbstractID3v2FrameBody
implements ID3v22FrameBody {
    public static final String IMAGE_IS_URL = "-->";

    public FrameBodyPIC() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyPIC(FrameBodyPIC frameBodyPIC) {
        super(frameBodyPIC);
    }

    public FrameBodyPIC(byte by, String string, byte by2, String string2, byte[] byArray) {
        this.setObjectValue("TextEncoding", by);
        this.setObjectValue("ImageType", string);
        this.setPictureType(by2);
        this.setDescription(string2);
        this.setImageData(byArray);
    }

    public FrameBodyPIC(FrameBodyAPIC frameBodyAPIC) {
        this.setObjectValue("TextEncoding", frameBodyAPIC.getTextEncoding());
        this.setObjectValue("ImageType", ImageFormats.getFormatForMimeType((String)frameBodyAPIC.getObjectValue("MIMEType")));
        this.setObjectValue("PictureData", frameBodyAPIC.getObjectValue("PictureData"));
        this.setDescription(frameBodyAPIC.getDescription());
        this.setImageData(frameBodyAPIC.getImageData());
    }

    public FrameBodyPIC(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    public void setDescription(String string) {
        this.setObjectValue("Description", string);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public void setImageData(byte[] byArray) {
        this.setObjectValue("PictureData", byArray);
    }

    public byte[] getImageData() {
        return (byte[])this.getObjectValue("PictureData");
    }

    public void setPictureType(byte by) {
        this.setObjectValue("PictureType", by);
    }

    public int getPictureType() {
        return ((Long)this.getObjectValue("PictureType")).intValue();
    }

    @Override
    public String getIdentifier() {
        return "PIC";
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(byteArrayOutputStream);
    }

    public String getFormatType() {
        return (String)this.getObjectValue("ImageType");
    }

    public boolean isImageUrl() {
        return this.getFormatType() != null && this.getFormatType().equals(IMAGE_IS_URL);
    }

    public String getMimeType() {
        return (String)this.getObjectValue("MIMEType");
    }

    public String getImageUrl() {
        if (this.isImageUrl()) {
            return Utils.getString((byte[])this.getObjectValue("PictureData"), 0, ((byte[])this.getObjectValue("PictureData")).length, "ISO-8859-1");
        }
        return "";
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringFixedLength("ImageType", (AbstractTagFrameBody)this, 3));
        this.objectList.add(new NumberHashMap("PictureType", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringNullTerminated("Description", this));
        this.objectList.add(new ByteArraySizeTerminated("PictureData", this));
    }
}

