/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24FieldKey;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.ID3v24PreferredFrameOrderComparator;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Field;
import org.jaudiotagger.tag.reference.GenreTypes;
import org.jaudiotagger.tag.reference.PictureTypes;

public class ID3v24Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_FOOTER = "footer";
    protected static final String TYPE_IMAGEENCODINGRESTRICTION = "imageEncodingRestriction";
    protected static final String TYPE_IMAGESIZERESTRICTION = "imageSizeRestriction";
    protected static final String TYPE_TAGRESTRICTION = "tagRestriction";
    protected static final String TYPE_TAGSIZERESTRICTION = "tagSizeRestriction";
    protected static final String TYPE_TEXTENCODINGRESTRICTION = "textEncodingRestriction";
    protected static final String TYPE_TEXTFIELDSIZERESTRICTION = "textFieldSizeRestriction";
    protected static final String TYPE_UPDATETAG = "updateTag";
    protected static final String TYPE_CRCDATA = "crcdata";
    protected static final String TYPE_EXPERIMENTAL = "experimental";
    protected static final String TYPE_EXTENDED = "extended";
    protected static final String TYPE_PADDINGSIZE = "paddingsize";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    protected static int TAG_EXT_HEADER_LENGTH = 6;
    protected static int TAG_EXT_HEADER_UPDATE_LENGTH = 1;
    protected static int TAG_EXT_HEADER_CRC_LENGTH = 6;
    protected static int TAG_EXT_HEADER_RESTRICTION_LENGTH = 2;
    protected static int TAG_EXT_HEADER_CRC_DATA_LENGTH = 5;
    protected static int TAG_EXT_HEADER_RESTRICTION_DATA_LENGTH = 1;
    protected static int TAG_EXT_NUMBER_BYTES_DATA_LENGTH = 1;
    public static final int MASK_V24_UNSYNCHRONIZATION = 128;
    public static final int MASK_V24_EXTENDED_HEADER = 64;
    public static final int MASK_V24_EXPERIMENTAL = 32;
    public static final int MASK_V24_FOOTER_PRESENT = 16;
    public static final int MASK_V24_TAG_UPDATE = 64;
    public static final int MASK_V24_CRC_DATA_PRESENT = 32;
    public static final int MASK_V24_TAG_RESTRICTIONS = 16;
    public static final int MASK_V24_TAG_SIZE_RESTRICTIONS = -64;
    public static final int MASK_V24_TEXT_ENCODING_RESTRICTIONS = 32;
    public static final int MASK_V24_TEXT_FIELD_SIZE_RESTRICTIONS = 24;
    public static final int MASK_V24_IMAGE_ENCODING = 4;
    public static final int MASK_V24_IMAGE_SIZE_RESTRICTIONS = 6;
    public static final int MASK_V24_TAG_ALTER_PRESERVATION = 64;
    public static final int MASK_V24_FILE_ALTER_PRESERVATION = 32;
    public static final int MASK_V24_READ_ONLY = 16;
    public static final int MASK_V24_GROUPING_IDENTITY = 64;
    public static final int MASK_V24_COMPRESSION = 16;
    public static final int MASK_V24_ENCRYPTION = 8;
    public static final int MASK_V24_FRAME_UNSYNCHRONIZATION = 4;
    public static final int MASK_V24_DATA_LENGTH_INDICATOR = 2;
    protected boolean crcDataFlag;
    protected boolean experimental;
    protected boolean extended;
    protected boolean unsynchronization;
    protected int crcData;
    protected boolean footer;
    protected boolean updateTag;
    protected boolean tagRestriction;
    protected byte imageEncodingRestriction;
    protected byte imageSizeRestriction;
    protected byte tagSizeRestriction;
    protected byte textEncodingRestriction;
    protected int paddingSize;
    protected byte textFieldSizeRestriction;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 4;
    public static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 2;
    }

    @Override
    public byte getMajorVersion() {
        return 4;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v24Tag() {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
    }

    @Override
    protected void copyPrimitives(AbstractID3v2Tag abstractID3v2Tag) {
        logger.config("Copying primitives");
        super.copyPrimitives(abstractID3v2Tag);
        if (abstractID3v2Tag instanceof ID3v24Tag) {
            ID3v24Tag iD3v24Tag = (ID3v24Tag)abstractID3v2Tag;
            this.footer = iD3v24Tag.footer;
            this.tagRestriction = iD3v24Tag.tagRestriction;
            this.updateTag = iD3v24Tag.updateTag;
            this.imageEncodingRestriction = iD3v24Tag.imageEncodingRestriction;
            this.imageSizeRestriction = iD3v24Tag.imageSizeRestriction;
            this.tagSizeRestriction = iD3v24Tag.tagSizeRestriction;
            this.textEncodingRestriction = iD3v24Tag.textEncodingRestriction;
            this.textFieldSizeRestriction = iD3v24Tag.textFieldSizeRestriction;
        }
    }

    @Override
    protected void addFrame(AbstractID3v2Frame abstractID3v2Frame) {
        try {
            if (abstractID3v2Frame instanceof ID3v24Frame) {
                this.copyFrameIntoMap(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
            } else {
                ID3v24Frame iD3v24Frame = new ID3v24Frame(abstractID3v2Frame);
                this.copyFrameIntoMap(iD3v24Frame.getIdentifier(), iD3v24Frame);
            }
        }
        catch (InvalidFrameException invalidFrameException) {
            logger.log(Level.SEVERE, "Unable to convert frame:" + abstractID3v2Frame.getIdentifier());
        }
    }

    @Override
    protected void copyFrameIntoMap(String string, AbstractID3v2Frame abstractID3v2Frame) {
        if (this.frameMap.containsKey(abstractID3v2Frame.getIdentifier())) {
            Object v = this.frameMap.get(abstractID3v2Frame.getIdentifier());
            if (v instanceof AbstractID3v2Frame) {
                AbstractID3v2Frame abstractID3v2Frame2 = (AbstractID3v2Frame)this.frameMap.get(abstractID3v2Frame.getIdentifier());
                if (abstractID3v2Frame.getBody() instanceof FrameBodyTDRC) {
                    if (abstractID3v2Frame2.getBody() instanceof FrameBodyTDRC) {
                        logger.finest("Modifying frame in map:" + abstractID3v2Frame.getIdentifier());
                        FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractID3v2Frame2.getBody();
                        FrameBodyTDRC frameBodyTDRC2 = (FrameBodyTDRC)abstractID3v2Frame.getBody();
                        if (frameBodyTDRC2.getOriginalID() == null) {
                            return;
                        }
                        if (frameBodyTDRC2.getOriginalID().equals("TYER")) {
                            frameBodyTDRC.setYear(frameBodyTDRC2.getYear());
                        } else if (frameBodyTDRC2.getOriginalID().equals("TDAT")) {
                            frameBodyTDRC.setDate(frameBodyTDRC2.getDate());
                            frameBodyTDRC.setMonthOnly(frameBodyTDRC2.isMonthOnly());
                        } else if (frameBodyTDRC2.getOriginalID().equals("TIME")) {
                            frameBodyTDRC.setTime(frameBodyTDRC2.getTime());
                            frameBodyTDRC.setHoursOnly(frameBodyTDRC2.isHoursOnly());
                        }
                        frameBodyTDRC.setObjectValue("Text", frameBodyTDRC.getFormattedText());
                    } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyUnsupported) {
                        this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
                    } else {
                        logger.warning("Found duplicate TDRC frame in invalid situation,discarding:" + abstractID3v2Frame.getIdentifier());
                    }
                } else {
                    ArrayList<AbstractID3v2Frame> arrayList = new ArrayList<AbstractID3v2Frame>();
                    arrayList.add(abstractID3v2Frame2);
                    arrayList.add(abstractID3v2Frame);
                    this.frameMap.put(abstractID3v2Frame.getIdentifier(), arrayList);
                }
            } else {
                List list = (List)v;
                list.add(abstractID3v2Frame);
            }
        } else {
            this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
        }
    }

    public ID3v24Tag(ID3v24Tag iD3v24Tag) {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        logger.config("Creating tag from another tag of same type");
        this.copyPrimitives(iD3v24Tag);
        this.copyFrames(iD3v24Tag);
    }

    public ID3v24Tag(AbstractTag abstractTag) {
        block11: {
            block13: {
                Object object;
                ID3v24Frame iD3v24Frame;
                AbstractID3v2FrameBody abstractID3v2FrameBody;
                block12: {
                    this.crcDataFlag = false;
                    this.experimental = false;
                    this.extended = false;
                    this.unsynchronization = false;
                    this.crcData = 0;
                    this.footer = false;
                    this.updateTag = false;
                    this.tagRestriction = false;
                    this.imageEncodingRestriction = 0;
                    this.imageSizeRestriction = 0;
                    this.tagSizeRestriction = 0;
                    this.textEncodingRestriction = 0;
                    this.paddingSize = 0;
                    this.textFieldSizeRestriction = 0;
                    logger.config("Creating tag from a tag of a different version");
                    this.frameMap = new LinkedHashMap();
                    this.encryptedFrameMap = new LinkedHashMap();
                    if (abstractTag == null) break block11;
                    if (abstractTag instanceof ID3v24Tag) {
                        throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                    }
                    if (!(abstractTag instanceof AbstractID3v2Tag)) break block12;
                    this.setLoggingFilename(((AbstractID3v2Tag)abstractTag).getLoggingFilename());
                    this.copyPrimitives((AbstractID3v2Tag)abstractTag);
                    this.copyFrames((AbstractID3v2Tag)abstractTag);
                    break block11;
                }
                if (!(abstractTag instanceof ID3v1Tag)) break block13;
                ID3v1Tag iD3v1Tag = (ID3v1Tag)abstractTag;
                if (iD3v1Tag.title.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTIT2(0, iD3v1Tag.title);
                    iD3v24Frame = new ID3v24Frame("TIT2");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if (iD3v1Tag.artist.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTPE1(0, iD3v1Tag.artist);
                    iD3v24Frame = new ID3v24Frame("TPE1");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if (iD3v1Tag.album.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTALB(0, iD3v1Tag.album);
                    iD3v24Frame = new ID3v24Frame("TALB");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if (iD3v1Tag.year.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTDRC(0, iD3v1Tag.year);
                    iD3v24Frame = new ID3v24Frame("TDRC");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if (iD3v1Tag.comment.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyCOMM(0, "ENG", "", iD3v1Tag.comment);
                    iD3v24Frame = new ID3v24Frame("COMM");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if ((iD3v1Tag.genre & 0xFF) >= 0 && (iD3v1Tag.genre & 0xFF) != 255) {
                    object = iD3v1Tag.genre & 0xFF;
                    String string = "(" + object + ") " + GenreTypes.getInstanceOf().getValueForId((Integer)object);
                    abstractID3v2FrameBody = new FrameBodyTCON(0, string);
                    iD3v24Frame = new ID3v24Frame("TCON");
                    iD3v24Frame.setBody(abstractID3v2FrameBody);
                    this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                }
                if (!(abstractTag instanceof ID3v11Tag)) break block11;
                object = (ID3v11Tag)abstractTag;
                if (((ID3v11Tag)object).track <= 0) break block11;
                abstractID3v2FrameBody = new FrameBodyTRCK(0, Byte.toString(((ID3v11Tag)object).track));
                iD3v24Frame = new ID3v24Frame("TRCK");
                iD3v24Frame.setBody(abstractID3v2FrameBody);
                this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                break block11;
            }
            if (abstractTag instanceof AbstractLyrics3) {
                Lyrics3v2 lyrics3v2 = abstractTag instanceof Lyrics3v2 ? new Lyrics3v2((Lyrics3v2)abstractTag) : new Lyrics3v2(abstractTag);
                Iterator<Lyrics3v2Field> iterator = lyrics3v2.iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field lyrics3v2Field = iterator.next();
                        ID3v24Frame iD3v24Frame = new ID3v24Frame(lyrics3v2Field);
                        this.frameMap.put(iD3v24Frame.getIdentifier(), iD3v24Frame);
                    }
                    catch (InvalidTagException invalidTagException) {
                        logger.warning("Unable to convert Lyrics3 to v24 Frame:Frame Identifier");
                    }
                }
            }
        }
    }

    public ID3v24Tag(ByteBuffer byteBuffer, String string) throws TagException {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.setLoggingFilename(string);
        this.read(byteBuffer);
    }

    public ID3v24Tag(ByteBuffer byteBuffer) throws TagException {
        this(byteBuffer, "");
    }

    @Override
    public String getIdentifier() {
        return "ID3v2.40";
    }

    @Override
    public int getSize() {
        int n = 10;
        if (this.extended) {
            n += TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                n += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                n += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                n += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
        }
        logger.finer("Tag Size is" + (n += super.getSize()));
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v24Tag)) {
            return false;
        }
        ID3v24Tag iD3v24Tag = (ID3v24Tag)object;
        if (this.footer != iD3v24Tag.footer) {
            return false;
        }
        if (this.imageEncodingRestriction != iD3v24Tag.imageEncodingRestriction) {
            return false;
        }
        if (this.imageSizeRestriction != iD3v24Tag.imageSizeRestriction) {
            return false;
        }
        if (this.tagRestriction != iD3v24Tag.tagRestriction) {
            return false;
        }
        if (this.tagSizeRestriction != iD3v24Tag.tagSizeRestriction) {
            return false;
        }
        if (this.textEncodingRestriction != iD3v24Tag.textEncodingRestriction) {
            return false;
        }
        if (this.textFieldSizeRestriction != iD3v24Tag.textFieldSizeRestriction) {
            return false;
        }
        return this.updateTag == iD3v24Tag.updateTag && super.equals(object);
    }

    private void readHeaderFlags(ByteBuffer byteBuffer) throws TagException {
        byte by = byteBuffer.get();
        this.unsynchronization = (by & 0x80) != 0;
        this.extended = (by & 0x40) != 0;
        this.experimental = (by & 0x20) != 0;
        boolean bl = this.footer = (by & 0x10) != 0;
        if ((by & 8) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 8));
        }
        if ((by & 4) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 4));
        }
        if ((by & 2) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 2));
        }
        if ((by & 1) != 0) {
            logger.warning(ErrorMessage.ID3_INVALID_OR_UNKNOWN_FLAG_SET.getMsg(this.getLoggingFilename(), 1));
        }
        if (this.isUnsynchronization()) {
            logger.config(ErrorMessage.ID3_TAG_UNSYNCHRONIZED.getMsg(this.getLoggingFilename()));
        }
        if (this.extended) {
            logger.config(ErrorMessage.ID3_TAG_EXTENDED.getMsg(this.getLoggingFilename()));
        }
        if (this.experimental) {
            logger.config(ErrorMessage.ID3_TAG_EXPERIMENTAL.getMsg(this.getLoggingFilename()));
        }
        if (this.footer) {
            logger.warning(ErrorMessage.ID3_TAG_FOOTER.getMsg(this.getLoggingFilename()));
        }
    }

    private void readExtendedHeader(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        byte[] byArray;
        int n2 = byteBuffer.getInt();
        if (n2 <= TAG_EXT_HEADER_LENGTH) {
            throw new InvalidTagException(ErrorMessage.ID3_EXTENDED_HEADER_SIZE_TOO_SMALL.getMsg(this.getLoggingFilename(), n2));
        }
        byteBuffer.get();
        byte by = byteBuffer.get();
        this.updateTag = (by & 0x40) != 0;
        this.crcDataFlag = (by & 0x20) != 0;
        boolean bl = this.tagRestriction = (by & 0x10) != 0;
        if (this.updateTag) {
            byteBuffer.get();
        }
        if (this.crcDataFlag) {
            byteBuffer.get();
            byArray = new byte[TAG_EXT_HEADER_CRC_DATA_LENGTH];
            byteBuffer.get(byArray, 0, TAG_EXT_HEADER_CRC_DATA_LENGTH);
            this.crcData = 0;
            for (int i = 0; i < TAG_EXT_HEADER_CRC_DATA_LENGTH; ++i) {
                this.crcData <<= 8;
                this.crcData += byArray[i];
            }
        }
        if (this.tagRestriction) {
            byteBuffer.get();
            byArray = new byte[1];
            byteBuffer.get(byArray, 0, 1);
            this.tagSizeRestriction = (byte)((byArray[0] & 0xFFFFFFC0) >> 6);
            this.textEncodingRestriction = (byte)((byArray[0] & 0x20) >> 5);
            this.textFieldSizeRestriction = (byte)((byArray[0] & 0x18) >> 3);
            this.imageEncodingRestriction = (byte)((byArray[0] & 4) >> 2);
            this.imageSizeRestriction = (byte)(byArray[0] & 6);
        }
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(this.getLoggingFilename() + ":" + this.getIdentifier() + " tag not found");
        }
        logger.config(this.getLoggingFilename() + ":" + "Reading ID3v24 tag");
        this.readHeaderFlags(byteBuffer);
        int n = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        logger.config(this.getLoggingFilename() + ":" + "Reading tag from file size set in header is" + n);
        if (this.extended) {
            this.readExtendedHeader(byteBuffer, n);
        }
        this.readFrames(byteBuffer, n);
    }

    protected void readFrames(ByteBuffer byteBuffer, int n) {
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at" + byteBuffer.position());
        this.frameMap = new LinkedHashMap();
        this.encryptedFrameMap = new LinkedHashMap();
        this.fileReadSize = n;
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at:" + byteBuffer.position() + ",frames data size is:" + n);
        while (byteBuffer.position() <= n) {
            try {
                logger.finest(this.getLoggingFilename() + ":" + "looking for next frame at:" + byteBuffer.position());
                ID3v24Frame iD3v24Frame = new ID3v24Frame(byteBuffer, this.getLoggingFilename());
                String string = iD3v24Frame.getIdentifier();
                this.loadFrameIntoMap(string, iD3v24Frame);
            }
            catch (PaddingException paddingException) {
                logger.config(this.getLoggingFilename() + ":Found padding starting at:" + byteBuffer.position());
                break;
            }
            catch (EmptyFrameException emptyFrameException) {
                logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + emptyFrameException.getMessage());
                this.emptyFrameBytes += 10;
            }
            catch (InvalidFrameIdentifierException invalidFrameIdentifierException) {
                logger.config(this.getLoggingFilename() + ":" + "Invalid Frame Identifier:" + invalidFrameIdentifierException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidFrameException invalidFrameException) {
                logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame:" + invalidFrameException.getMessage());
                ++this.invalidFrames;
                break;
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning(this.getLoggingFilename() + ":Corrupt Frame:" + invalidDataTypeException.getMessage());
                ++this.invalidFrames;
            }
        }
    }

    private ByteBuffer writeHeaderToBuffer(int n, int n2) throws IOException {
        this.unsynchronization = false;
        this.extended = false;
        this.experimental = false;
        this.footer = false;
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.put(TAG_ID);
        byteBuffer.put(this.getMajorVersion());
        byteBuffer.put(this.getRevision());
        byte by = 0;
        if (this.isUnsynchronization()) {
            by = (byte)(by | 0x80);
        }
        if (this.extended) {
            by = (byte)(by | 0x40);
        }
        if (this.experimental) {
            by = (byte)(by | 0x20);
        }
        if (this.footer) {
            by = (byte)(by | 0x10);
        }
        byteBuffer.put(by);
        int n3 = 0;
        if (this.extended) {
            n3 += TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                n3 += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                n3 += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                n3 += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
        }
        byteBuffer.put(ID3SyncSafeInteger.valueToBuffer(n + n2 + n3));
        ByteBuffer byteBuffer2 = null;
        if (this.extended) {
            int n4 = TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                n4 += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                n4 += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                n4 += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
            byteBuffer2 = ByteBuffer.allocate(n4);
            byteBuffer2.putInt(n4);
            byteBuffer2.put((byte)TAG_EXT_NUMBER_BYTES_DATA_LENGTH);
            byte by2 = 0;
            if (this.updateTag) {
                by2 = (byte)(by2 | 0x40);
            }
            if (this.crcDataFlag) {
                by2 = (byte)(by2 | 0x20);
            }
            if (this.tagRestriction) {
                by2 = (byte)(by2 | 0x10);
            }
            byteBuffer2.put(by2);
            if (this.updateTag) {
                byteBuffer2.put((byte)0);
            }
            if (this.crcDataFlag) {
                byteBuffer2.put((byte)TAG_EXT_HEADER_CRC_DATA_LENGTH);
                byteBuffer2.put((byte)0);
                byteBuffer2.putInt(this.crcData);
            }
            if (this.tagRestriction) {
                byteBuffer2.put((byte)TAG_EXT_HEADER_RESTRICTION_DATA_LENGTH);
                byteBuffer2.put((byte)0);
            }
        }
        if (byteBuffer2 != null) {
            byteBuffer2.flip();
            byteBuffer.put(byteBuffer2);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void write(File file, long l) throws IOException {
        this.setLoggingFilename(file.getName());
        logger.config("Writing tag to file:" + this.getLoggingFilename());
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        int n = this.calculateTagSize(byArray.length + 10, (int)l);
        int n2 = n - (byArray.length + 10);
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(n2, byArray.length);
        this.writeBufferToFile(file, byteBuffer, byArray, n2, n, l);
    }

    @Override
    public void write(WritableByteChannel writableByteChannel) throws IOException {
        logger.config("Writing tag to channel");
        byte[] byArray = this.writeFramesToBuffer().toByteArray();
        ByteBuffer byteBuffer = this.writeHeaderToBuffer(0, byArray.length);
        writableByteChannel.write(byteBuffer);
        writableByteChannel.write(ByteBuffer.wrap(byArray));
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.isUnsynchronization());
        MP3File.getStructureFormatter().addElement(TYPE_CRCDATA, this.crcData);
        MP3File.getStructureFormatter().addElement(TYPE_EXPERIMENTAL, this.experimental);
        MP3File.getStructureFormatter().addElement(TYPE_EXTENDED, this.extended);
        MP3File.getStructureFormatter().addElement(TYPE_PADDINGSIZE, this.paddingSize);
        MP3File.getStructureFormatter().addElement(TYPE_FOOTER, this.footer);
        MP3File.getStructureFormatter().addElement(TYPE_IMAGEENCODINGRESTRICTION, this.paddingSize);
        MP3File.getStructureFormatter().addElement(TYPE_IMAGESIZERESTRICTION, this.imageSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TAGRESTRICTION, this.tagRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TAGSIZERESTRICTION, this.tagSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TEXTFIELDSIZERESTRICTION, this.textFieldSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TEXTENCODINGRESTRICTION, this.textEncodingRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_UPDATETAG, this.updateTag);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    @Override
    public ID3v24Frame createFrame(String string) {
        return new ID3v24Frame(string);
    }

    public TagField createField(ID3v24FieldKey iD3v24FieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (iD3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v24FieldKey.getFrameId(), iD3v24FieldKey.getSubId()), string);
    }

    public String getFirst(ID3v24FieldKey iD3v24FieldKey) throws KeyNotFoundException {
        if (iD3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        FieldKey fieldKey = ID3v24Frames.getInstanceOf().getGenericKeyFromId3(iD3v24FieldKey);
        if (fieldKey != null) {
            return super.getFirst(fieldKey);
        }
        AbstractID3v2Tag.FrameAndSubId frameAndSubId = new AbstractID3v2Tag.FrameAndSubId(iD3v24FieldKey.getFrameId(), iD3v24FieldKey.getSubId());
        return super.doGetValueAtIndex(frameAndSubId, 0);
    }

    public void deleteField(ID3v24FieldKey iD3v24FieldKey) throws KeyNotFoundException {
        if (iD3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(iD3v24FieldKey.getFrameId(), iD3v24FieldKey.getSubId()));
    }

    @Override
    public void deleteField(String string) {
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(string, null));
    }

    @Override
    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey fieldKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v24FieldKey iD3v24FieldKey = ID3v24Frames.getInstanceOf().getId3KeyFromGenericKey(fieldKey);
        if (iD3v24FieldKey == null) {
            throw new KeyNotFoundException(fieldKey.name());
        }
        return new AbstractID3v2Tag.FrameAndSubId(iD3v24FieldKey.getFrameId(), iD3v24FieldKey.getSubId());
    }

    @Override
    protected ID3Frames getID3Frames() {
        return ID3v24Frames.getInstanceOf();
    }

    @Override
    public Comparator getPreferredFrameOrderComparator() {
        return ID3v24PreferredFrameOrderComparator.getInstanceof();
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> list = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(list.size());
        for (TagField tagField : list) {
            FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)((AbstractID3v2Frame)tagField).getBody();
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setMimeType(frameBodyAPIC.getMimeType());
            artwork.setPictureType(frameBodyAPIC.getPictureType());
            if (frameBodyAPIC.isImageUrl()) {
                artwork.setLinked(true);
                artwork.setImageUrl(frameBodyAPIC.getImageUrl());
            } else {
                artwork.setBinaryData(frameBodyAPIC.getImageData());
            }
            arrayList.add(artwork);
        }
        return arrayList;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        ID3v24Frame iD3v24Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)iD3v24Frame.getBody();
        if (!artwork.isLinked()) {
            frameBodyAPIC.setObjectValue("PictureData", artwork.getBinaryData());
            frameBodyAPIC.setObjectValue("PictureType", artwork.getPictureType());
            frameBodyAPIC.setObjectValue("MIMEType", artwork.getMimeType());
            frameBodyAPIC.setObjectValue("Description", "");
            return iD3v24Frame;
        }
        try {
            frameBodyAPIC.setObjectValue("PictureData", artwork.getImageUrl().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        frameBodyAPIC.setObjectValue("PictureType", artwork.getPictureType());
        frameBodyAPIC.setObjectValue("MIMEType", "-->");
        frameBodyAPIC.setObjectValue("Description", "");
        return iD3v24Frame;
    }

    public TagField createArtworkField(byte[] byArray, String string) {
        ID3v24Frame iD3v24Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)iD3v24Frame.getBody();
        frameBodyAPIC.setObjectValue("PictureData", byArray);
        frameBodyAPIC.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
        frameBodyAPIC.setObjectValue("MIMEType", string);
        frameBodyAPIC.setObjectValue("Description", "");
        return iD3v24Frame;
    }
}

