/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public class ID3v22Frame
extends AbstractID3v2Frame {
    private static Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{2}");
    protected static final int FRAME_ID_SIZE = 3;
    protected static final int FRAME_SIZE_SIZE = 3;
    protected static final int FRAME_HEADER_SIZE = 6;

    public ID3v22Frame() {
    }

    @Override
    protected int getFrameIdSize() {
        return 3;
    }

    @Override
    protected int getFrameSizeSize() {
        return 3;
    }

    @Override
    protected int getFrameHeaderSize() {
        return 6;
    }

    public ID3v22Frame(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ID3v22Frame)) {
            return false;
        }
        ID3v22Frame iD3v22Frame = (ID3v22Frame)object;
        return EqualsUtil.areEqual(this.statusFlags, iD3v22Frame.statusFlags) && EqualsUtil.areEqual(this.encodingFlags, iD3v22Frame.encodingFlags) && super.equals(iD3v22Frame);
    }

    public ID3v22Frame(String string) {
        logger.config("Creating empty frame of type" + string);
        String string2 = string;
        this.identifier = string;
        if (ID3Tags.isID3v22FrameIdentifier(string2) && ID3Tags.forceFrameID22To23(string2) == null && !string2.equals("CRM")) {
            if (string2.equals("TYE") || string2.equals("TIM")) {
                string2 = "TDRC";
            } else if (ID3Tags.isID3v22FrameIdentifier(string2)) {
                string2 = ID3Tags.convertFrameID22To23(string2);
            }
        }
        try {
            Class<?> clazz = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + string2);
            this.frameBody = (AbstractTagFrameBody)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            this.frameBody = new FrameBodyUnsupported(string);
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, instantiationException.getMessage(), instantiationException);
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, illegalAccessException.getMessage(), illegalAccessException);
            throw new RuntimeException(illegalAccessException);
        }
        this.frameBody.setHeader(this);
        logger.config("Created empty frame of type" + this.identifier + "with frame body of" + string2);
    }

    public ID3v22Frame(ID3v22Frame iD3v22Frame) {
        super(iD3v22Frame);
        logger.config("Creating frame from a frame of same version");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createV22FrameFromV23Frame(ID3v23Frame iD3v23Frame) throws InvalidFrameException {
        this.identifier = ID3Tags.convertFrameID23To22(iD3v23Frame.getIdentifier());
        if (this.identifier != null) {
            logger.config("V2:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
            this.frameBody = (AbstractID3v2FrameBody)ID3Tags.copyObject(iD3v23Frame.getBody());
            return;
        } else if (ID3Tags.isID3v23FrameIdentifier(iD3v23Frame.getIdentifier())) {
            this.identifier = ID3Tags.forceFrameID23To22(iD3v23Frame.getIdentifier());
            if (this.identifier == null) throw new InvalidFrameException("Unable to convert v23 frame:" + iD3v23Frame.getIdentifier() + " to a v22 frame");
            logger.config("V2:Force:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
            this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)iD3v23Frame.getBody());
            return;
        } else if (iD3v23Frame.getBody() instanceof FrameBodyDeprecated) {
            if (ID3Tags.isID3v22FrameIdentifier(iD3v23Frame.getIdentifier())) {
                this.frameBody = iD3v23Frame.getBody();
                this.identifier = iD3v23Frame.getIdentifier();
                logger.config("DEPRECATED:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
                return;
            } else {
                this.frameBody = new FrameBodyDeprecated((FrameBodyDeprecated)iD3v23Frame.getBody());
                this.identifier = iD3v23Frame.getIdentifier();
                logger.config("DEPRECATED:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
            }
            return;
        } else {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)iD3v23Frame.getBody());
            this.identifier = iD3v23Frame.getIdentifier();
            logger.config("v2:UNKNOWN:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
        }
    }

    public ID3v22Frame(AbstractID3v2Frame abstractID3v2Frame) throws InvalidFrameException {
        logger.config("Creating frame from a frame of a different version");
        if (abstractID3v2Frame instanceof ID3v22Frame) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (abstractID3v2Frame instanceof ID3v24Frame) {
            ID3v23Frame iD3v23Frame = new ID3v23Frame(abstractID3v2Frame);
            this.createV22FrameFromV23Frame(iD3v23Frame);
        } else if (abstractID3v2Frame instanceof ID3v23Frame) {
            this.createV22FrameFromV23Frame((ID3v23Frame)abstractID3v2Frame);
        }
        this.frameBody.setHeader(this);
        logger.config("Created frame from a frame of a different version");
    }

    public ID3v22Frame(ByteBuffer byteBuffer, String string) throws InvalidFrameException, InvalidDataTypeException {
        this.setLoggingFilename(string);
        this.read(byteBuffer);
    }

    public ID3v22Frame(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        this(byteBuffer, "");
    }

    @Override
    public int getSize() {
        return this.frameBody.getSize() + this.getFrameHeaderSize();
    }

    @Override
    protected boolean isPadding(byte[] byArray) {
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        String string = this.readIdentifier(byteBuffer);
        byte[] byArray = new byte[this.getFrameSizeSize()];
        if (!this.isValidID3v2FrameIdentifier(string)) {
            logger.config("Invalid identifier:" + string);
            byteBuffer.position(byteBuffer.position() - (this.getFrameIdSize() - 1));
            throw new InvalidFrameIdentifierException(this.getLoggingFilename() + ":" + string + ":is not a valid ID3v2.20 frame");
        }
        byteBuffer.get(byArray, 0, this.getFrameSizeSize());
        this.frameSize = this.decodeSize(byArray);
        if (this.frameSize < 0) {
            throw new InvalidFrameException(string + " has invalid size of:" + this.frameSize);
        }
        if (this.frameSize == 0) {
            logger.warning("Empty Frame:" + string);
            throw new EmptyFrameException(string + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining()) {
            logger.warning("Invalid Frame size larger than size before mp3 audio:" + string);
            throw new InvalidFrameException(string + " is invalid frame");
        }
        logger.fine("Frame Size Is:" + this.frameSize);
        String string2 = ID3Tags.convertFrameID22To24(string);
        if (string2 == null && (string2 = ID3Tags.convertFrameID22To23(string)) == null) {
            string2 = ID3Tags.isID3v22FrameIdentifier(string) ? string : "Unsupported";
        }
        logger.fine("Identifier was:" + string + " reading using:" + string2);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(this.frameSize);
        try {
            this.frameBody = this.readBody(string2, byteBuffer2, this.frameSize);
        }
        finally {
            byteBuffer.position(byteBuffer.position() + this.frameSize);
        }
    }

    private int decodeSize(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        int n = bigInteger.intValue();
        if (n < 0) {
            logger.warning("Invalid Frame Size of:" + n + "Decoded from bin:" + Integer.toBinaryString(n) + "Decoded from hex:" + Integer.toHexString(n));
        }
        return n;
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        logger.config("Write Frame to Buffer" + this.getIdentifier());
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getFrameHeaderSize());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(byteArrayOutputStream2);
        byteBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, this.getFrameIdSize());
        this.encodeSize(byteBuffer, this.frameBody.getSize());
        try {
            byteArrayOutputStream.write(byteBuffer.array());
            byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void encodeSize(ByteBuffer byteBuffer, int n) {
        byteBuffer.put((byte)((n & 0xFF0000) >> 16));
        byteBuffer.put((byte)((n & 0xFF00) >> 8));
        byteBuffer.put((byte)(n & 0xFF));
        logger.fine("Frame Size Is Actual:" + n + ":Encoded bin:" + Integer.toBinaryString(n) + ":Encoded Hex" + Integer.toHexString(n));
    }

    public boolean isValidID3v2FrameIdentifier(String string) {
        Matcher matcher = validFrameIdentifier.matcher(string);
        return matcher.matches();
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    @Override
    public boolean isCommon() {
        return ID3v22Frames.getInstanceOf().isCommon(this.getId());
    }

    @Override
    public boolean isBinary() {
        return ID3v22Frames.getInstanceOf().isBinary(this.getId());
    }

    @Override
    public void setEncoding(String string) {
        Integer n = TextEncoding.getInstanceOf().getIdForValue(string);
        if (string != null && n < 2) {
            this.getBody().setTextEncoding(n.byteValue());
        }
    }
}

