/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.tag.datatype.HashMapInterface;
import org.jaudiotagger.tag.datatype.StringFixedLength;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.reference.Languages;

public class StringHashMap
extends StringFixedLength
implements HashMapInterface<String, String> {
    Map<String, String> keyToValue = null;
    Map<String, String> valueToKey = null;
    boolean hasEmptyValue = false;

    public StringHashMap(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody, n);
        if (!string.equals("Language")) {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + string);
        }
        this.valueToKey = Languages.getInstanceOf().getValueToIdMap();
        this.keyToValue = Languages.getInstanceOf().getIdToValueMap();
    }

    public StringHashMap(StringHashMap stringHashMap) {
        super(stringHashMap);
        this.hasEmptyValue = stringHashMap.hasEmptyValue;
        this.keyToValue = stringHashMap.keyToValue;
        this.valueToKey = stringHashMap.valueToKey;
    }

    @Override
    public Map<String, String> getKeyToValue() {
        return this.keyToValue;
    }

    @Override
    public Map<String, String> getValueToKey() {
        return this.valueToKey;
    }

    @Override
    public void setValue(Object object) {
        this.value = object instanceof String ? (object.equals("XXX") ? object.toString() : ((String)object).toLowerCase()) : object;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StringHashMap)) {
            return false;
        }
        StringHashMap stringHashMap = (StringHashMap)object;
        if (this.hasEmptyValue != stringHashMap.hasEmptyValue) {
            return false;
        }
        if (this.keyToValue == null ? stringHashMap.keyToValue != null : !this.keyToValue.equals(stringHashMap.keyToValue)) {
            return false;
        }
        if (this.keyToValue == null ? stringHashMap.keyToValue != null : !this.valueToKey.equals(stringHashMap.valueToKey)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value);
    }

    @Override
    protected String getTextEncodingCharSet() {
        return "ISO-8859-1";
    }
}

