/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class Lyrics3Image
extends AbstractDataType {
    private Lyrics3TimeStamp time = null;
    private String description = "";
    private String filename = "";

    public Lyrics3Image(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public Lyrics3Image(Lyrics3Image lyrics3Image) {
        super(lyrics3Image);
        this.time = new Lyrics3TimeStamp(lyrics3Image.time);
        this.description = lyrics3Image.description;
        this.filename = lyrics3Image.filename;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getSize() {
        int n = this.filename.length() + 2 + this.description.length() + 2;
        if (this.time != null) {
            n += this.time.getSize();
        }
        return n;
    }

    public void setTimeStamp(Lyrics3TimeStamp lyrics3TimeStamp) {
        this.time = lyrics3TimeStamp;
    }

    public Lyrics3TimeStamp getTimeStamp() {
        return this.time;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Lyrics3Image)) {
            return false;
        }
        Lyrics3Image lyrics3Image = (Lyrics3Image)object;
        if (!this.description.equals(lyrics3Image.description)) {
            return false;
        }
        if (!this.filename.equals(lyrics3Image.filename)) {
            return false;
        }
        if (this.time == null ? lyrics3Image.time != null : !this.time.equals(lyrics3Image.time)) {
            return false;
        }
        return super.equals(object);
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image string is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        if (string != null) {
            int n2 = string.indexOf("||", n);
            this.filename = string.substring(n, n2);
            n = n2 + 2;
            n2 = string.indexOf("||", n);
            this.description = string.substring(n, n2);
            n = n2 + 2;
            String string2 = string.substring(n);
            if (string2.length() == 7) {
                this.time = new Lyrics3TimeStamp("Time Stamp");
                this.time.readString(string2);
            }
        }
    }

    public String toString() {
        String string = "filename = " + this.filename + ", description = " + this.description;
        if (this.time != null) {
            string = string + ", timestamp = " + this.time.toString();
        }
        return string + "\n";
    }

    public String writeString() {
        String string = this.filename == null ? "||" : this.filename + "||";
        string = this.description == null ? string + "||" : string + this.description + "||";
        if (this.time != null) {
            string = string + this.time.writeString();
        }
        return string;
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        this.readString(byArray.toString(), n);
    }

    @Override
    public byte[] writeByteArray() {
        return Utils.getDefaultBytes(this.writeString(), "ISO-8859-1");
    }
}

