/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.util;

public class WavFormatHeader {
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private boolean isValid = false;
    private int format;
    private int channels;
    private int sampleRate;
    private int bytesPerSecond;
    private int bitsPerSample;
    private int validBitsPerSample;
    private int channelMask;
    private int subFormat;

    public WavFormatHeader(byte[] byArray) {
        String string = new String(byArray, 0, 3);
        this.format = this.u(byArray[9]) * 256 + this.u(byArray[8]);
        if (string.equals("fmt") && (this.format == 1 || this.format == 65534)) {
            this.channels = byArray[10];
            this.sampleRate = this.u(byArray[15]) * 0x1000000 + this.u(byArray[14]) * 65536 + this.u(byArray[13]) * 256 + this.u(byArray[12]);
            this.bytesPerSecond = this.u(byArray[19]) * 0x1000000 + this.u(byArray[18]) * 65536 + this.u(byArray[17]) * 256 + this.u(byArray[16]);
            this.bitsPerSample = this.u(byArray[22]);
            if (this.format == 65534 && this.u(byArray[24]) == 22) {
                this.validBitsPerSample = this.u(byArray[26]);
                this.channelMask = this.u(byArray[31]) * 0x1000000 + this.u(byArray[20]) * 65536 + this.u(byArray[29]) * 256 + this.u(byArray[28]);
                this.subFormat = this.u(byArray[33]) * 256 + this.u(byArray[32]);
            }
            this.isValid = true;
        }
    }

    public boolean isExtensible() {
        return this.format == 65534;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public int getSubFormat() {
        return this.subFormat;
    }

    public int getValidBitsPerSample() {
        return this.validBitsPerSample;
    }

    public int getChannelNumber() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.sampleRate;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public String toString() {
        String string = "RIFF-WAVE Header:\n";
        string = string + "Is valid?: " + this.isValid;
        return string;
    }
}

