/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.ogg.OggVorbisCommentTagCreator;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggCRCFactory;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggVorbisCommentTagCreator tc = new OggVorbisCommentTagCreator();
    private OggVorbisTagReader reader = new OggVorbisTagReader();

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotReadException, CannotWriteException {
        try {
            this.reader.read(randomAccessFile);
        }
        catch (CannotReadException cannotReadException) {
            this.write(VorbisCommentTag.createNewTag(), randomAccessFile, randomAccessFile2);
            return;
        }
        VorbisCommentTag vorbisCommentTag = VorbisCommentTag.createNewTag();
        randomAccessFile.seek(0L);
        this.write(vorbisCommentTag, randomAccessFile, randomAccessFile2);
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotReadException, CannotWriteException, IOException {
        logger.config("Starting to write file:");
        logger.fine("Read 1st Page:identificationHeader:");
        OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
        randomAccessFile.seek(oggPageHeader.getStartByte());
        randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), 0L, oggPageHeader.getPageLength() + 27 + oggPageHeader.getSegmentTable().length);
        randomAccessFile2.skipBytes(oggPageHeader.getPageLength() + 27 + oggPageHeader.getSegmentTable().length);
        logger.fine("Written identificationHeader:");
        OggPageHeader oggPageHeader2 = OggPageHeader.read(randomAccessFile);
        long l = randomAccessFile.getFilePointer();
        logger.fine("Read 2nd Page:comment and setup and possibly audio:Header finishes at file position:" + l);
        randomAccessFile.seek(0L);
        OggVorbisTagReader.OggVorbisHeaderSizes oggVorbisHeaderSizes = this.reader.readOggVorbisHeaderSizes(randomAccessFile);
        ByteBuffer byteBuffer = this.tc.convert(tag);
        int n = byteBuffer.capacity();
        int n2 = oggVorbisHeaderSizes.getSetupHeaderSize() + n + oggVorbisHeaderSizes.getExtraPacketDataSize();
        logger.fine("Old 2nd Page no of packets: " + oggPageHeader2.getPacketList().size());
        logger.fine("Old 2nd Page size: " + oggPageHeader2.getPageLength());
        logger.fine("Old last packet incomplete: " + oggPageHeader2.isLastPacketIncomplete());
        logger.fine("Setup Header Size: " + oggVorbisHeaderSizes.getSetupHeaderSize());
        logger.fine("Extra Packets: " + oggVorbisHeaderSizes.getExtraPacketList().size());
        logger.fine("Extra Packet Data Size: " + oggVorbisHeaderSizes.getExtraPacketDataSize());
        logger.fine("Old comment: " + oggVorbisHeaderSizes.getCommentHeaderSize());
        logger.fine("New comment: " + n);
        logger.fine("New Page Data Size: " + n2);
        if (this.isCommentAndSetupHeaderFitsOnASinglePage(n, oggVorbisHeaderSizes.getSetupHeaderSize(), oggVorbisHeaderSizes.getExtraPacketList())) {
            if (oggPageHeader2.getPageLength() < 65025 && (oggPageHeader2.getPacketList().size() == 2 && !oggPageHeader2.isLastPacketIncomplete() || oggPageHeader2.getPacketList().size() > 2)) {
                logger.fine("Header and Setup remain on single page:");
                this.replaceSecondPageOnly(oggVorbisHeaderSizes, n, n2, oggPageHeader2, byteBuffer, l, randomAccessFile, randomAccessFile2);
            } else {
                logger.fine("Header and Setup now on single page:");
                this.replaceSecondPageAndRenumberPageSeqs(oggVorbisHeaderSizes, n, n2, oggPageHeader2, byteBuffer, randomAccessFile, randomAccessFile2);
            }
        } else {
            logger.fine("Header and Setup with shift audio:");
            this.replacePagesAndRenumberPageSeqs(oggVorbisHeaderSizes, n, oggPageHeader2, byteBuffer, randomAccessFile, randomAccessFile2);
        }
    }

    private void calculateChecksumOverPage(ByteBuffer byteBuffer) {
        byteBuffer.putInt(22, 0);
        byte[] byArray = OggCRCFactory.computeCRC(byteBuffer.array());
        for (int i = 0; i < byArray.length; ++i) {
            byteBuffer.put(22 + i, byArray[i]);
        }
        byteBuffer.rewind();
    }

    private ByteBuffer startCreateBasicSecondPage(OggVorbisTagReader.OggVorbisHeaderSizes oggVorbisHeaderSizes, int n, int n2, OggPageHeader oggPageHeader, ByteBuffer byteBuffer) throws IOException {
        logger.fine("WriteOgg Type 1");
        byte[] byArray = this.createSegmentTable(n, oggVorbisHeaderSizes.getSetupHeaderSize(), oggVorbisHeaderSizes.getExtraPacketList());
        int n3 = 27 + byArray.length;
        logger.fine("New second page header length:" + n3);
        logger.fine("No of segments:" + byArray.length);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2 + n3);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(oggPageHeader.getRawHeaderData(), 0, 26);
        byteBuffer2.put((byte)byArray.length);
        for (byte by : byArray) {
            byteBuffer2.put(by);
        }
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    private void replaceSecondPageOnly(OggVorbisTagReader.OggVorbisHeaderSizes oggVorbisHeaderSizes, int n, int n2, OggPageHeader oggPageHeader, ByteBuffer byteBuffer, long l, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        logger.fine("WriteOgg Type 1");
        ByteBuffer byteBuffer2 = this.startCreateBasicSecondPage(oggVorbisHeaderSizes, n, n2, oggPageHeader, byteBuffer);
        randomAccessFile.seek(l);
        randomAccessFile.skipBytes(oggVorbisHeaderSizes.getCommentHeaderSize());
        randomAccessFile.getChannel().read(byteBuffer2);
        this.calculateChecksumOverPage(byteBuffer2);
        randomAccessFile2.getChannel().write(byteBuffer2);
        randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), randomAccessFile2.getFilePointer(), randomAccessFile.length() - randomAccessFile.getFilePointer());
    }

    private void replaceSecondPageAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes oggVorbisHeaderSizes, int n, int n2, OggPageHeader oggPageHeader, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotReadException, CannotWriteException {
        logger.fine("WriteOgg Type 2");
        ByteBuffer byteBuffer2 = this.startCreateBasicSecondPage(oggVorbisHeaderSizes, n, n2, oggPageHeader, byteBuffer);
        int n3 = oggPageHeader.getPageSequence();
        byte[] byArray = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(oggVorbisHeaderSizes.getSetupHeaderStartPosition(), randomAccessFile);
        logger.finest(byArray.length + ":" + byteBuffer2.position() + ":" + byteBuffer2.capacity());
        byteBuffer2.put(byArray);
        this.calculateChecksumOverPage(byteBuffer2);
        randomAccessFile2.getChannel().write(byteBuffer2);
        this.writeRemainingPages(n3, randomAccessFile, randomAccessFile2);
    }

    /*
     * WARNING - void declaration
     */
    private void replacePagesAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes oggVorbisHeaderSizes, int n, OggPageHeader oggPageHeader, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotReadException, CannotWriteException {
        Object object;
        Object object2;
        int n2;
        byte[] byArray;
        int n3;
        int n4 = oggPageHeader.getPageSequence();
        int n5 = n / 65025;
        logger.config("Comment requires:" + n5 + " complete pages");
        int n6 = 0;
        if (n5 > 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                byArray = this.createSegments(65025, false);
                n2 = 27 + byArray.length;
                object2 = ByteBuffer.allocate(n2 + 65025);
                ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
                ((ByteBuffer)object2).put(oggPageHeader.getRawHeaderData(), 0, 26);
                ((ByteBuffer)object2).put((byte)byArray.length);
                for (byte n7 : byArray) {
                    ((ByteBuffer)object2).put(n7);
                }
                object = byteBuffer.slice();
                ((ByteBuffer)object).limit(65025);
                ((ByteBuffer)object2).put((ByteBuffer)object);
                ((ByteBuffer)object2).putInt(18, n4);
                ++n4;
                if (n3 != 0) {
                    ((ByteBuffer)object2).put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
                }
                this.calculateChecksumOverPage((ByteBuffer)object2);
                randomAccessFile2.getChannel().write((ByteBuffer)object2);
                byteBuffer.position(n6 += 65025);
            }
        }
        n3 = n % 65025;
        logger.fine("Last comment packet size:" + n3);
        if (!this.isCommentAndSetupHeaderFitsOnASinglePage(n3, oggVorbisHeaderSizes.getSetupHeaderSize(), oggVorbisHeaderSizes.getExtraPacketList())) {
            void var17_23;
            logger.fine("WriteOgg Type 3");
            byArray = this.createSegments(n3, true);
            n2 = 27 + byArray.length;
            object2 = ByteBuffer.allocate(n3 + n2);
            ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object2).put(oggPageHeader.getRawHeaderData(), 0, 26);
            ((ByteBuffer)object2).put((byte)byArray.length);
            for (byte by : (Object)byArray) {
                ((ByteBuffer)object2).put(by);
            }
            byteBuffer.position(n6);
            ((ByteBuffer)object2).put(byteBuffer.slice());
            ((ByteBuffer)object2).putInt(18, n4);
            if (n5 > 0) {
                ((ByteBuffer)object2).put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            }
            logger.fine("Writing Last Comment Page " + n4 + " to file");
            ++n4;
            this.calculateChecksumOverPage((ByteBuffer)object2);
            randomAccessFile2.getChannel().write((ByteBuffer)object2);
            byArray = this.createSegmentTable(oggVorbisHeaderSizes.getSetupHeaderSize(), oggVorbisHeaderSizes.getExtraPacketList());
            n2 = 27 + byArray.length;
            object2 = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(oggVorbisHeaderSizes.getSetupHeaderStartPosition(), randomAccessFile);
            object = ByteBuffer.allocate(((Object)object2).length + n2);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object).put(oggPageHeader.getRawHeaderData(), 0, 26);
            ((ByteBuffer)object).put((byte)byArray.length);
            byte[] byArray2 = byArray;
            int n7 = byArray2.length;
            boolean bl = false;
            while (var17_23 < n7) {
                byte by = byArray2[var17_23];
                ((ByteBuffer)object).put(by);
                ++var17_23;
            }
            ((ByteBuffer)object).put((byte[])object2);
            ((ByteBuffer)object).putInt(18, n4);
            logger.fine("Writing Setup Header and packets Page " + n4 + " to file");
            this.calculateChecksumOverPage((ByteBuffer)object);
            randomAccessFile2.getChannel().write((ByteBuffer)object);
        } else {
            logger.fine("WriteOgg Type 4");
            int n8 = oggVorbisHeaderSizes.getSetupHeaderSize() + n3 + oggVorbisHeaderSizes.getExtraPacketDataSize();
            byteBuffer.position(n6);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            object2 = this.startCreateBasicSecondPage(oggVorbisHeaderSizes, n3, n8, oggPageHeader, byteBuffer2);
            randomAccessFile.seek(oggVorbisHeaderSizes.getSetupHeaderStartPosition());
            object = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(oggVorbisHeaderSizes.getSetupHeaderStartPosition(), randomAccessFile);
            ((ByteBuffer)object2).put((byte[])object);
            ((ByteBuffer)object2).putInt(18, n4);
            ((ByteBuffer)object2).put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            this.calculateChecksumOverPage((ByteBuffer)object2);
            randomAccessFile2.getChannel().write((ByteBuffer)object2);
        }
        this.writeRemainingPages(n4, randomAccessFile, randomAccessFile2);
    }

    public void writeRemainingPages(int n, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotReadException, CannotWriteException {
        long l = randomAccessFile.getFilePointer();
        long l2 = randomAccessFile2.getFilePointer();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(randomAccessFile.length() - randomAccessFile.getFilePointer()));
        ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)(randomAccessFile.length() - randomAccessFile.getFilePointer()));
        randomAccessFile.getChannel().read(byteBuffer);
        byteBuffer.rewind();
        while (byteBuffer.hasRemaining()) {
            OggPageHeader oggPageHeader = OggPageHeader.read(byteBuffer);
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(oggPageHeader.getRawHeaderData().length + oggPageHeader.getPageLength());
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer3.put(oggPageHeader.getRawHeaderData());
            ByteBuffer byteBuffer4 = byteBuffer.slice();
            byteBuffer4.limit(oggPageHeader.getPageLength());
            byteBuffer3.put(byteBuffer4);
            byteBuffer3.putInt(18, ++n);
            this.calculateChecksumOverPage(byteBuffer3);
            byteBuffer.position(byteBuffer.position() + oggPageHeader.getPageLength());
            byteBuffer3.rewind();
            byteBuffer2.put(byteBuffer3);
        }
        byteBuffer2.rewind();
        randomAccessFile2.getChannel().write(byteBuffer2);
        if (randomAccessFile.length() - l != randomAccessFile2.length() - l2) {
            throw new CannotWriteException("File written counts don't match, file not written");
        }
    }

    public void writeRemainingPagesOld(int n, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotReadException, CannotWriteException {
        long l = randomAccessFile.getFilePointer();
        long l2 = randomAccessFile2.getFilePointer();
        logger.fine("Writing audio, audio starts in original file at :" + l + ":Written to:" + l2);
        while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
            logger.fine("Reading Ogg Page");
            OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
            ByteBuffer byteBuffer = ByteBuffer.allocate(oggPageHeader.getRawHeaderData().length + oggPageHeader.getPageLength());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(oggPageHeader.getRawHeaderData());
            randomAccessFile.getChannel().read(byteBuffer);
            byteBuffer.putInt(18, ++n);
            this.calculateChecksumOverPage(byteBuffer);
            randomAccessFile2.getChannel().write(byteBuffer);
        }
        if (randomAccessFile.length() - l != randomAccessFile2.length() - l2) {
            throw new CannotWriteException("File written counts don't match, file not written");
        }
    }

    private byte[] createSegmentTable(int n, int n2, List<OggPageHeader.PacketStartAndLength> list) {
        logger.finest("Create SegmentTable CommentLength:" + n + ":SetupHeaderLength:" + n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n2 == 0) {
            byte[] byArray = this.createSegments(n, false);
            return byArray;
        }
        byte[] byArray = this.createSegments(n, true);
        byte[] byArray2 = list.size() > 0 ? this.createSegments(n2, true) : this.createSegments(n2, false);
        logger.finest("Created " + byArray.length + " segments for header");
        logger.finest("Created " + byArray2.length + " segments for setup");
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(byArray2);
            if (list.size() > 0) {
                logger.finer("Creating segments for " + list.size() + " packets");
                for (OggPageHeader.PacketStartAndLength packetStartAndLength : list) {
                    byte[] byArray3 = this.createSegments(packetStartAndLength.getLength(), false);
                    byteArrayOutputStream.write(byArray3);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create segment table:" + iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] createSegmentTable(int n, List<OggPageHeader.PacketStartAndLength> list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.createSegments(n, true);
        try {
            byteArrayOutputStream.write(byArray);
            if (list.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packetStartAndLength : list) {
                    byte[] byArray2 = this.createSegments(packetStartAndLength.getLength(), false);
                    byteArrayOutputStream.write(byArray2);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create segment table:" + iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] createSegments(int n, boolean bl) {
        int n2;
        logger.finest("Create Segments for length:" + n + ":QuitStream:" + bl);
        if (n == 0) {
            byte[] byArray = new byte[]{0};
            return byArray;
        }
        byte[] byArray = new byte[n / 255 + (n % 255 == 0 && !bl ? 0 : 1)];
        for (n2 = 0; n2 < byArray.length - 1; ++n2) {
            byArray[n2] = -1;
        }
        byArray[byArray.length - 1] = (byte)(n - n2 * 255);
        return byArray;
    }

    private boolean isCommentAndSetupHeaderFitsOnASinglePage(int n, int n2, List<OggPageHeader.PacketStartAndLength> list) {
        int n3 = 0;
        if (n == 0) {
            ++n3;
        } else {
            n3 = n / 255 + 1;
            if (n % 255 == 0) {
                ++n3;
            }
        }
        logger.finest("Require:" + n3 + " segments for comment");
        if (n2 == 0) {
            ++n3;
        } else {
            n3 += n2 / 255 + 1;
            if (n2 % 255 == 0) {
                ++n3;
            }
        }
        logger.finest("Require:" + n3 + " segments for comment plus setup");
        for (OggPageHeader.PacketStartAndLength packetStartAndLength : list) {
            if (packetStartAndLength.getLength() == 0) {
                ++n3;
                continue;
            }
            n3 += packetStartAndLength.getLength() / 255 + 1;
            if (packetStartAndLength.getLength() % 255 != 0) continue;
            ++n3;
        }
        logger.finest("Total No Of Segment If New Comment And Header Put On One Page:" + n3);
        return n3 <= 255;
    }
}

