/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggInfoReader;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;

public class OggFileReader
extends AudioFileReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggInfoReader ir = new OggInfoReader();
    private OggVorbisTagReader vtr = new OggVorbisTagReader();

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        return this.ir.read(randomAccessFile);
    }

    @Override
    protected Tag getTag(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        return this.vtr.read(randomAccessFile);
    }

    public OggPageHeader readOggPageHeader(RandomAccessFile randomAccessFile, int n) throws CannotReadException, IOException {
        OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
        while (n > 0) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)oggPageHeader.getPageLength());
            oggPageHeader = OggPageHeader.read(randomAccessFile);
            --n;
        }
        return oggPageHeader;
    }

    public void summarizeOggPageHeaders(File file) throws CannotReadException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
            System.out.println("pageHeader starts at absolute file position:" + randomAccessFile.getFilePointer());
            OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
            System.out.println("pageHeader finishes at absolute file position:" + randomAccessFile.getFilePointer());
            System.out.println(oggPageHeader + "\n");
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)oggPageHeader.getPageLength());
        }
        System.out.println("Raf File Pointer at:" + randomAccessFile.getFilePointer() + "File Size is:" + randomAccessFile.length());
        randomAccessFile.close();
    }

    public void shortSummarizeOggPageHeaders(File file) throws CannotReadException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n = 0;
        while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
            System.out.println("pageHeader starts at absolute file position:" + randomAccessFile.getFilePointer());
            OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
            System.out.println("pageHeader finishes at absolute file position:" + randomAccessFile.getFilePointer());
            System.out.println(oggPageHeader + "\n");
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)oggPageHeader.getPageLength());
            if (++n < 5) continue;
            break;
        }
        System.out.println("Raf File Pointer at:" + randomAccessFile.getFilePointer() + "File Size is:" + randomAccessFile.length());
        randomAccessFile.close();
    }
}

