/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.LameFrame;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;

public class VbriFrame {
    private static final int VBRI_OFFSET = 36;
    private static final int VBRI_HEADER_BUFFER_SIZE = 120;
    private static final int VBRI_IDENTIFIER_BUFFER_SIZE = 4;
    private static final int VBRI_DELAY_BUFFER_SIZE = 2;
    private static final int VBRI_QUALITY_BUFFER_SIZE = 2;
    private static final int VBRI_AUDIOSIZE_BUFFER_SIZE = 4;
    private static final int VBRI_FRAMECOUNT_BUFFER_SIZE = 4;
    private static final int VBRI_TOC_ENTRY_BUFFER_SIZE = 2;
    public static final int MAX_BUFFER_SIZE_NEEDED_TO_READ_VBRI = 156;
    private static final int BYTE_1 = 0;
    private static final int BYTE_2 = 1;
    private static final int BYTE_3 = 2;
    private static final int BYTE_4 = 3;
    private static final byte[] VBRI_VBR_ID = new byte[]{86, 66, 82, 73};
    private ByteBuffer header;
    private boolean vbr = false;
    private int frameCount = -1;
    private int audioSize = -1;
    private LameFrame lameFrame;

    private VbriFrame(ByteBuffer byteBuffer) {
        this.header = byteBuffer;
        byteBuffer.rewind();
        byteBuffer.position(10);
        this.setAudioSize();
        this.setFrameCount();
    }

    private void setAudioSize() {
        byte[] byArray = new byte[4];
        this.header.get(byArray);
        boolean bl = true;
        this.audioSize = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    private void setFrameCount() {
        byte[] byArray = new byte[4];
        this.header.get(byArray);
        boolean bl = true;
        this.frameCount = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    public final int getAudioSize() {
        return this.audioSize;
    }

    public static VbriFrame parseVBRIFrame(ByteBuffer byteBuffer) throws InvalidAudioFrameException {
        VbriFrame vbriFrame = new VbriFrame(byteBuffer);
        return vbriFrame;
    }

    public static ByteBuffer isVbriFrame(ByteBuffer byteBuffer, MPEGFrameHeader mPEGFrameHeader) {
        int n = byteBuffer.position();
        MP3File.logger.finest("Checking VBRI Frame at" + n);
        byteBuffer.position(n + 36);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n);
        byte[] byArray = new byte[4];
        byteBuffer2.get(byArray);
        if (!Arrays.equals(byArray, VBRI_VBR_ID)) {
            return null;
        }
        MP3File.logger.finest("Found VBRI Frame");
        return byteBuffer2;
    }

    public final boolean isVbr() {
        return true;
    }

    public String getEncoder() {
        return "Fraunhofer";
    }

    public String toString() {
        return "VBRIheader vbr:" + this.vbr + " frameCount:" + this.frameCount + " audioFileSize:" + this.audioSize + " encoder:" + this.getEncoder();
    }
}

