/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.HashMap;
import java.util.Set;
import org.jaudiotagger.audio.AudioHeader;

public class GenericAudioHeader
implements AudioHeader {
    public static final String FIELD_BITRATE = "BITRATE";
    public static final String FIELD_CHANNEL = "CHANNB";
    public static final String FIELD_INFOS = "INFOS";
    public static final String FIELD_LENGTH = "LENGTH";
    public static final String FIELD_SAMPLERATE = "SAMPLING";
    public static final String FIELD_BITSPERSAMPLE = "BITSPERSAMPLE";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_VBR = "VBR";
    private boolean isLossless = false;
    protected HashMap<String, Object> content = new HashMap(6);

    public GenericAudioHeader() {
        this.content.put(FIELD_BITRATE, -1);
        this.content.put(FIELD_CHANNEL, -1);
        this.content.put(FIELD_TYPE, "");
        this.content.put(FIELD_INFOS, "");
        this.content.put(FIELD_SAMPLERATE, -1);
        this.content.put(FIELD_BITSPERSAMPLE, -1);
        this.content.put(FIELD_LENGTH, Float.valueOf(-1.0f));
        this.content.put(FIELD_VBR, true);
    }

    @Override
    public String getBitRate() {
        return this.content.get(FIELD_BITRATE).toString();
    }

    @Override
    public long getBitRateAsNumber() {
        return ((Integer)this.content.get(FIELD_BITRATE)).longValue();
    }

    public int getChannelNumber() {
        return (Integer)this.content.get(FIELD_CHANNEL);
    }

    @Override
    public String getChannels() {
        return String.valueOf(this.getChannelNumber());
    }

    @Override
    public String getEncodingType() {
        return (String)this.content.get(FIELD_TYPE);
    }

    @Override
    public String getFormat() {
        return (String)this.content.get(FIELD_TYPE);
    }

    public String getExtraEncodingInfos() {
        return (String)this.content.get(FIELD_INFOS);
    }

    @Override
    public int getTrackLength() {
        return (int)this.getPreciseLength();
    }

    public float getPreciseLength() {
        return ((Float)this.content.get(FIELD_LENGTH)).floatValue();
    }

    @Override
    public String getSampleRate() {
        return this.content.get(FIELD_SAMPLERATE).toString();
    }

    @Override
    public int getSampleRateAsNumber() {
        return (Integer)this.content.get(FIELD_SAMPLERATE);
    }

    @Override
    public int getBitsPerSample() {
        return (Integer)this.content.get(FIELD_BITSPERSAMPLE);
    }

    @Override
    public boolean isVariableBitRate() {
        return (Boolean)this.content.get(FIELD_VBR);
    }

    @Override
    public boolean isLossless() {
        return this.isLossless;
    }

    public void setBitrate(int n) {
        this.content.put(FIELD_BITRATE, n);
    }

    public void setChannelNumber(int n) {
        this.content.put(FIELD_CHANNEL, n);
    }

    public void setEncodingType(String string) {
        this.content.put(FIELD_TYPE, string);
    }

    public void setExtraEncodingInfos(String string) {
        this.content.put(FIELD_INFOS, string);
    }

    public void setLength(int n) {
        this.content.put(FIELD_LENGTH, Float.valueOf(n));
    }

    public void setPreciseLength(float f) {
        this.content.put(FIELD_LENGTH, Float.valueOf(f));
    }

    public void setSamplingRate(int n) {
        this.content.put(FIELD_SAMPLERATE, n);
    }

    public void setBitsPerSample(int n) {
        this.content.put(FIELD_BITSPERSAMPLE, n);
    }

    public void setVariableBitRate(boolean bl) {
        this.content.put(FIELD_VBR, bl);
    }

    public void setLossless(boolean bl) {
        this.isLossless = bl;
    }

    public void setExtra(String string, Object object) {
        this.content.put(string, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("Encoding infos content:\n");
        Set<String> set = this.content.keySet();
        for (String string : set) {
            Object object = this.content.get(string);
            stringBuffer.append("\t");
            stringBuffer.append(string);
            stringBuffer.append(" : ");
            stringBuffer.append(object);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }
}

