/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public abstract class AudioFileReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private static final int MINIMUM_SIZE_FOR_VALID_AUDIO_FILE = 150;

    protected abstract GenericAudioHeader getEncodingInfo(RandomAccessFile var1) throws CannotReadException, IOException;

    protected abstract Tag getTag(RandomAccessFile var1) throws CannotReadException, IOException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioFile read(File file) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        AudioFile audioFile;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(ErrorMessage.GENERAL_READ.getMsg(file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(file.getAbsolutePath()));
        }
        if (file.length() <= 150L) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(file.getAbsolutePath()));
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(0L);
            GenericAudioHeader genericAudioHeader = this.getEncodingInfo(randomAccessFile);
            randomAccessFile.seek(0L);
            Tag tag = this.getTag(randomAccessFile);
            audioFile = new AudioFile(file, (AudioHeader)genericAudioHeader, tag);
        }
        catch (CannotReadException cannotReadException) {
            try {
                throw cannotReadException;
                catch (Exception exception) {
                    logger.log(Level.SEVERE, ErrorMessage.GENERAL_READ.getMsg(file.getAbsolutePath()), exception);
                    throw new CannotReadException(file.getAbsolutePath() + ":" + exception.getMessage(), exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessFile == null) throw throwable;
                    randomAccessFile.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, ErrorMessage.GENERAL_READ_FAILED_UNABLE_TO_CLOSE_RANDOM_ACCESS_FILE.getMsg(file.getAbsolutePath()));
                }
                throw throwable;
            }
        }
        try {
            if (randomAccessFile == null) return audioFile;
            randomAccessFile.close();
            return audioFile;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, ErrorMessage.GENERAL_READ_FAILED_UNABLE_TO_CLOSE_RANDOM_ACCESS_FILE.getMsg(file.getAbsolutePath()));
        }
        return audioFile;
    }
}

