/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacAudioHeader;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;

public class FlacInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private static final int NO_OF_BITS_IN_BYTE = 8;
    private static final int KILOBYTES_TO_BYTES_MULTIPLIER = 1000;

    public FlacAudioHeader read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Object object;
        FlacStreamReader flacStreamReader = new FlacStreamReader(randomAccessFile);
        flacStreamReader.findStream();
        MetadataBlockDataStreamInfo metadataBlockDataStreamInfo = null;
        boolean bl = false;
        while (!bl) {
            object = MetadataBlockHeader.readHeader(randomAccessFile);
            if (((MetadataBlockHeader)object).getBlockType() == BlockType.STREAMINFO) {
                metadataBlockDataStreamInfo = new MetadataBlockDataStreamInfo((MetadataBlockHeader)object, randomAccessFile);
                if (!metadataBlockDataStreamInfo.isValid()) {
                    throw new CannotReadException("FLAC StreamInfo not valid");
                }
            } else {
                randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)((MetadataBlockHeader)object).getDataLength());
            }
            bl = ((MetadataBlockHeader)object).isLastBlock();
            object = null;
        }
        if (metadataBlockDataStreamInfo == null) {
            throw new CannotReadException("Unable to find Flac StreamInfo");
        }
        object = new FlacAudioHeader();
        ((GenericAudioHeader)object).setLength(metadataBlockDataStreamInfo.getSongLength());
        ((GenericAudioHeader)object).setPreciseLength(metadataBlockDataStreamInfo.getPreciseLength());
        ((GenericAudioHeader)object).setChannelNumber(metadataBlockDataStreamInfo.getChannelNumber());
        ((GenericAudioHeader)object).setSamplingRate(metadataBlockDataStreamInfo.getSamplingRate());
        ((GenericAudioHeader)object).setBitsPerSample(metadataBlockDataStreamInfo.getBitsPerSample());
        ((GenericAudioHeader)object).setEncodingType(metadataBlockDataStreamInfo.getEncodingType());
        ((GenericAudioHeader)object).setExtraEncodingInfos("");
        ((GenericAudioHeader)object).setBitrate(this.computeBitrate(metadataBlockDataStreamInfo.getPreciseLength(), randomAccessFile.length() - randomAccessFile.getFilePointer()));
        ((GenericAudioHeader)object).setLossless(true);
        ((FlacAudioHeader)object).setMd5(metadataBlockDataStreamInfo.getMD5Signature());
        return object;
    }

    private int computeBitrate(float f, long l) {
        return (int)((float)(l / 1000L * 8L) / f);
    }

    public int countMetaBlocks(File file) throws CannotReadException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FlacStreamReader flacStreamReader = new FlacStreamReader(randomAccessFile);
        flacStreamReader.findStream();
        boolean bl = false;
        int n = 0;
        while (!bl) {
            MetadataBlockHeader metadataBlockHeader = MetadataBlockHeader.readHeader(randomAccessFile);
            logger.config("Found block:" + (Object)((Object)metadataBlockHeader.getBlockType()));
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
            bl = metadataBlockHeader.isLastBlock();
            metadataBlockHeader = null;
            ++n;
        }
        randomAccessFile.close();
        return n;
    }
}

