/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

class EncodingChunkReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_ENCODING};

    protected EncodingChunkReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        BigInteger bigInteger = Utils.readBig64(inputStream);
        EncodingChunk encodingChunk = new EncodingChunk(bigInteger);
        int n = 24;
        inputStream.skip(20L);
        n += 20;
        int n2 = Utils.readUINT16(inputStream);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            String string = Utils.readCharacterSizedString(inputStream);
            encodingChunk.addString(string);
            n += 4 + 2 * string.length();
        }
        inputStream.skip(bigInteger.longValue() - (long)n);
        encodingChunk.setPosition(l);
        return encodingChunk;
    }
}

