/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkContainerReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.ContentBrandingReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.EncodingChunkReader;
import org.jaudiotagger.audio.asf.io.EncryptionChunkReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import org.jaudiotagger.audio.asf.io.LanguageListReader;
import org.jaudiotagger.audio.asf.io.MetadataReader;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.StreamBitratePropertiesReader;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfHeaderReader
extends ChunkContainerReader<AsfHeader> {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_HEADER};
    private static final AsfHeaderReader FULL_READER;
    private static final AsfHeaderReader INFO_READER;
    private static final AsfHeaderReader TAG_READER;

    private static InputStream createStream(RandomAccessFile randomAccessFile) {
        return new FullRequestInputStream(new BufferedInputStream(new RandomAccessFileInputstream(randomAccessFile)));
    }

    public static AsfHeader readHeader(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        AsfHeader asfHeader = (AsfHeader)FULL_READER.read(Utils.readGUID(fileInputStream), fileInputStream, 0L);
        ((InputStream)fileInputStream).close();
        return asfHeader;
    }

    public static AsfHeader readHeader(RandomAccessFile randomAccessFile) throws IOException {
        InputStream inputStream = AsfHeaderReader.createStream(randomAccessFile);
        return (AsfHeader)FULL_READER.read(Utils.readGUID(inputStream), inputStream, 0L);
    }

    public static AsfHeader readInfoHeader(RandomAccessFile randomAccessFile) throws IOException {
        InputStream inputStream = AsfHeaderReader.createStream(randomAccessFile);
        return (AsfHeader)INFO_READER.read(Utils.readGUID(inputStream), inputStream, 0L);
    }

    public static AsfHeader readTagHeader(RandomAccessFile randomAccessFile) throws IOException {
        InputStream inputStream = AsfHeaderReader.createStream(randomAccessFile);
        return (AsfHeader)TAG_READER.read(Utils.readGUID(inputStream), inputStream, 0L);
    }

    public AsfHeaderReader(List<Class<? extends ChunkReader>> list, boolean bl) {
        super(list, bl);
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    protected AsfHeader createContainer(long l, BigInteger bigInteger, InputStream inputStream) throws IOException {
        long l2 = Utils.readUINT32(inputStream);
        if (inputStream.read() != 1) {
            throw new IOException("No ASF");
        }
        if (inputStream.read() != 2) {
            throw new IOException("No ASF");
        }
        return new AsfHeader(l, bigInteger, l2);
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    public void setExtendedHeaderReader(AsfExtHeaderReader asfExtHeaderReader) {
        for (GUID gUID : asfExtHeaderReader.getApplyingIds()) {
            this.readerMap.put(gUID, asfExtHeaderReader);
        }
    }

    static {
        ArrayList<Class<? extends ChunkReader>> arrayList = new ArrayList<Class<? extends ChunkReader>>();
        arrayList.add(FileHeaderReader.class);
        arrayList.add(StreamChunkReader.class);
        INFO_READER = new AsfHeaderReader(arrayList, true);
        arrayList.clear();
        arrayList.add(ContentDescriptionReader.class);
        arrayList.add(ContentBrandingReader.class);
        arrayList.add(LanguageListReader.class);
        arrayList.add(MetadataReader.class);
        AsfExtHeaderReader asfExtHeaderReader = new AsfExtHeaderReader(arrayList, true);
        AsfExtHeaderReader asfExtHeaderReader2 = new AsfExtHeaderReader(arrayList, true);
        TAG_READER = new AsfHeaderReader(arrayList, true);
        TAG_READER.setExtendedHeaderReader(asfExtHeaderReader);
        arrayList.add(FileHeaderReader.class);
        arrayList.add(StreamChunkReader.class);
        arrayList.add(EncodingChunkReader.class);
        arrayList.add(EncryptionChunkReader.class);
        arrayList.add(StreamBitratePropertiesReader.class);
        FULL_READER = new AsfHeaderReader(arrayList, false);
        FULL_READER.setExtendedHeaderReader(asfExtHeaderReader2);
    }
}

