/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfExtendedHeader;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.EncryptionChunk;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public final class AsfHeader
extends ChunkContainer {
    public static final Charset ASF_CHARSET = Charset.forName("UTF-16LE");
    public static final byte[] ZERO_TERM = new byte[]{0, 0};
    private final long chunkCount;

    public AsfHeader(long l, BigInteger bigInteger, long l2) {
        super(GUID.GUID_HEADER, l, bigInteger);
        this.chunkCount = l2;
    }

    public ContentDescription findContentDescription() {
        ContentDescription contentDescription = this.getContentDescription();
        if (contentDescription == null && this.getExtendedHeader() != null) {
            contentDescription = this.getExtendedHeader().getContentDescription();
        }
        return contentDescription;
    }

    public MetadataContainer findExtendedContentDescription() {
        MetadataContainer metadataContainer = this.getExtendedContentDescription();
        if (metadataContainer == null && this.getExtendedHeader() != null) {
            metadataContainer = this.getExtendedHeader().getExtendedContentDescription();
        }
        return metadataContainer;
    }

    public MetadataContainer findMetadataContainer(ContainerType containerType) {
        MetadataContainer metadataContainer = (MetadataContainer)this.getFirst(containerType.getContainerGUID(), MetadataContainer.class);
        if (metadataContainer == null) {
            metadataContainer = (MetadataContainer)this.getExtendedHeader().getFirst(containerType.getContainerGUID(), MetadataContainer.class);
        }
        return metadataContainer;
    }

    public AudioStreamChunk getAudioStreamChunk() {
        AudioStreamChunk audioStreamChunk = null;
        List<Chunk> list = this.assertChunkList(GUID.GUID_STREAM);
        for (int i = 0; i < list.size() && audioStreamChunk == null; ++i) {
            if (!(list.get(i) instanceof AudioStreamChunk)) continue;
            audioStreamChunk = (AudioStreamChunk)list.get(i);
        }
        return audioStreamChunk;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public ContentDescription getContentDescription() {
        return (ContentDescription)this.getFirst(GUID.GUID_CONTENTDESCRIPTION, ContentDescription.class);
    }

    public EncodingChunk getEncodingChunk() {
        return (EncodingChunk)this.getFirst(GUID.GUID_ENCODING, EncodingChunk.class);
    }

    public EncryptionChunk getEncryptionChunk() {
        return (EncryptionChunk)this.getFirst(GUID.GUID_CONTENT_ENCRYPTION, EncryptionChunk.class);
    }

    public MetadataContainer getExtendedContentDescription() {
        return (MetadataContainer)this.getFirst(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, MetadataContainer.class);
    }

    public AsfExtendedHeader getExtendedHeader() {
        return (AsfExtendedHeader)this.getFirst(GUID.GUID_HEADER_EXTENSION, AsfExtendedHeader.class);
    }

    public FileHeader getFileHeader() {
        return (FileHeader)this.getFirst(GUID.GUID_FILE, FileHeader.class);
    }

    public StreamBitratePropertiesChunk getStreamBitratePropertiesChunk() {
        return (StreamBitratePropertiesChunk)this.getFirst(GUID.GUID_STREAM_BITRATE_PROPERTIES, StreamBitratePropertiesChunk.class);
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string, string + "  | : Contains: \"" + this.getChunkCount() + "\" chunks" + Utils.LINE_SEPARATOR));
        return stringBuilder.toString();
    }

    static {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.add(GUID.GUID_STREAM);
    }
}

