/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.generic.Utils;

public class CommonChunk
extends Chunk {
    private AiffAudioHeader aiffHeader;

    public CommonChunk(ChunkHeader chunkHeader, RandomAccessFile randomAccessFile, AiffAudioHeader aiffAudioHeader) {
        super(randomAccessFile, chunkHeader);
        this.aiffHeader = aiffAudioHeader;
    }

    @Override
    public boolean readChunk() throws IOException {
        int n = Utils.readUint16(this.raf);
        long l = Utils.readUint32(this.raf);
        int n2 = Utils.readUint16(this.raf);
        this.bytesLeft -= 8L;
        String string = null;
        String string2 = null;
        double d = AiffUtil.read80BitDouble(this.raf);
        this.bytesLeft -= 10L;
        if (this.aiffHeader.getFileType() == AiffAudioHeader.FileType.AIFCTYPE) {
            if (this.bytesLeft == 0L) {
                return false;
            }
            string = AiffUtil.read4Chars(this.raf);
            if (string.equals("sowt")) {
                this.aiffHeader.setEndian(AiffAudioHeader.Endian.LITTLE_ENDIAN);
            }
            this.bytesLeft -= 4L;
            string2 = AiffUtil.readPascalString(this.raf);
            this.bytesLeft -= (long)(string2.length() + 1);
        }
        this.aiffHeader.setBitsPerSample(n2);
        this.aiffHeader.setSamplingRate((int)d);
        this.aiffHeader.setChannelNumber(n);
        this.aiffHeader.setLength((int)((double)l / d));
        this.aiffHeader.setPreciseLength((float)((double)l / d));
        this.aiffHeader.setLossless(true);
        if (string != null) {
            if (!string.equals("NONE")) {
                if (string.equals("raw ")) {
                    string2 = "PCM 8-bit offset-binary";
                } else if (string.equals("twos")) {
                    string2 = "PCM 16-bit twos-complement big-endian";
                } else if (string.equals("sowt")) {
                    string2 = "PCM 16-bit twos-complement little-endian";
                } else if (string.equals("fl32")) {
                    string2 = "PCM 32-bit integer";
                } else if (string.equals("fl64")) {
                    string2 = "PCM 64-bit floating point";
                } else if (string.equals("in24")) {
                    string2 = "PCM 24-bit integer";
                } else if (string.equals("in32")) {
                    string2 = "PCM 32-bit integer";
                } else {
                    this.aiffHeader.setLossless(false);
                }
            }
            this.aiffHeader.setAudioEncoding(string2);
            String string3 = string2;
            if (string3 == null || string3.length() == 0) {
                string3 = string;
            }
        }
        return true;
    }
}

