/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import org.jaudiotagger.audio.aiff.AiffTagFieldKey;
import org.jaudiotagger.audio.generic.GenericTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class AiffTag
extends GenericTag {
    public boolean hasField(AiffTagFieldKey aiffTagFieldKey) {
        return this.hasField(aiffTagFieldKey.name());
    }

    public void setField(AiffTagFieldKey aiffTagFieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(aiffTagFieldKey, string);
        this.setField(tagField);
    }

    public TagField createField(AiffTagFieldKey aiffTagFieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        return new AiffTagTextField(aiffTagFieldKey.name(), string);
    }

    private class AiffTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public AiffTagTextField(String string, String string2) {
            this.id = string;
            this.content = string2;
        }

        @Override
        public void copyContent(TagField tagField) {
            if (tagField instanceof TagTextField) {
                this.content = ((TagTextField)tagField).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getEncoding() {
            return "ISO-8859-1";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean bl) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.content.equals("");
        }

        @Override
        public void setContent(String string) {
            this.content = string;
        }

        @Override
        public void setEncoding(String string) {
        }

        @Override
        public String toString() {
            return this.getContent();
        }
    }
}

