/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.TagException;

public class AiffFile
extends AudioFile {
    public static final SimpleDateFormat ISO_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public AiffFile() {
    }

    public AiffFile(String string) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(new File(string));
    }

    public AiffFile(File file) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AiffFile(File file, boolean bl) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        try (RandomAccessFile randomAccessFile = null;){
            logger.setLevel(Level.FINEST);
            logger.fine("Called AiffFile constructor on " + file.getAbsolutePath());
            this.file = file;
            randomAccessFile = this.checkFilePermissions(file, bl);
            this.audioHeader = new AiffAudioHeader();
        }
    }

    public AiffAudioHeader getAiffAudioHeader() {
        return (AiffAudioHeader)this.audioHeader;
    }
}

