/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileFilter;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.generic.Utils;

public class AudioFileFilter
implements FileFilter {
    private final boolean allowDirectories;

    public AudioFileFilter(boolean bl) {
        this.allowDirectories = bl;
    }

    public AudioFileFilter() {
        this(true);
    }

    @Override
    public boolean accept(File file) {
        if (file.isHidden() || !file.canRead()) {
            return false;
        }
        if (file.isDirectory()) {
            return this.allowDirectories;
        }
        String string = Utils.getExtension(file);
        try {
            if (SupportedFileFormat.valueOf(string.toUpperCase()) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return false;
    }
}

