/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.HashMap;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

@ThreadSafe
public class BasicCredentialsProvider
implements CredentialsProvider {
    @GuardedBy(value="this")
    private final HashMap<AuthScope, Credentials> credMap = new HashMap();

    @Override
    public synchronized void setCredentials(AuthScope authScope, Credentials credentials) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        this.credMap.put(authScope, credentials);
    }

    private static Credentials matchCredentials(HashMap<AuthScope, Credentials> hashMap, AuthScope authScope) {
        Credentials credentials = hashMap.get(authScope);
        if (credentials == null) {
            int n = -1;
            AuthScope authScope2 = null;
            for (AuthScope authScope3 : hashMap.keySet()) {
                int n2 = authScope.match(authScope3);
                if (n2 <= n) continue;
                n = n2;
                authScope2 = authScope3;
            }
            if (authScope2 != null) {
                credentials = hashMap.get(authScope2);
            }
        }
        return credentials;
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return BasicCredentialsProvider.matchCredentials(this.credMap, authScope);
    }

    public String toString() {
        return this.credMap.toString();
    }

    @Override
    public synchronized void clear() {
        this.credMap.clear();
    }
}

