/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("ntlm", "digest", "basic"));

    protected Map<String, Header> parseChallenges(Header[] headerArray) throws MalformedChallengeException {
        HashMap<String, Header> hashMap = new HashMap<String, Header>(headerArray.length);
        for (Header header : headerArray) {
            int n;
            CharArrayBuffer charArrayBuffer;
            if (header instanceof FormattedHeader) {
                charArrayBuffer = ((FormattedHeader)header).getBuffer();
                n = ((FormattedHeader)header).getValuePos();
            } else {
                String string = header.getValue();
                if (string == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                charArrayBuffer = new CharArrayBuffer(string.length());
                charArrayBuffer.append(string);
                n = 0;
            }
            while (n < charArrayBuffer.length() && HTTP.isWhitespace((char)charArrayBuffer.charAt(n))) {
                ++n;
            }
            int n2 = n;
            while (n < charArrayBuffer.length() && !HTTP.isWhitespace((char)charArrayBuffer.charAt(n))) {
                ++n;
            }
            int n3 = n;
            String string = charArrayBuffer.substring(n2, n3);
            hashMap.put(string.toLowerCase(Locale.ENGLISH), header);
        }
        return hashMap;
    }

    protected List<String> getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> map, HttpResponse httpResponse, HttpContext httpContext) throws AuthenticationException {
        AuthSchemeRegistry authSchemeRegistry = (AuthSchemeRegistry)httpContext.getAttribute("http.authscheme-registry");
        if (authSchemeRegistry == null) {
            throw new IllegalStateException("AuthScheme registry not set in HTTP context");
        }
        List<String> list = (List<String>)httpContext.getAttribute("http.auth.scheme-pref");
        if (list == null) {
            list = this.getAuthPreferences();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication schemes in the order of preference: " + list));
        }
        AuthScheme authScheme = null;
        for (String string : list) {
            Header header = map.get(string.toLowerCase(Locale.ENGLISH));
            if (header != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(string + " authentication scheme selected"));
                }
                try {
                    authScheme = authSchemeRegistry.getAuthScheme(string, httpResponse.getParams());
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("Authentication scheme " + string + " not supported"));
                    continue;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Challenge for " + string + " authentication scheme not available"));
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + map);
        }
        return authScheme;
    }
}

