/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class DigestScheme
extends RFC2617Scheme {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final String NC = "00000001";
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private int qopVariant = 0;
    private String cnonce;

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challange");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challange");
        }
        boolean bl = false;
        String string = this.getParameter("qop");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("auth")) {
                    this.qopVariant = 2;
                    break;
                }
                if (string2.equals("auth-int")) {
                    this.qopVariant = 1;
                    continue;
                }
                bl = true;
            }
        }
        if (bl && this.qopVariant == 0) {
            throw new MalformedChallengeException("None of the qop methods is supported");
        }
        this.cnonce = null;
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        String string = this.getParameter("stale");
        if ("true".equalsIgnoreCase(string)) {
            return false;
        }
        return this.complete;
    }

    @Override
    public String getSchemeName() {
        return "digest";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    public void overrideParamter(String string, String string2) {
        this.getParameters().put(string, string2);
    }

    private String getCnonce() {
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.createCnonce();
        }
        return this.cnonce;
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.getParameters().put("methodname", httpRequest.getRequestLine().getMethod());
        this.getParameters().put("uri", httpRequest.getRequestLine().getUri());
        String string = this.getParameter("charset");
        if (string == null) {
            string = AuthParams.getCredentialCharset(httpRequest.getParams());
            this.getParameters().put("charset", string);
        }
        String string2 = this.createDigest(credentials);
        return this.createDigestHeader(credentials, string2);
    }

    private static MessageDigest createMessageDigest(String string) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + string);
        }
    }

    private String createDigest(Credentials credentials) throws AuthenticationException {
        String string;
        CharSequence charSequence;
        CharSequence charSequence2;
        String string2;
        String string3;
        String string4;
        String string5 = this.getParameter("uri");
        String string6 = this.getParameter("realm");
        String string7 = this.getParameter("nonce");
        String string8 = this.getParameter("methodname");
        String string9 = this.getParameter("algorithm");
        if (string5 == null) {
            throw new IllegalStateException("URI may not be null");
        }
        if (string6 == null) {
            throw new IllegalStateException("Realm may not be null");
        }
        if (string7 == null) {
            throw new IllegalStateException("Nonce may not be null");
        }
        if (string9 == null) {
            string9 = "MD5";
        }
        if ((string4 = this.getParameter("charset")) == null) {
            string4 = "ISO-8859-1";
        }
        if (this.qopVariant == 1) {
            throw new AuthenticationException("Unsupported qop in HTTP Digest authentication");
        }
        String string10 = string9;
        if (string10.equalsIgnoreCase("MD5-sess")) {
            string10 = "MD5";
        }
        MessageDigest messageDigest = DigestScheme.createMessageDigest(string10);
        String string11 = credentials.getUserPrincipal().getName();
        String string12 = credentials.getPassword();
        StringBuilder stringBuilder = new StringBuilder(string11.length() + string6.length() + string12.length() + 2);
        stringBuilder.append(string11);
        stringBuilder.append(':');
        stringBuilder.append(string6);
        stringBuilder.append(':');
        stringBuilder.append(string12);
        String string13 = stringBuilder.toString();
        if (string9.equalsIgnoreCase("MD5-sess")) {
            string9 = "MD5";
            string3 = this.getCnonce();
            string2 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getBytes((String)string13, (String)string4)));
            charSequence2 = new StringBuilder(string2.length() + string7.length() + string3.length() + 2);
            ((StringBuilder)charSequence2).append(string2);
            ((StringBuilder)charSequence2).append(':');
            ((StringBuilder)charSequence2).append(string7);
            ((StringBuilder)charSequence2).append(':');
            ((StringBuilder)charSequence2).append(string3);
            string13 = ((StringBuilder)charSequence2).toString();
        }
        string3 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getBytes((String)string13, (String)string4)));
        string2 = null;
        if (this.qopVariant != 1) {
            string2 = string8 + ':' + string5;
        }
        charSequence2 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getAsciiBytes((String)string2)));
        if (this.qopVariant == 0) {
            charSequence = new StringBuilder(string3.length() + string7.length() + string3.length());
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append(':');
            ((StringBuilder)charSequence).append(string7);
            ((StringBuilder)charSequence).append(':');
            ((StringBuilder)charSequence).append((String)charSequence2);
            string = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = this.getQopVariantString();
            String string14 = this.getCnonce();
            StringBuilder stringBuilder2 = new StringBuilder(string3.length() + string7.length() + NC.length() + string14.length() + ((String)charSequence).length() + ((String)charSequence2).length() + 5);
            stringBuilder2.append(string3);
            stringBuilder2.append(':');
            stringBuilder2.append(string7);
            stringBuilder2.append(':');
            stringBuilder2.append(NC);
            stringBuilder2.append(':');
            stringBuilder2.append(string14);
            stringBuilder2.append(':');
            stringBuilder2.append((String)charSequence);
            stringBuilder2.append(':');
            stringBuilder2.append((String)charSequence2);
            string = stringBuilder2.toString();
        }
        charSequence = DigestScheme.encode(messageDigest.digest(EncodingUtils.getAsciiBytes((String)string)));
        return charSequence;
    }

    private Header createDigestHeader(Credentials credentials, String string) {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(128);
        if (this.isProxy()) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": Digest ");
        String string2 = this.getParameter("uri");
        String string3 = this.getParameter("realm");
        String string4 = this.getParameter("nonce");
        String string5 = this.getParameter("opaque");
        String string6 = string;
        String string7 = this.getParameter("algorithm");
        String string8 = credentials.getUserPrincipal().getName();
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(20);
        arrayList.add(new BasicNameValuePair("username", string8));
        arrayList.add(new BasicNameValuePair("realm", string3));
        arrayList.add(new BasicNameValuePair("nonce", string4));
        arrayList.add(new BasicNameValuePair("uri", string2));
        arrayList.add(new BasicNameValuePair("response", string6));
        if (this.qopVariant != 0) {
            arrayList.add(new BasicNameValuePair("qop", this.getQopVariantString()));
            arrayList.add(new BasicNameValuePair("nc", NC));
            arrayList.add(new BasicNameValuePair("cnonce", this.getCnonce()));
        }
        if (string7 != null) {
            arrayList.add(new BasicNameValuePair("algorithm", string7));
        }
        if (string5 != null) {
            arrayList.add(new BasicNameValuePair("opaque", string5));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicNameValuePair basicNameValuePair = (BasicNameValuePair)arrayList.get(i);
            if (i > 0) {
                charArrayBuffer.append(", ");
            }
            boolean bl = "nc".equals(basicNameValuePair.getName()) || "qop".equals(basicNameValuePair.getName());
            BasicHeaderValueFormatter.DEFAULT.formatNameValuePair(charArrayBuffer, (NameValuePair)basicNameValuePair, !bl);
        }
        return new BufferedHeader(charArrayBuffer);
    }

    private String getQopVariantString() {
        String string = this.qopVariant == 1 ? "auth-int" : "auth";
        return string;
    }

    private static String encode(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xF;
            int n3 = (byArray[i] & 0xF0) >> 4;
            cArray[i * 2] = HEXADECIMAL[n3];
            cArray[i * 2 + 1] = HEXADECIMAL[n2];
        }
        return new String(cArray);
    }

    public static String createCnonce() {
        MessageDigest messageDigest = DigestScheme.createMessageDigest("MD5");
        String string = Long.toString(System.currentTimeMillis());
        string = DigestScheme.encode(messageDigest.digest(EncodingUtils.getAsciiBytes((String)string)));
        return string;
    }
}

