/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    @Override
    public String getSchemeName() {
        return "basic";
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String string = AuthParams.getCredentialCharset(httpRequest.getParams());
        return BasicScheme.authenticate(credentials, string, this.isProxy());
    }

    public static Header authenticate(Credentials credentials, String string, boolean bl) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(credentials.getUserPrincipal().getName());
        stringBuilder.append(":");
        stringBuilder.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] byArray = new byte[]{};
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        if (bl) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": Basic ");
        charArrayBuffer.append(byArray, 0, byArray.length);
        return new BufferedHeader(charArrayBuffer);
    }
}

