/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.params.HttpParams;

@ThreadSafe
public final class CookieSpecRegistry {
    @GuardedBy(value="this")
    private final Map<String, CookieSpecFactory> registeredSpecs = new LinkedHashMap<String, CookieSpecFactory>();

    public synchronized void register(String string, CookieSpecFactory cookieSpecFactory) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (cookieSpecFactory == null) {
            throw new IllegalArgumentException("Cookie spec factory may not be null");
        }
        this.registeredSpecs.put(string.toLowerCase(Locale.ENGLISH), cookieSpecFactory);
    }

    public synchronized void unregister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        this.registeredSpecs.remove(string.toLowerCase(Locale.ENGLISH));
    }

    public synchronized CookieSpec getCookieSpec(String string, HttpParams httpParams) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        CookieSpecFactory cookieSpecFactory = this.registeredSpecs.get(string.toLowerCase(Locale.ENGLISH));
        if (cookieSpecFactory != null) {
            return cookieSpecFactory.newInstance(httpParams);
        }
        throw new IllegalStateException("Unsupported cookie spec: " + string);
    }

    public synchronized CookieSpec getCookieSpec(String string) throws IllegalStateException {
        return this.getCookieSpec(string, null);
    }

    public synchronized List<String> getSpecNames() {
        return new ArrayList<String>(this.registeredSpecs.keySet());
    }

    public synchronized void setItems(Map<String, CookieSpecFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSpecs.clear();
        this.registeredSpecs.putAll(map);
    }
}

