/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import org.apache.http.client.utils.Idn;

@Immutable
public class Rfc3492Idn
implements Idn {
    private static final int base = 36;
    private static final int tmin = 1;
    private static final int tmax = 26;
    private static final int skew = 38;
    private static final int damp = 700;
    private static final int initial_bias = 72;
    private static final int initial_n = 128;
    private static final char delimiter = '-';
    private static final String ACE_PREFIX = "xn--";

    private int adapt(int n, int n2, boolean bl) {
        n = bl ? (n /= 700) : (n /= 2);
        n += n / n2;
        int n3 = 0;
        while (n > 455) {
            n /= 35;
            n3 += 36;
        }
        return n3 + 36 * n / (n + 38);
    }

    private int digit(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 26;
        }
        throw new IllegalArgumentException("illegal digit: " + c);
    }

    @Override
    public String toUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            if (string2.startsWith(ACE_PREFIX)) {
                string2 = this.decode(string2.substring(4));
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected String decode(String string) {
        int n = 128;
        int n2 = 0;
        int n3 = 72;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n4 = string.lastIndexOf(45);
        if (n4 != -1) {
            stringBuffer.append(string.subSequence(0, n4));
            string = string.substring(n4 + 1);
        }
        while (string.length() > 0) {
            int n5 = n2;
            int n6 = 1;
            int n7 = 36;
            while (string.length() != 0) {
                char c = string.charAt(0);
                string = string.substring(1);
                int n8 = this.digit(c);
                n2 += n8 * n6;
                int n9 = n7 <= n3 + 1 ? 1 : (n7 >= n3 + 26 ? 26 : n7 - n3);
                if (n8 < n9) break;
                n6 *= 36 - n9;
                n7 += 36;
            }
            n3 = this.adapt(n2 - n5, stringBuffer.length() + 1, n5 == 0);
            n += n2 / (stringBuffer.length() + 1);
            stringBuffer.insert(n2 %= stringBuffer.length() + 1, (char)n);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

