/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.security.Principal;
import net.jcip.annotations.Immutable;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;
import org.apache.http.util.LangUtils;

@Immutable
public class UsernamePasswordCredentials
implements Credentials {
    private final BasicUserPrincipal principal;
    private final String password;

    public UsernamePasswordCredentials(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Username:password string may not be null");
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            this.principal = new BasicUserPrincipal(string.substring(0, n));
            this.password = string.substring(n + 1);
        } else {
            this.principal = new BasicUserPrincipal(string);
            this.password = null;
        }
    }

    public UsernamePasswordCredentials(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.principal = new BasicUserPrincipal(string);
        this.password = string2;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getName();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)object;
            if (LangUtils.equals((Object)this.principal, (Object)usernamePasswordCredentials.principal)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.principal.toString();
    }
}

